/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.util;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameData;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import tehnut.resourceful.crops.api.base.Compat;
import tehnut.resourceful.crops.api.base.CompatBuilder;
import tehnut.resourceful.crops.api.base.Seed;
import tehnut.resourceful.crops.api.base.SeedBuilder;
import tehnut.resourceful.crops.api.compat.CompatibilitySeed;
import tehnut.resourceful.crops.api.registry.SeedRegistry;
import tehnut.resourceful.crops.api.util.BlockStack;
import tehnut.resourceful.crops.util.helper.LogHelper;
import tehnut.resourceful.crops.util.serialization.SeedCreator;

public class StartupUtils {
    private static List<Seed> defaultSeeds = new ArrayList<Seed>();

    public static void initDefaults() {
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Inky", 1, 4, "dyeBlack", new ItemStack(StartupUtils.getOreStack("dyeBlack").getItem(), 8, StartupUtils.getOreStack("dyeBlack").getItemDamage()), new Color(22, 22, 22), StartupUtils.getCompat(30)), "dyeBlack");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Fleshy", 1, 4, StartupUtils.getItemString(Items.rotten_flesh), new ItemStack(Items.rotten_flesh, 8), new Color(255, 160, 136), StartupUtils.getCompat(30)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Feathery", 1, 4, StartupUtils.getItemString(Items.feather), new ItemStack(Items.feather, 8), new Color(208, 203, 199), StartupUtils.getCompat(30)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Tin", 2, 4, "ingotTin", new ItemStack(StartupUtils.getOreStack("ingotTin").getItem(), 4, StartupUtils.getOreStack("ingotTin").getItemDamage()), new Color(135, 154, 168)), "ingotTin");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Copper", 2, 4, "ingotCopper", new ItemStack(StartupUtils.getOreStack("ingotCopper").getItem(), 4, StartupUtils.getOreStack("ingotCopper").getItemDamage()), new Color(204, 102, 51)), "ingotCopper");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Aluminum", 2, 4, "ingotAluminum", new ItemStack(StartupUtils.getOreStack("ingotAluminum").getItem(), 4, StartupUtils.getOreStack("ingotAluminum").getItemDamage()), new Color(198, 206, 130)), "ingotAluminum");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Zinc", 2, 4, "ingotZinc", new ItemStack(StartupUtils.getOreStack("ingotZinc").getItem(), 4, StartupUtils.getOreStack("ingotZinc").getItemDamage()), new Color(192, 176, 182)), "ingotZinc");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Coal", 2, 4, StartupUtils.getItemString(Items.coal), new ItemStack(Items.coal, 4), new Color(45, 44, 47)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Charcoal", 2, 4, StartupUtils.getItemString(Items.coal, 1), new ItemStack(Items.coal, 4, 1), new Color(45, 44, 47)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Saltpeter", 2, 4, "dustSaltpeter", new ItemStack(StartupUtils.getOreStack("dustSaltpeter").getItem(), 8, StartupUtils.getOreStack("dustSaltpeter").getItemDamage()), new Color(182, 197, 212)), "dustSaltpeter");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Salt", 2, 4, "dustSalt", new ItemStack(StartupUtils.getOreStack("dustSalt").getItem(), 8, StartupUtils.getOreStack("dustSalt").getItemDamage()), new Color(182, 197, 212)), "dustSalt");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Leathery", 2, 4, StartupUtils.getItemString(Items.leather), new ItemStack(Items.leather, 4), new Color(255, 68, 17)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Stringy", 2, 4, StartupUtils.getItemString(Items.string), new ItemStack(Items.string, 8), new Color(241, 255, 210)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Boney", 2, 4, StartupUtils.getItemString(Items.bone), new ItemStack(Items.bone, 4), new Color(255, 240, 205)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Slimey", 2, 4, StartupUtils.getItemString(Items.slime_ball), new ItemStack(Items.slime_ball, 4), new Color(62, 255, 119)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Blaze", 3, 4, StartupUtils.getItemString(Items.blaze_rod), new ItemStack(Items.blaze_rod, 2), new Color(255, 215, 66)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Iron", 3, 4, "ingotIron", new ItemStack(StartupUtils.getOreStack("ingotIron").getItem(), 4, StartupUtils.getOreStack("ingotIron").getItemDamage()), new Color(159, 156, 160)), "ingotIron");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Gold", 3, 4, "ingotGold", new ItemStack(StartupUtils.getOreStack("ingotGold").getItem(), 4, StartupUtils.getOreStack("ingotGold").getItemDamage()), new Color(255, 255, 0)), "ingotGold");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Lead", 3, 4, "ingotLead", new ItemStack(StartupUtils.getOreStack("ingotLead").getItem(), 4, StartupUtils.getOreStack("ingotLead").getItemDamage()), new Color(102, 102, 153)), "ingotLead");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Silver", 3, 4, "ingotSilver", new ItemStack(StartupUtils.getOreStack("ingotSilver").getItem(), 4, StartupUtils.getOreStack("ingotSilver").getItemDamage()), new Color(187, 189, 184)), "ingotSilver");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Nickel", 3, 4, "ingotNickel", new ItemStack(StartupUtils.getOreStack("ingotNickel").getItem(), 4, StartupUtils.getOreStack("ingotNickel").getItemDamage()), new Color(204, 204, 204)), "ingotNickel");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Mithril", 3, 4, "ingotMithril", new ItemStack(StartupUtils.getOreStack("ingotMithril").getItem(), 4, StartupUtils.getOreStack("ingotMithril").getItemDamage()), new Color(146, 164, 208)), "ingotMithril");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Osmium", 3, 4, "ingotOsmium", new ItemStack(StartupUtils.getOreStack("ingotOsmium").getItem(), 4, StartupUtils.getOreStack("ingotOsmium").getItemDamage()), new Color(68, 60, 190)), "ingotOsmium");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Ender", 3, 4, StartupUtils.getItemString(Items.ender_pearl), new ItemStack(Items.ender_pearl, 2), new Color(72, 100, 97)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Teary", 3, 4, StartupUtils.getItemString(Items.ghast_tear), new ItemStack(Items.ghast_tear, 4), new Color(212, 255, 241)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Creepy", 3, 4, StartupUtils.getItemString(Items.gunpowder), new ItemStack(Items.gunpowder, 8), new Color(0, 255, 33)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Skelesprout", 3, 2, StartupUtils.getItemString(Items.skull), new ItemStack(Items.skull, 1), new Color(159, 164, 155)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Brainy", 3, 2, StartupUtils.getItemString(Items.skull, 2), new ItemStack(Items.skull, 1, 2), new Color(49, 105, 50)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Mindful", 3, 2, StartupUtils.getItemString(Items.skull, 3), new ItemStack(Items.skull, 1, 3), new Color(232, 186, 131)));
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Creepots", 3, 2, StartupUtils.getItemString(Items.skull, 4), new ItemStack(Items.skull, 1, 4), new Color(71, 178, 74)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Glowstone", 3, 4, "dustGlowstone", new ItemStack(StartupUtils.getOreStack("dustGlowstone").getItem(), 8, StartupUtils.getOreStack("dustGlowstone").getItemDamage()), new Color(233, 255, 84)), "dustGlowstone");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Redstone", 3, 4, "dustRedstone", new ItemStack(StartupUtils.getOreStack("dustRedstone").getItem(), 8, StartupUtils.getOreStack("dustRedstone").getItemDamage()), new Color(159, 13, 0)), "dustRedstone");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Sulfur", 3, 4, "dustSulfur", new ItemStack(StartupUtils.getOreStack("dustSulfur").getItem(), 8, StartupUtils.getOreStack("dustSulfur").getItemDamage()), new Color(212, 190, 85)), "dustSulfur");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Lapis", 3, 4, "gemLapis", new ItemStack(StartupUtils.getOreStack("gemLapis").getItem(), 8, StartupUtils.getOreStack("gemLapis").getItemDamage()), new Color(63, 71, 206)), "gemLapis");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Quartz", 3, 4, "gemQuartz", new ItemStack(StartupUtils.getOreStack("gemQuartz").getItem(), 4, StartupUtils.getOreStack("gemQuartz").getItemDamage()), new Color(255, 255, 255)), "gemQuartz");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Certus", 3, 4, "crystalCertusQuartz", new ItemStack(StartupUtils.getOreStack("crystalCertusQuartz").getItem(), 4, StartupUtils.getOreStack("crystalCertusQuartz").getItemDamage()), new Color(168, 204, 208)), "crystalCertusQuartz");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Ruby", 3, 4, "gemRuby", new ItemStack(StartupUtils.getOreStack("gemRuby").getItem(), 8, StartupUtils.getOreStack("gemRuby").getItemDamage()), new Color(212, 48, 55)), "gemRuby");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Peridot", 3, 4, "gemPeridot", new ItemStack(StartupUtils.getOreStack("gemPeridot").getItem(), 8, StartupUtils.getOreStack("gemPeridot").getItemDamage()), new Color(130, 212, 108)), "gemPeridot");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Topaz", 3, 4, "gemTopaz", new ItemStack(StartupUtils.getOreStack("gemTopaz").getItem(), 8, StartupUtils.getOreStack("gemTopaz").getItemDamage()), new Color(212, 143, 101)), "gemTopaz");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Tanzanite", 3, 4, "gemTanzanite", new ItemStack(StartupUtils.getOreStack("gemTanzanite").getItem(), 8, StartupUtils.getOreStack("gemTanzanite").getItemDamage()), new Color(42, 7, 96)), "gemTanzanite");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Malachite", 3, 4, "gemMalachite", new ItemStack(StartupUtils.getOreStack("gemMalachite").getItem(), 8, StartupUtils.getOreStack("gemMalachite").getItemDamage()), new Color(59, 255, 226)), "gemMalachite");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Sapphire", 3, 4, "gemSapphire", new ItemStack(StartupUtils.getOreStack("gemSapphire").getItem(), 8, StartupUtils.getOreStack("gemSapphire").getItemDamage()), new Color(88, 106, 212)), "gemSapphire");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Amber", 3, 4, "gemAmber", new ItemStack(StartupUtils.getOreStack("gemAmber").getItem(), 8, StartupUtils.getOreStack("gemAmber").getItemDamage()), new Color(212, 121, 60)), "gemAmber");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Apatite", 3, 4, "gemApatite", new ItemStack(StartupUtils.getOreStack("gemApatite").getItem(), 8, StartupUtils.getOreStack("gemApatite").getItemDamage()), new Color(121, 188, 212)), "gemApatite");
        StartupUtils.addDefaultSeed(StartupUtils.makeSeed("Witherwheat", 4, 2, StartupUtils.getItemString(Items.skull, 1), new ItemStack(Items.skull, 1, 1), new Color(52, 52, 51)));
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Diamond", 4, 2, "gemDiamond", new ItemStack(StartupUtils.getOreStack("gemDiamond").getItem(), 1, StartupUtils.getOreStack("gemDiamond").getItemDamage()), new Color(58, 242, 239)), "gemDiamond");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Emerald", 4, 2, "gemEmerald", new ItemStack(StartupUtils.getOreStack("gemEmerald").getItem(), 1, StartupUtils.getOreStack("gemEmerald").getItemDamage()), new Color(87, 242, 111)), "gemEmerald");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Platinum", 4, 2, "ingotPlatinum", new ItemStack(StartupUtils.getOreStack("ingotPlatinum").getItem(), 1, StartupUtils.getOreStack("ingotPlatinum").getItemDamage()), new Color(30, 208, 243)), "ingotPlatinum");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Yellorium", 4, 2, "ingotYellorium", new ItemStack(StartupUtils.getOreStack("ingotYellorium").getItem(), 2, StartupUtils.getOreStack("ingotYellorium").getItemDamage()), new Color(142, 160, 19)), "ingotYellorium");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Titanium", 4, 2, "ingotTitanium", new ItemStack(StartupUtils.getOreStack("ingotTitanium").getItem(), 1, StartupUtils.getOreStack("ingotTitanium").getItemDamage()), new Color(212, 165, 182)), "ingotTitanium");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Desh", 4, 2, "ingotDesh", new ItemStack(StartupUtils.getOreStack("ingotDesh").getItem(), 1, StartupUtils.getOreStack("ingotDesh").getItemDamage()), new Color(39, 39, 40)), "ingotDesh");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Cobalt", 4, 2, "ingotCobalt", new ItemStack(StartupUtils.getOreStack("ingotCobalt").getItem(), 1, StartupUtils.getOreStack("ingotCobalt").getItemDamage()), new Color(0, 60, 255)), "ingotCobalt");
        StartupUtils.addDefaultSeedOre(StartupUtils.makeSeed("Ardite", 4, 2, "ingotArdite", new ItemStack(StartupUtils.getOreStack("ingotArdite").getItem(), 1, StartupUtils.getOreStack("ingotArdite").getItemDamage()), new Color(255, 102, 0)), "ingotArdite");
        for (CompatibilitySeed compatSeed : CompatibilitySeed.values()) {
            StartupUtils.addDefaultSeedMod(compatSeed);
        }
        SeedCreator.createJsonFromSeeds(SeedRegistry.seedBuilder, defaultSeeds, "DefaultSeeds");
    }

    private static Seed makeSeed(String name, int tier, int amount, String input, ItemStack output, Color color, Compat compat) {
        SeedBuilder builder = new SeedBuilder();
        builder.setName(name);
        builder.setTier(tier);
        builder.setAmount(amount);
        builder.setInput(input);
        builder.setOutput(output);
        builder.setColor(color);
        builder.setCompat(compat);
        return builder.build();
    }

    private static Seed makeSeed(String name, int tier, int amount, String input, ItemStack output, Color color) {
        return StartupUtils.makeSeed(name, tier, amount, input, output, color, null);
    }

    private static void addDefaultSeedMod(CompatibilitySeed compatibilitySeed) {
        LogHelper.info("Adding compatibility Seed for { " + compatibilitySeed.getModid() + " }");
        if (Loader.isModLoaded((String)compatibilitySeed.getModid()) && compatibilitySeed.getConfig()) {
            defaultSeeds.add(compatibilitySeed.getCompatSeed());
        }
    }

    private static void addDefaultSeedOre(Seed seed, String ore) {
        if (OreDictionary.doesOreNameExist((String)ore)) {
            defaultSeeds.add(seed);
        }
    }

    private static void addDefaultSeed(Seed seed) {
        String[] split = seed.getInput().split(":");
        if (GameData.getItemRegistry().containsKey(split[0] + ":" + split[1])) {
            defaultSeeds.add(seed);
        }
    }

    private static String getItemString(Item item) {
        return GameData.getItemRegistry().getNameForObject((Object)item) + ":0#0";
    }

    private static String getItemString(Item item, int meta) {
        return GameData.getItemRegistry().getNameForObject((Object)item) + ":" + meta + "#0";
    }

    private static ItemStack getOreStack(String entry) {
        if (OreDictionary.getOreNames().length != 0 && OreDictionary.doesOreNameExist((String)entry)) {
            if (OreDictionary.getOres((String)entry).size() != 0) {
                return (ItemStack)OreDictionary.getOres((String)entry).get(0);
            }
            return new ItemStack((Block)Blocks.fire);
        }
        return new ItemStack((Block)Blocks.fire);
    }

    private static Compat getCompat(int sieveChance) {
        return new CompatBuilder().setCompatExNihilio(new CompatBuilder.CompatExNihilioBuilder().setSourceBlock(new BlockStack(Blocks.dirt)).setSieveChance(sieveChance).build()).build();
    }
}

