/*
 * Decompiled with CFR 0.152.
 */
package tehnut.resourceful.crops.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import tehnut.resourceful.crops.ResourcefulCrops;
import tehnut.resourceful.crops.api.ModInformation;

public class ItemMaterial
extends Item {
    String[] materials = new String[]{"", ".mundane", ".magical", ".infused", ".arcane"};
    IIcon[] icons = new IIcon[this.materials.length];

    public ItemMaterial() {
        this.setUnlocalizedName("ResourcefulCrops.dust");
        this.setCreativeTab(ResourcefulCrops.tabResourcefulCrops);
        this.setHasSubtypes(true);
    }

    public String getUnlocalizedName(ItemStack stack) {
        return this.getUnlocalizedName() + this.materials[stack.getItemDamage() % this.materials.length];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < this.materials.length; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        for (int i = 0; i < this.materials.length; ++i) {
            this.icons[i] = register.registerIcon(ModInformation.TEXLOC + "dust_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return stack.getItemDamage() == 4;
    }

    public EnumRarity getRarity(ItemStack stack) {
        switch (stack.getItemDamage()) {
            case 0: {
                return EnumRarity.common;
            }
            case 1: {
                return EnumRarity.common;
            }
            case 2: {
                return EnumRarity.uncommon;
            }
            case 3: {
                return EnumRarity.rare;
            }
            case 4: {
                return EnumRarity.epic;
            }
        }
        return EnumRarity.common;
    }
}

