/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.transform;

import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class Scale
implements Transformation {
    private double x;
    private double y;
    private double z;
    private Vec3d center = Vec3d.center;

    public Scale(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Scale(double x, double y, double z, Vec3d center) {
        this(x, y, z);
        this.center = center;
    }

    @Override
    public Vec3d apply(Vec3d point) {
        return point.clone().sub(this.center).mul(this.x, this.y, this.z).add(this.center);
    }

    @Override
    public Vec3dCube apply(Vec3dCube cube) {
        return new Vec3dCube(this.apply(cube.getMin()), this.apply(cube.getMax()));
    }
}

