/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.texture;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import uk.co.qmunity.lib.texture.Layout;

public class SimplifiedLayout {
    private Layout layout;
    private int color;
    private List<Rectangle> rect = new ArrayList<Rectangle>();

    protected SimplifiedLayout(Layout layout, int color) {
        this.layout = layout;
        this.color = color;
        this.simplify();
    }

    private void simplify() {
        BufferedImage img = this.layout.getLayout(this.color);
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int y_;
                boolean problem;
                int rgb_;
                int x_;
                int rgb;
                boolean found = false;
                for (Rectangle r : this.rect) {
                    if (!r.contains((double)x + 0.5, (double)y + 0.5)) continue;
                    found = true;
                    break;
                }
                if (found || (rgb = img.getRGB(x, y) & 0xFFFFFF) == 0x1A1A1A || rgb == 0) continue;
                for (x_ = x; x_ < img.getWidth() && (rgb_ = img.getRGB(x_, y) & 0xFFFFFF) == rgb; ++x_) {
                    problem = false;
                    for (Rectangle r : this.rect) {
                        if (!r.contains((double)x_ + 0.5, (double)y + 0.5)) continue;
                        problem = true;
                        break;
                    }
                    if (problem) break;
                }
                if (x_ == x) continue;
                for (y_ = y; y_ < img.getHeight(); ++y_) {
                    problem = false;
                    block6: for (int x__ = x; x__ < x_; ++x__) {
                        int rgb_2 = img.getRGB(x__, y_) & 0xFFFFFF;
                        if (rgb_2 != rgb) {
                            problem = true;
                            break;
                        }
                        for (Rectangle r : this.rect) {
                            if (!r.contains((double)x__ + 0.5, (double)y_ + 0.5)) continue;
                            problem = true;
                            continue block6;
                        }
                    }
                    if (problem) break;
                }
                if (y_ == y) continue;
                this.rect.add(new Rectangle(x, y, x_ - x, y_ - y));
                x = x_ - 1;
            }
        }
    }

    public int getColor() {
        return this.color;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public List<Rectangle> getRectangles() {
        return this.rect;
    }
}

