/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.texture;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import uk.co.qmunity.lib.texture.LayoutConfiguration;
import uk.co.qmunity.lib.texture.SimplifiedLayout;

public class Layout {
    private String path = null;
    private BufferedImage layout;
    private Map<Integer, BufferedImage> colorMaps = new HashMap<Integer, BufferedImage>();
    private Map<Integer, SimplifiedLayout> simplificationMaps = new HashMap<Integer, SimplifiedLayout>();
    private LayoutConfiguration config = null;
    private Layout parent = null;
    private Map<Integer, Layout> subLayouts = null;

    public Layout(String path) {
        this.path = path;
        this.subLayouts = new HashMap<Integer, Layout>();
        this.reload();
    }

    private Layout(BufferedImage layout, Layout parent) {
        this.layout = layout;
        this.parent = parent;
    }

    public void reload() {
        if (this.parent != null) {
            this.parent.reload();
            return;
        }
        this.config = null;
        try {
            InputStream stream = this.getClass().getResourceAsStream(this.path + ".png");
            this.layout = ImageIO.read(stream);
            stream.close();
            try {
                this.config = new LayoutConfiguration(this.layout, this.path + ".layout");
            }
            catch (Exception ex) {
                this.config = null;
                this.layout = new BufferedImage(16, 16, 2);
            }
        }
        catch (Exception e) {
            this.layout = new BufferedImage(16, 16, 2);
            this.config = null;
        }
        try {
            if (this.config == null) {
                this.config = new LayoutConfiguration(this.layout);
            }
        }
        catch (Exception e) {
            this.layout = new BufferedImage(16, 16, 2);
        }
        this.colorMaps.clear();
        this.simplificationMaps.clear();
    }

    public BufferedImage getLayout(int color) {
        if (this.parent == null) {
            return this.getSubLayout(0).getLayout(color);
        }
        for (Map.Entry<Integer, BufferedImage> e : this.colorMaps.entrySet()) {
            if (e.getKey() != color) continue;
            return e.getValue();
        }
        BufferedImage img = new BufferedImage(this.getConfig().getWidth(), this.getConfig().getHeight(), 2);
        Graphics2D g = img.createGraphics();
        g.setColor(new Color(0));
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.setColor(new Color(0xFFFFFF));
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getWidth(); ++y) {
                if ((this.layout.getRGB(x, y) & 0xFFFFFF) != color) continue;
                g.fillRect(x, y, 1, 1);
            }
        }
        g.dispose();
        this.colorMaps.put(color, img);
        return img;
    }

    public SimplifiedLayout getSimplifiedLayout(int color) {
        if (this.parent == null) {
            return this.getSubLayout(0).getSimplifiedLayout(color);
        }
        for (Map.Entry<Integer, SimplifiedLayout> e : this.simplificationMaps.entrySet()) {
            if (e.getKey() != color) continue;
            return e.getValue();
        }
        SimplifiedLayout l = new SimplifiedLayout(this, color);
        this.simplificationMaps.put(color, l);
        return l;
    }

    public LayoutConfiguration getConfig() {
        if (this.parent != null) {
            return this.parent.getConfig();
        }
        return this.config;
    }

    public Layout getSubLayout(int id) {
        if (this.parent != null) {
            return this.parent.getSubLayout(id);
        }
        for (Map.Entry<Integer, Layout> e : this.subLayouts.entrySet()) {
            if (e.getKey() != id) continue;
            return e.getValue();
        }
        BufferedImage img = this.getConfig().getSubLayout(this.layout, id);
        Layout layout = new Layout(img, this);
        this.subLayouts.put(id, layout);
        return layout;
    }
}

