/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.part.compat.fmp;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.microblock.CommonMicroblock;
import codechicken.multipart.IFaceRedstonePart;
import codechicken.multipart.IRedstonePart;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.part.IMicroblock;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.compat.IMultipartCompat;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.part.compat.fmp.FMPMicroblock;
import uk.co.qmunity.lib.part.compat.fmp.FMPPart;
import uk.co.qmunity.lib.part.compat.fmp.FMPPartFactory;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class FMPCompat
implements IMultipartCompat {
    @Override
    public boolean addPartToWorld(IPart part, World world, Vec3i location, boolean simulated) {
        BlockCoord b = new BlockCoord(location.getX(), location.getY(), location.getZ());
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)b);
        if (tmp == null) {
            return false;
        }
        FMPPart p = (FMPPart)this.getPartHolder(world, location);
        boolean isNew = false;
        if (p == null) {
            p = new FMPPart(simulated);
            p.bind(tmp);
            isNew = true;
        }
        if (!p.canAddPart(part)) {
            return false;
        }
        if (!simulated) {
            if (!world.field_72995_K) {
                p.addPart(part);
            }
        } else {
            part.setParent(p);
            TileMultipart te = TileMultipart.getOrConvertTile((World)world, (BlockCoord)b);
            if (te == null) {
                te = new TileMultipart();
                te.field_145851_c = location.getX();
                te.field_145848_d = location.getY();
                te.field_145849_e = location.getZ();
                te.func_145834_a(world);
            }
        }
        if (isNew) {
            if (!tmp.canAddPart((TMultiPart)p)) {
                return false;
            }
            if (!simulated && !world.field_72995_K) {
                TileMultipart.addPart((World)world, (BlockCoord)b, (TMultiPart)p);
            }
        }
        return true;
    }

    @Override
    public boolean addPartToWorldBruteforce(IPart part, World world, Vec3i location) {
        BlockCoord b = new BlockCoord(location.getX(), location.getY(), location.getZ());
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)b);
        if (tmp == null) {
            return false;
        }
        FMPPart p = (FMPPart)this.getPartHolder(world, location);
        boolean isNew = false;
        if (p == null) {
            p = new FMPPart();
            isNew = true;
        }
        p.addPart(part);
        if (isNew && !world.field_72995_K) {
            TileMultipart.addPart((World)world, (BlockCoord)b, (TMultiPart)p);
        }
        return true;
    }

    @Override
    public boolean placePartInWorld(IPart part, World world, Vec3i location, ForgeDirection clickedFace, EntityPlayer player, ItemStack item, int pass, boolean simulated) {
        if (pass == 0 && player.func_70093_af()) {
            return false;
        }
        MovingObjectPosition mop = world.func_147439_a(location.getX(), location.getY(), location.getZ()).func_149731_a(world, location.getX(), location.getY(), location.getZ(), RayTracer.getStartVector(player).toVec3(), RayTracer.getEndVector(player).toVec3());
        if (mop == null) {
            return false;
        }
        boolean solidFace = false;
        double x = mop.field_72307_f.field_72450_a - (double)mop.field_72311_b;
        double y = mop.field_72307_f.field_72448_b - (double)mop.field_72312_c;
        double z = mop.field_72307_f.field_72449_c - (double)mop.field_72309_d;
        if (x < 0.0) {
            x += 1.0;
        }
        if (y < 0.0) {
            y += 1.0;
        }
        if (z < 0.0) {
            z += 1.0;
        }
        switch (clickedFace) {
            case DOWN: {
                if (!(y <= 0.0)) break;
                solidFace = true;
                break;
            }
            case UP: {
                if (!(y >= 1.0)) break;
                solidFace = true;
                break;
            }
            case WEST: {
                if (!(x <= 0.0)) break;
                solidFace = true;
                break;
            }
            case EAST: {
                if (!(x >= 1.0)) break;
                solidFace = true;
                break;
            }
            case NORTH: {
                if (!(z <= 0.0)) break;
                solidFace = true;
                break;
            }
            case SOUTH: {
                if (!(z >= 1.0)) break;
                solidFace = true;
                break;
            }
        }
        if (pass == 1 || solidFace) {
            location.add(clickedFace);
        }
        if (this.canBeMultipart(world, location)) {
            IPartPlacement placement = MultipartCompatibility.getPlacementForPart(part, world, location, clickedFace, mop, player);
            if (placement == null) {
                return false;
            }
            if (!simulated && !placement.placePart(part, world, location, this, true)) {
                return false;
            }
            return placement.placePart(part, world, location, this, simulated);
        }
        return false;
    }

    @Override
    public int getPlacementPasses() {
        return 2;
    }

    @Override
    public boolean isMultipart(World world, Vec3i location) {
        return TileMultipart.getTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ())) != null;
    }

    @Override
    public boolean canBeMultipart(World world, Vec3i location) {
        return world.func_147437_c(location.getX(), location.getY(), location.getZ()) || world.func_147439_a(location.getX(), location.getY(), location.getZ()).func_149688_o().func_76222_j() || TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ())) != null;
    }

    @Override
    public int getStrongRedstoneOuput(World world, Vec3i location, ForgeDirection side, ForgeDirection face) {
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ()));
        if (tmp == null) {
            return 0;
        }
        if (face == ForgeDirection.UNKNOWN) {
            if (side != ForgeDirection.UNKNOWN) {
                return tmp.strongPowerLevel(side.ordinal());
            }
            return 0;
        }
        TMultiPart slotPart = tmp.partMap(side.ordinal());
        if (slotPart != null) {
            if (slotPart instanceof IRedstonePart) {
                return ((IRedstonePart)slotPart).strongPowerLevel(side.ordinal());
            }
            return 0;
        }
        int strong = 0;
        for (TMultiPart p : tmp.jPartList()) {
            if (!(p instanceof IRedstonePart) || !(p instanceof IFaceRedstonePart) || ((IFaceRedstonePart)p).getFace() != face.ordinal()) continue;
            strong = Math.max(strong, ((IRedstonePart)p).strongPowerLevel(side.ordinal()));
        }
        return strong;
    }

    @Override
    public int getWeakRedstoneOuput(World world, Vec3i location, ForgeDirection side, ForgeDirection face) {
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ()));
        if (tmp == null) {
            return 0;
        }
        if (face == ForgeDirection.UNKNOWN) {
            if (side != ForgeDirection.UNKNOWN) {
                return tmp.weakPowerLevel(side.ordinal());
            }
            return 0;
        }
        TMultiPart slotPart = tmp.partMap(side.ordinal());
        if (slotPart != null) {
            if (slotPart instanceof IRedstonePart) {
                return ((IRedstonePart)slotPart).weakPowerLevel(side.ordinal());
            }
            return 0;
        }
        int weak = 0;
        for (TMultiPart p : tmp.jPartList()) {
            if (!(p instanceof IRedstonePart) || !(p instanceof IFaceRedstonePart) || ((IFaceRedstonePart)p).getFace() != face.ordinal()) continue;
            weak = Math.max(weak, ((IRedstonePart)p).weakPowerLevel(side.ordinal()));
        }
        return weak;
    }

    @Override
    public boolean canConnectRedstone(World world, Vec3i location, ForgeDirection side, ForgeDirection face) {
        if (!this.isMultipart(world, location)) {
            return false;
        }
        int s = Direction.func_82372_a((double)side.offsetX, (double)side.offsetZ);
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ()));
        if (face == ForgeDirection.UNKNOWN) {
            return tmp.canConnectRedstone(s);
        }
        TMultiPart slotPart = tmp.partMap(side.ordinal());
        if (slotPart != null) {
            if (slotPart instanceof IRedstonePart) {
                return ((IRedstonePart)slotPart).canConnectRedstone(side.ordinal());
            }
            return false;
        }
        for (TMultiPart p : tmp.jPartList()) {
            if (!(p instanceof IRedstonePart) || !((IRedstonePart)p).canConnectRedstone(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ITilePartHolder getPartHolder(World world, Vec3i location) {
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ()));
        if (tmp == null) {
            return null;
        }
        for (TMultiPart p : tmp.jPartList()) {
            if (!(p instanceof FMPPart)) continue;
            return (ITilePartHolder)p;
        }
        return null;
    }

    @Override
    public boolean checkOcclusion(World world, Vec3i location, Vec3dCube cube) {
        TileMultipart tmp = TileMultipart.getOrConvertTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ()));
        if (tmp == null) {
            return false;
        }
        return tmp.occlusionTest(tmp.partList(), (TMultiPart)new NormallyOccludedPart(new Cuboid6(cube.toAABB())));
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        FMPPartFactory.register();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    @Override
    public List<IMicroblock> getMicroblocks(World world, Vec3i location) {
        ArrayList<IMicroblock> microblocks = new ArrayList<IMicroblock>();
        TileMultipart tmp = TileMultipart.getTile((World)world, (BlockCoord)new BlockCoord(location.getX(), location.getY(), location.getZ()));
        if (tmp == null) {
            return microblocks;
        }
        for (TMultiPart p : tmp.jPartList()) {
            if (!(p instanceof CommonMicroblock)) continue;
            microblocks.add(new FMPMicroblock((CommonMicroblock)p));
        }
        return microblocks;
    }
}

