/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.misc;

import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.util.ForgeDirection;

public class ForgeDirectionUtils {
    public static ForgeDirection getDirectionFacing(EntityLivingBase entity, boolean includeUpAndDown) {
        double yaw;
        for (yaw = (double)entity.field_70177_z; yaw < 0.0; yaw += 360.0) {
        }
        yaw %= 360.0;
        if (includeUpAndDown) {
            if (entity.field_70125_A > 45.0f) {
                return ForgeDirection.DOWN;
            }
            if (entity.field_70125_A < -45.0f) {
                return ForgeDirection.UP;
            }
        }
        if (yaw < 45.0) {
            return ForgeDirection.SOUTH;
        }
        if (yaw < 135.0) {
            return ForgeDirection.WEST;
        }
        if (yaw < 225.0) {
            return ForgeDirection.NORTH;
        }
        if (yaw < 315.0) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.SOUTH;
    }

    public static ForgeDirection getOnFace(ForgeDirection face, ForgeDirection dir) {
        switch (face) {
            case DOWN: {
                return dir;
            }
            case UP: {
                if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN) {
                    return dir.getOpposite();
                }
                return dir;
            }
            case WEST: {
                switch (dir) {
                    case DOWN: {
                        return ForgeDirection.WEST;
                    }
                    case UP: {
                        return ForgeDirection.EAST;
                    }
                    case WEST: {
                        return ForgeDirection.DOWN;
                    }
                    case EAST: {
                        return ForgeDirection.UP;
                    }
                    case NORTH: {
                        return ForgeDirection.NORTH;
                    }
                    case SOUTH: {
                        return ForgeDirection.SOUTH;
                    }
                }
                break;
            }
            case EAST: {
                switch (dir) {
                    case DOWN: {
                        return ForgeDirection.EAST;
                    }
                    case UP: {
                        return ForgeDirection.WEST;
                    }
                    case WEST: {
                        return ForgeDirection.DOWN;
                    }
                    case EAST: {
                        return ForgeDirection.UP;
                    }
                    case NORTH: {
                        return ForgeDirection.NORTH;
                    }
                    case SOUTH: {
                        return ForgeDirection.SOUTH;
                    }
                }
                break;
            }
            case NORTH: {
                switch (dir) {
                    case DOWN: {
                        return ForgeDirection.NORTH;
                    }
                    case UP: {
                        return ForgeDirection.SOUTH;
                    }
                    case WEST: {
                        return ForgeDirection.WEST;
                    }
                    case EAST: {
                        return ForgeDirection.EAST;
                    }
                    case NORTH: {
                        return ForgeDirection.DOWN;
                    }
                    case SOUTH: {
                        return ForgeDirection.UP;
                    }
                }
                break;
            }
            case SOUTH: {
                switch (dir) {
                    case DOWN: {
                        return ForgeDirection.SOUTH;
                    }
                    case UP: {
                        return ForgeDirection.NORTH;
                    }
                    case WEST: {
                        return ForgeDirection.WEST;
                    }
                    case EAST: {
                        return ForgeDirection.EAST;
                    }
                    case NORTH: {
                        return ForgeDirection.DOWN;
                    }
                    case SOUTH: {
                        return ForgeDirection.UP;
                    }
                }
                break;
            }
        }
        return null;
    }
}

