/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.client.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.QmunityLib;
import uk.co.qmunity.lib.client.gui.widget.BaseWidget;
import uk.co.qmunity.lib.client.gui.widget.GuiAnimatedStat;
import uk.co.qmunity.lib.client.gui.widget.IGuiAnimatedStat;
import uk.co.qmunity.lib.client.gui.widget.IGuiWidget;
import uk.co.qmunity.lib.client.gui.widget.IWidgetListener;

public class GuiContainerBase
extends GuiContainer
implements IWidgetListener {
    protected static final int COLOR_TEXT = 0x404040;
    protected final List<IGuiWidget> widgets = new ArrayList<IGuiWidget>();
    private final ResourceLocation resLoc;
    protected IInventory inventory;
    protected IGuiAnimatedStat lastLeftStat;
    protected IGuiAnimatedStat lastRightStat;

    public GuiContainerBase(Container mainContainer, ResourceLocation _resLoc) {
        super(mainContainer);
        this.resLoc = _resLoc;
    }

    public GuiContainerBase(IInventory inventory, Container mainContainer, ResourceLocation _resLoc) {
        this(mainContainer, _resLoc);
        this.inventory = inventory;
    }

    protected boolean isInfoStatLeftSided() {
        return true;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, ItemStack icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((GuiScreen)this, title, icon, this.field_147003_i + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.field_147009_r + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected GuiAnimatedStat addAnimatedStat(String title, String icon, int color, boolean leftSided) {
        GuiAnimatedStat stat = new GuiAnimatedStat((GuiScreen)this, title, icon, this.field_147003_i + (leftSided ? 0 : this.field_146999_f), leftSided && this.lastLeftStat != null || !leftSided && this.lastRightStat != null ? 3 : this.field_147009_r + 5, color, leftSided ? this.lastLeftStat : this.lastRightStat, leftSided);
        this.addWidget(stat);
        if (leftSided) {
            this.lastLeftStat = stat;
        } else {
            this.lastRightStat = stat;
        }
        return stat;
    }

    protected void addWidget(IGuiWidget widget) {
        this.widgets.add(widget);
        widget.setListener(this);
    }

    public void func_146280_a(Minecraft par1Minecraft, int par2, int par3) {
        this.widgets.clear();
        this.lastRightStat = null;
        this.lastLeftStat = null;
        super.func_146280_a(par1Minecraft, par2, par3);
    }

    public static void drawVerticalProgressBar(int xOffset, int yOffset, int h, int w, float value, float max, int color) {
        float perc = value / max;
        int height = (int)((float)h * perc);
        GuiContainerBase.func_73734_a((int)xOffset, (int)(yOffset + h - height), (int)(xOffset + w), (int)(yOffset + h), (int)color);
    }

    public void drawHorizontalAlignedString(int xOffset, int yOffset, int w, String text, boolean useShadow) {
        int stringWidth = this.field_146289_q.func_78256_a(text);
        int newX = xOffset;
        if (stringWidth < w) {
            newX = w / 2 - stringWidth / 2 + xOffset;
        }
        this.field_146289_q.func_85187_a(text, newX, yOffset, 0x404040, useShadow);
    }

    public void drawString(int xOffset, int yOffset, String text, boolean useShadow) {
        this.field_146289_q.func_85187_a(text, xOffset, yOffset, 0x404040, useShadow);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(StatCollector.func_74838_a((String)"container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        if (this.inventory != null) {
            this.drawHorizontalAlignedString(7, 5, this.field_146999_f - 14, I18n.func_135052_a((String)(this.inventory.func_145825_b() + ".name"), (Object[])new Object[0]), false);
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(this.resLoc);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        for (IGuiWidget widget : this.widgets) {
            widget.render(i, j, f);
        }
    }

    public void func_73863_a(int x, int y, float partialTick) {
        super.func_73863_a(x, y, partialTick);
        ArrayList<String> tooltip = new ArrayList<String>();
        boolean shift = QmunityLib.proxy.isSneakingInGui();
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y)) continue;
            widget.addTooltip(x, y, tooltip, shift);
        }
        if (!tooltip.isEmpty()) {
            ArrayList<String> localizedTooltip = new ArrayList<String>();
            for (String line : tooltip) {
                String[] lines;
                String localizedLine = I18n.func_135052_a((String)line, (Object[])new Object[0]);
                for (String locLine : lines = WordUtils.wrap((String)localizedLine, (int)50).split(System.getProperty("line.separator"))) {
                    localizedTooltip.add(locLine);
                }
            }
            this.drawHoveringText(localizedTooltip, x, y, this.field_146289_q);
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (IGuiWidget widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || widget instanceof BaseWidget && !((BaseWidget)widget).enabled) continue;
            widget.onMouseClicked(x, y, button);
        }
    }

    @Override
    public void actionPerformed(IGuiWidget widget) {
        if (widget instanceof GuiAnimatedStat && ((GuiAnimatedStat)widget).isClicked()) {
            for (IGuiWidget w : this.widgets) {
                if (w == widget || !(w instanceof GuiAnimatedStat) || ((GuiAnimatedStat)w).isLeftSided() != ((GuiAnimatedStat)widget).isLeftSided()) continue;
                ((GuiAnimatedStat)w).closeWindow();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (IGuiWidget widget : this.widgets) {
            widget.update();
        }
    }

    public void redraw() {
        this.field_146292_n.clear();
        ArrayList<IGuiWidget> stats = new ArrayList<IGuiWidget>();
        for (IGuiWidget widget : this.widgets) {
            if (!(widget instanceof IGuiAnimatedStat)) continue;
            stats.add(widget);
        }
        this.widgets.clear();
        this.func_73866_w_();
        Iterator<IGuiWidget> iterator = this.widgets.iterator();
        while (iterator.hasNext()) {
            IGuiWidget widget;
            widget = iterator.next();
            if (!(widget instanceof IGuiAnimatedStat)) continue;
            iterator.remove();
        }
        this.widgets.addAll(stats);
    }
}

