/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.block;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Direction;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.QmunityLib;
import uk.co.qmunity.lib.client.renderer.RenderMultipart;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartSelectableCustom;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.tile.TileMultipart;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;

public class BlockMultipart
extends BlockContainer {
    public BlockMultipart() {
        super(Material.field_151578_c);
        this.func_149663_c("qmunitylib:multipart");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileMultipart();
    }

    public boolean func_149721_r() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        RenderMultipart.pass = pass;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return RenderMultipart.RENDER_ID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return false;
    }

    public static TileMultipart get(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            return null;
        }
        if (!(te instanceof TileMultipart)) {
            return null;
        }
        return (TileMultipart)te;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return this.retrace(world, x, y, z, new Vec3d(start), new Vec3d(end));
    }

    private QMovingObjectPosition retrace(World world, int x, int y, int z, Vec3d start, Vec3d end) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return null;
        }
        QMovingObjectPosition mop = te.rayTrace(start, end);
        if (mop == null) {
            return null;
        }
        Vec3dCube c = mop.getCube().clone().expand(0.001);
        this.func_149676_a((float)c.getMinX(), (float)c.getMinY(), (float)c.getMinZ(), (float)c.getMaxX(), (float)c.getMaxY(), (float)c.getMaxZ());
        return mop;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileMultipart te = BlockMultipart.get(world, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.getLightValue();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null || te.getParts().size() == 0) {
            world.func_147475_p(x, y, z);
            world.func_147468_f(x, y, z);
            return false;
        }
        return false;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer entity) {
        if (!world.field_72995_K) {
            TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
            if (te == null) {
                return;
            }
            te.removePart(entity);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB bounds, List l, Entity entity) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        ArrayList<Vec3dCube> boxes = new ArrayList<Vec3dCube>();
        te.addCollisionBoxesToList(boxes, bounds, entity);
        for (Vec3dCube c : boxes) {
            l.add(c.toAABB());
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.onNeighborBlockChange();
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileMultipart te = BlockMultipart.get(world, x, y, z);
        if (te == null) {
            return;
        }
        te.onNeighborChange();
    }

    public boolean getWeakChanges(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileMultipart te = BlockMultipart.get(world, x, y, z);
        if (te == null) {
            return false;
        }
        return te.isSideSolid(side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        TileMultipart te = BlockMultipart.get(world, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.getStrongOutput(ForgeDirection.getOrientation((int)side).getOpposite());
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileMultipart te = BlockMultipart.get(world, x, y, z);
        if (te == null) {
            return 0;
        }
        return te.getWeakOutput(ForgeDirection.getOrientation((int)side).getOpposite());
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileMultipart te = BlockMultipart.get(world, x, y, z);
        if (te == null) {
            return false;
        }
        try {
            return te.canConnect(ForgeDirection.valueOf((String)Direction.field_82373_c[side]).getOpposite());
        }
        catch (Exception ex) {
            return false;
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return null;
        }
        return te.pickUp(QmunityLib.proxy.getPlayer());
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float x_, float y_, float z_) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return false;
        }
        return te.onActivated(player);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te == null) {
            return;
        }
        te.onClicked(player);
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        RayTracer.instance();
        Vec3d vec3d = RayTracer.getStartVector(player);
        RayTracer.instance();
        QMovingObjectPosition mop = this.retrace(world, x, y, z, vec3d, RayTracer.getEndVector(player));
        if (mop == null || mop.getPart() == null) {
            return 1.0f;
        }
        return (float)mop.getPart().getHardness(player, mop);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> l = new ArrayList<ItemStack>();
        TileMultipart te = BlockMultipart.get((IBlockAccess)world, x, y, z);
        if (te != null) {
            for (IPart p : te.getParts()) {
                List<ItemStack> d = p.getDrops();
                if (d == null) continue;
                l.addAll(d);
            }
        }
        return l;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onDrawHighlight(DrawBlockHighlightEvent event) {
        try {
            if (!(event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) instanceof BlockMultipart)) {
                return;
            }
            World world = event.player.field_70170_p;
            int n = event.target.field_72311_b;
            int n2 = event.target.field_72312_c;
            int n3 = event.target.field_72309_d;
            RayTracer.instance();
            Vec3d vec3d = RayTracer.getStartVector(event.player);
            RayTracer.instance();
            QMovingObjectPosition mop = this.retrace(world, n, n2, n3, vec3d, RayTracer.getEndVector(event.player));
            if (mop == null) {
                return;
            }
            if (mop.getPart() == null || !(mop.getPart() instanceof IPartSelectableCustom)) {
                return;
            }
            if (((IPartSelectableCustom)mop.getPart()).drawHighlight(mop, event.player, event.partialTicks)) {
                event.setCanceled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

