/*
 * Decompiled with CFR 0.152.
 */
package mantle.debug;

import mantle.debug.DebugData;
import mantle.lib.CoreConfig;
import mantle.lib.CoreRepo;
import mantle.player.PlayerUtils;
import net.minecraft.entity.player.EntityPlayer;

public class DebugHelper {
    private DebugHelper() {
    }

    public static void handleDebugData(DebugData data) {
        if (CoreConfig.debug_enableChat) {
            DebugHelper.handleChatDebug(data);
        }
        if (CoreConfig.debug_enableConsole) {
            DebugHelper.handleConsoleDebug(data);
        }
    }

    private static void handleChatDebug(DebugData data) {
        EntityPlayer player = data.player;
        String prefix = "[" + data.cl.getSimpleName() + "] ";
        for (String str : data.strings) {
            PlayerUtils.sendChatMessage(player, prefix + str);
        }
    }

    private static void handleConsoleDebug(DebugData data) {
        String player = data.player.getGameProfile().getName();
        String prefix = "[" + player + ":" + data.cl.getSimpleName() + "] ";
        for (String str : data.strings) {
            CoreRepo.logger.info(prefix + str);
        }
    }
}

