/*
 * Decompiled with CFR 0.152.
 */
package mantle.blocks.abstracts;

import mantle.blocks.BlockUtils;
import mantle.blocks.iface.IMasterLogic;
import mantle.blocks.iface.IServantLogic;
import mantle.debug.DebugData;
import mantle.debug.IDebuggable;
import mantle.world.CoordTuple;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MultiServantLogic
extends TileEntity
implements IServantLogic,
IDebuggable {
    boolean hasMaster;
    CoordTuple master;
    Block masterBlock;
    byte masterMeat;

    public boolean canUpdate() {
        return false;
    }

    public boolean getHasMaster() {
        return this.hasMaster;
    }

    public boolean hasValidMaster() {
        if (!this.hasMaster) {
            return false;
        }
        if (this.worldObj.getBlock(this.master.x, this.master.y, this.master.z) == this.masterBlock && this.worldObj.getBlockMetadata(this.master.x, this.master.y, this.master.z) == this.masterMeat) {
            return true;
        }
        this.hasMaster = false;
        this.master = null;
        return false;
    }

    @Override
    public CoordTuple getMasterPosition() {
        return this.master;
    }

    public void overrideMaster(int x, int y, int z) {
        this.hasMaster = true;
        this.master = new CoordTuple(x, y, z);
        this.masterBlock = this.worldObj.getBlock(x, y, z);
        this.masterMeat = (byte)this.worldObj.getBlockMetadata(x, y, z);
    }

    public void removeMaster() {
        this.hasMaster = false;
        this.master = null;
        this.masterBlock = null;
        this.masterMeat = 0;
    }

    @Override
    public boolean setPotentialMaster(IMasterLogic master, World w, int x, int y, int z) {
        return !this.hasMaster;
    }

    @Deprecated
    public boolean verifyMaster(IMasterLogic logic, int x, int y, int z) {
        return this.master.equalCoords(x, y, z) && this.worldObj.getBlock(x, y, z) == this.masterBlock && this.worldObj.getBlockMetadata(x, y, z) == this.masterMeat;
    }

    @Override
    public boolean verifyMaster(IMasterLogic logic, World world, int x, int y, int z) {
        if (this.hasMaster) {
            return this.hasValidMaster();
        }
        this.overrideMaster(x, y, z);
        return true;
    }

    @Override
    public void invalidateMaster(IMasterLogic master, World w, int x, int y, int z) {
        this.hasMaster = false;
        master = null;
    }

    @Override
    public void notifyMasterOfChange() {
        if (this.hasValidMaster()) {
            IMasterLogic logic = (IMasterLogic)this.worldObj.getTileEntity(this.master.x, this.master.y, this.master.z);
            logic.notifyChange(this, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.hasMaster = tags.getBoolean("TiedToMaster");
        if (this.hasMaster) {
            int xCenter = tags.getInteger("xCenter");
            int yCenter = tags.getInteger("yCenter");
            int zCenter = tags.getInteger("zCenter");
            this.master = new CoordTuple(xCenter, yCenter, zCenter);
            this.masterBlock = BlockUtils.getBlockFromUniqueName(tags.getString("MasterBlockName"));
            this.masterMeat = tags.getByte("masterMeat");
        }
    }

    public void writeCustomNBT(NBTTagCompound tags) {
        tags.setBoolean("TiedToMaster", this.hasMaster);
        if (this.hasMaster) {
            tags.setInteger("xCenter", this.master.x);
            tags.setInteger("yCenter", this.master.y);
            tags.setInteger("zCenter", this.master.z);
            tags.setString("MasterBlockName", BlockUtils.getUniqueName(this.masterBlock));
            tags.setByte("masterMeat", this.masterMeat);
        }
    }

    public void readFromNBT(NBTTagCompound tags) {
        super.readFromNBT(tags);
        this.readCustomNBT(tags);
    }

    public void writeToNBT(NBTTagCompound tags) {
        super.writeToNBT(tags);
        this.writeCustomNBT(tags);
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new S35PacketUpdateTileEntity(this.xCoord, this.yCoord, this.zCoord, 1, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.readCustomNBT(packet.func_148857_g());
        this.worldObj.func_147479_m(this.xCoord, this.yCoord, this.zCoord);
        this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public DebugData getDebugInfo(EntityPlayer player) {
        String[] strs = new String[]{"Location: x" + this.xCoord + ", y" + this.yCoord + ", z" + this.zCoord, this.hasMaster ? "masterBlock: " + this.masterBlock.toString() + ", masterMeat: " + this.masterMeat : "No active master."};
        return new DebugData(player, this.getClass(), strs);
    }

    public World getWorld() {
        return this.getWorldObj();
    }

    @Deprecated
    public boolean setMaster(int x, int y, int z) {
        if (!this.hasMaster || this.worldObj.getBlock(this.master.x, this.master.y, this.master.z) != this.masterBlock || this.worldObj.getBlockMetadata(this.master.x, this.master.y, this.master.z) != this.masterMeat) {
            this.overrideMaster(x, y, z);
            return true;
        }
        return false;
    }
}

