/*
 * Decompiled with CFR 0.152.
 */
package mantle.blocks.abstracts;

import java.util.List;
import mantle.blocks.abstracts.InventoryBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class InventorySlab
extends InventoryBlock {
    public InventorySlab(Material material) {
        super(material);
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        boolean top;
        if (side > 1) {
            return super.shouldSideBeRendered(world, x, y, z, side);
        }
        int meta = world.getBlockMetadata(x, y, z);
        boolean bl = top = (meta | 8) == 1;
        if (top && side == 0 || !top && side == 1) {
            return true;
        }
        return super.shouldSideBeRendered(world, x, y, z, side);
    }

    public void addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity entity) {
        this.setBlockBoundsBasedOnState((IBlockAccess)world, x, y, z);
        super.addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, entity);
    }

    public void setBlockBoundsForItemRender() {
        this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.5f, 1.0f);
    }

    public void setBlockBoundsBasedOnState(IBlockAccess world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z) / 8;
        float minY = meta == 1 ? 0.5f : 0.0f;
        float maxY = meta == 1 ? 1.0f : 0.5f;
        this.setBlockBounds(0.0f, minY, 0.0f, 1.0f, maxY, 1.0f);
    }

    @Override
    public int onBlockPlaced(World par1World, int blockX, int blockY, int blockZ, int side, float clickX, float clickY, float clickZ, int metadata) {
        if (side == 1) {
            return metadata;
        }
        if (side == 0 || clickY >= 0.5f) {
            return metadata | 8;
        }
        return metadata;
    }

    @Override
    public int damageDropped(int meta) {
        return meta % 8;
    }
}

