/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.pathfinding;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.pathfinding.PathNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import net.minecraft.world.IBlockAccess;

public abstract class PathFinding {
    protected List<PathNode> scanned = new ArrayList<PathNode>();
    protected Queue<PathNode> toScan = new ArrayDeque<PathNode>();
    protected IBlockAccess field;
    protected State currentState;
    protected PathNode goal;
    protected PathNode start;

    public PathFinding(IBlockAccess ba, VecInt start) {
        this.start = new PathNode(start, null);
        this.field = ba;
        this.currentState = State.NOT_STARTED;
        this.goal = null;
    }

    public void iterate(int maxIterations) {
        PathNode node;
        if (this.currentState == State.NOT_STARTED) {
            this.toScan.add(this.start);
            this.currentState = State.WORKING;
        }
        if (this.isDone()) {
            return;
        }
        if (this.hasFailed()) {
            this.currentState = State.FAIL;
            return;
        }
        int curIterations = 0;
        while ((node = this.toScan.poll()) != null) {
            this.scanned.add(node);
            if (this.isGoal(node)) {
                this.goal = node;
                this.currentState = State.SUCCESS;
                return;
            }
            for (MgDirection dir : MgDirection.values()) {
                PathNode next = node.step(dir);
                if (!this.isPath(next) || this.scanned.stream().anyMatch(n -> n.getPosition().equals(next.getPosition())) || this.toScan.stream().anyMatch(n -> n.getPosition().equals(next.getPosition()))) continue;
                this.toScan.add(next);
            }
            if (++curIterations < maxIterations) continue;
        }
        if (this.toScan.isEmpty()) {
            this.currentState = State.FAIL;
        }
    }

    protected abstract boolean hasFailed();

    public abstract boolean hasGoal();

    public abstract boolean isGoal(PathNode var1);

    public abstract boolean isPath(PathNode var1);

    public boolean isDone() {
        return this.currentState == State.FAIL || this.currentState == State.SUCCESS;
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public Result getResult() {
        if (!this.isDone()) {
            return null;
        }
        return new Result(this);
    }

    public static class Result {
        private final VecInt goal;
        private final List<VecInt> pathToGoal;
        private final List<VecInt> scanned;
        private final List<VecInt> toScan;
        private final List<VecInt> all;
        private final boolean success;

        public Result(PathFinding p) {
            this.success = p.currentState == State.SUCCESS;
            this.toScan = p.toScan.stream().map(PathNode::getPosition).collect(Collectors.toList());
            this.scanned = p.scanned.stream().map(PathNode::getPosition).collect(Collectors.toList());
            this.all = new ArrayList<VecInt>();
            this.all.addAll(this.toScan);
            this.all.addAll(this.scanned);
            VecInt vecInt = this.goal = p.goal == null ? null : p.goal.getPosition();
            if (this.goal == null) {
                this.pathToGoal = null;
            } else {
                this.pathToGoal = new ArrayList<VecInt>();
                for (PathNode t = p.goal; t != null; t = t.getBefore()) {
                    this.pathToGoal.add(t.getPosition());
                }
                Collections.reverse(this.pathToGoal);
            }
        }

        public List<VecInt> getScanned() {
            return this.scanned;
        }

        public List<VecInt> getToScan() {
            return this.toScan;
        }

        public List<VecInt> getAllScanned() {
            return this.all;
        }

        public boolean isSuccessful() {
            return this.success;
        }
    }

    public static enum State {
        NOT_STARTED,
        WORKING,
        FAIL,
        SUCCESS;

    }
}

