/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.network.pressure;

import com.cout970.magneticraft.api.pressure.IPressureConductor;
import com.cout970.magneticraft.api.pressure.prefab.PressureConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.util.network.NetworkNode;
import com.cout970.magneticraft.util.network.pressure.PressureNetwork;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class NodePressureConductor
extends PressureConductor {
    public NetworkNode node;

    public NodePressureConductor(TileEntity t, double volume, NetworkNode node) {
        super(t, volume);
        this.node = node;
    }

    public PressureNetwork getNet() {
        return (PressureNetwork)this.node.getNetwork();
    }

    @Override
    public void filter(List<IPressureConductor> data, List<IPressureConductor> result) {
        for (IPressureConductor p : data) {
            if (p instanceof NodePressureConductor) {
                if (((NodePressureConductor)p).node.getNetwork() == this.node.getNetwork() || p.getFluid() != null && p.getFluid() != this.getFluid()) continue;
                result.add(p);
                continue;
            }
            if (p.getFluid() != null && p.getFluid() != this.getFluid()) continue;
            result.add(p);
        }
    }

    @Override
    public double getVolume() {
        return this.getNet().getPressureCond().getVolume();
    }

    public double getVolumeNode() {
        return this.volume;
    }

    @Override
    public void setVolume(double vol) {
        this.volume = vol;
    }

    @Override
    public double getPressure() {
        return this.getNet().getPressureCond().getPressure();
    }

    @Override
    public double getTemperature() {
        return this.getNet().getPressureCond().getTemperature();
    }

    public double getTemperatureNode() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double temp) {
        this.getNet().getPressureCond().setTemperature(temp);
    }

    public void setTemperatureNode(double temp) {
        this.temperature = temp;
    }

    @Override
    public double getMoles() {
        return this.getNet().getPressureCond().getMoles();
    }

    public double getMolesNode() {
        return this.moles;
    }

    @Override
    public void setMoles(double mol) {
        this.getNet().getPressureCond().setMoles(mol);
    }

    public void setMolesNode(double mol) {
        this.moles = mol;
    }

    @Override
    public int applyGas(FluidStack gas, boolean doFill) {
        return this.getNet().getPressureCond().applyGas(gas, doFill);
    }

    @Override
    public FluidStack drainGas(int amount, boolean doDrain) {
        return this.getNet().getPressureCond().drainGas(amount, doDrain);
    }

    @Override
    public double getMaxPressure() {
        return EnergyConverter.BARtoPA(200.0);
    }

    @Override
    public Fluid getFluid() {
        return this.getNet().getPressureCond().getFluid();
    }

    @Override
    public void setFluid(Fluid f) {
        this.getNet().getPressureCond().setFluid(f);
    }

    public Fluid getFluidNode() {
        return this.currentGas;
    }

    public void setFluidNode(Fluid f) {
        this.currentGas = f;
    }
}

