/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.fluid;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.util.fluid.FluidNetwork;
import com.cout970.magneticraft.util.fluid.IFluidTransport;
import com.cout970.magneticraft.util.fluid.TankConnection;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidUtils {
    public static void onBlockAdded(World w, int x, int y, int z) {
        if (w.field_72995_K) {
            return;
        }
        if (!(w.func_147438_o(x, y, z) instanceof IFluidTransport)) {
            return;
        }
        IFluidTransport te = (IFluidTransport)w.func_147438_o(x, y, z);
        boolean hasNetwork = false;
        for (MgDirection dir : MgDirection.values()) {
            TileEntity e = MgUtils.getTileEntity(te.getTileEntity(), dir);
            if (!(e instanceof IFluidTransport) || ((IFluidTransport)e).getNetwork() == null) continue;
            if (!hasNetwork) {
                te.setNetwork(((IFluidTransport)e).getNetwork());
                te.getNetwork().getPipes().add(te);
                hasNetwork = true;
                continue;
            }
            te.getNetwork().mergeWith(((IFluidTransport)e).getNetwork());
        }
        if (!hasNetwork) {
            te.setNetwork(FluidNetwork.create(te, w.func_147438_o(x, y, z)));
        }
        te.getNetwork().refresh();
    }

    public static void onBlockPreDestroy(World w, int x, int y, int z, int meta) {
        if (w.field_72995_K) {
            return;
        }
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof IFluidTransport && ((IFluidTransport)te).getNetwork() != null) {
            ((IFluidTransport)te).getNetwork().excludeAndRecalculate((IFluidTransport)te);
        }
    }

    private static boolean isConnectable(TileEntity a) {
        return a instanceof IFluidTransport || a instanceof IFluidHandler;
    }

    public static boolean canPassFluid(TileEntity a, TileEntity b) {
        return FluidUtils.isConnectable(b) && FluidUtils.isConnectable(a);
    }

    public static List<TankConnection> getTankConnections(TileEntity tile) {
        ArrayList<TankConnection> t = new ArrayList<TankConnection>();
        for (MgDirection d : MgDirection.values()) {
            TileEntity y = MgUtils.getTileEntity(tile, d);
            if (!(y instanceof IFluidHandler)) continue;
            t.add(new TankConnection((IFluidHandler)y, d.opposite()));
        }
        return t;
    }

    public static boolean isPipe(TileEntity g) {
        if (g instanceof TileMultipart) {
            TileMultipart mp = (TileMultipart)g;
            for (TMultiPart p : mp.jPartList()) {
                if (!(p instanceof IFluidTransport)) continue;
                return true;
            }
        }
        return g instanceof IFluidTransport;
    }

    public static IFluidTransport getFluidTransport(TileEntity e) {
        if (e instanceof IFluidTransport) {
            return (IFluidTransport)e;
        }
        if (e instanceof TileMultipart) {
            TileMultipart mp = (TileMultipart)e;
            for (TMultiPart p : mp.jPartList()) {
                if (!(p instanceof IFluidTransport)) continue;
                return (IFluidTransport)p;
            }
        }
        return null;
    }
}

