/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util.concurrency;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;

public class ThreadSafeBlockAccess
implements IBlockAccess {
    private static Map<World, ThreadSafeBlockAccess> INSTANCES = new HashMap<World, ThreadSafeBlockAccess>();
    private final World world;
    private AtomicReference<Map<Pair<Integer, Integer>, Chunk>> cache;

    private ThreadSafeBlockAccess(World w) {
        this.world = w;
        this.cache = new AtomicReference();
        this.cache.set(new HashMap());
    }

    public static ThreadSafeBlockAccess getAccess(World w) {
        ThreadSafeBlockAccess access = INSTANCES.get(w);
        if (access == null) {
            access = new ThreadSafeBlockAccess(w);
            INSTANCES.put(w, access);
        }
        return access;
    }

    public Block func_147439_a(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4).func_150810_a(x & 0xF, y, z & 0xF);
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        Chunk chunk = this.getChunk(x >> 4, z >> 4);
        return (TileEntity)chunk.field_150816_i.get(new ChunkPosition(x & 0xF, y, z & 0xF));
    }

    public int func_72802_i(int x, int y, int z, int p_72802_4_) {
        return 0;
    }

    public int func_72805_g(int x, int y, int z) {
        return this.getChunk(x >> 4, z >> 4).func_76628_c(x, y, z);
    }

    public int func_72879_k(int x, int y, int z, int p_72879_4_) {
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        return this.func_147439_a(x, y, z).isAir((IBlockAccess)this, x, y, z);
    }

    public BiomeGenBase func_72807_a(int x, int y) {
        return null;
    }

    public int func_72800_K() {
        return 256;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        return false;
    }

    public Chunk getChunk(int x, int z) {
        Chunk chunk = this.cache.get().get(Pair.of((Object)x, (Object)z));
        if (chunk == null) {
            Chunk chunk2 = this.loadChunk(x, z);
            this.cache.updateAndGet(m -> {
                m.put(Pair.of((Object)x, (Object)z), chunk2);
                return m;
            });
            chunk = chunk2;
        }
        return chunk;
    }

    private synchronized Chunk loadChunk(int x, int z) {
        return this.world.func_72964_e(x, z);
    }
}

