/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.util;

import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.util.InventoryComponent;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class InventoryUtils {
    public static ItemStack addition(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b.func_77946_l();
        }
        if (b == null) {
            return a.func_77946_l();
        }
        ItemStack it = new ItemStack(a.func_77973_b(), a.field_77994_a + b.field_77994_a, a.func_77960_j());
        it.field_77990_d = a.field_77990_d;
        return it;
    }

    public static boolean canCombine(ItemStack a, ItemStack b, int limit) {
        return a == null || b == null || a.func_77973_b() == b.func_77973_b() && a.func_77960_j() == b.func_77960_j() && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b) && a.field_77994_a + b.field_77994_a <= limit && a.field_77994_a + b.field_77994_a <= a.func_77976_d();
    }

    public static ItemStack getItemStack(InventoryComponent in) {
        for (int i = 0; i < in.func_70302_i_(); ++i) {
            if (in.func_70301_a(i) == null) continue;
            ItemStack it = in.func_70301_a(i);
            in.func_70299_a(i, null);
            return it;
        }
        return null;
    }

    public static int findCombination(InventoryComponent in, ItemStack st) {
        for (int i = 0; i < in.func_70302_i_(); ++i) {
            if (in.func_70301_a(i) == null || !InventoryUtils.canCombine(in.func_70301_a(i), st, 128) || in.func_70301_a((int)i).field_77994_a >= in.func_70301_a(i).func_77976_d()) continue;
            return i;
        }
        return -1;
    }

    public static int getSlotForStack(InventoryComponent in, ItemStack st) {
        int firstEmpty = -1;
        for (int i = 0; i < in.func_70302_i_(); ++i) {
            if (in.func_70301_a(i) != null) {
                if (!InventoryUtils.canCombine(in.func_70301_a(i), st, in.func_70297_j_())) continue;
                return i;
            }
            if (firstEmpty != -1) continue;
            firstEmpty = i;
        }
        return firstEmpty;
    }

    public static void traspass(IInventory a, IInventory b, int source, int target) {
        ItemStack e = a.func_70301_a(source);
        ItemStack f = b.func_70301_a(target);
        if (f == null) {
            if (e.field_77994_a <= b.func_70297_j_()) {
                b.func_70299_a(target, e);
                a.func_70299_a(source, null);
            } else {
                ItemStack copy = e.func_77946_l();
                copy.field_77994_a = b.func_70297_j_();
                b.func_70299_a(target, copy);
                e.field_77994_a -= copy.field_77994_a;
            }
        } else {
            int amount;
            if (!InventoryUtils.canCombine(e, f, 128)) {
                return;
            }
            if (f.field_77994_a < b.func_70297_j_() && (amount = Math.min(b.func_70297_j_() - f.field_77994_a, e.field_77994_a)) > 0) {
                f.field_77994_a += amount;
                e.field_77994_a -= amount;
                if (e.field_77994_a <= 0) {
                    a.func_70299_a(source, null);
                }
            }
        }
    }

    public static void remove(IInventory inv, int slot, int amount, InventoryComponent comp) {
        for (int j = 0; j < amount; ++j) {
            ItemStack itemContainer;
            ItemStack i = inv.func_70301_a(slot);
            if (i == null) {
                return;
            }
            inv.func_70298_a(slot, 1);
            if (!i.func_77973_b().hasContainerItem(i) || (itemContainer = i.func_77973_b().getContainerItem(i)) != null && itemContainer.func_77984_f() && itemContainer.func_77960_j() > itemContainer.func_77958_k()) continue;
            TileEntity tile = comp.tile;
            if (InventoryUtils.dropIntoInventory(itemContainer, comp)) continue;
            BlockMg.dropItem(itemContainer, tile.func_145831_w().field_73012_v, tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, tile.func_145831_w());
        }
    }

    public static boolean dropIntoInventory(ItemStack item, InventoryComponent in) {
        if (item == null) {
            return true;
        }
        int s = InventoryUtils.getSlotForStack(in, item);
        if (s == -1) {
            return false;
        }
        ItemStack itemStack = InventoryUtils.addition(item, in.func_70301_a(s));
        in.func_70299_a(s, itemStack);
        return true;
    }

    public static boolean giveToPlayer(ItemStack is, InventoryPlayer inv) {
        if (inv.func_70448_g() != null && InventoryUtils.canCombine(inv.func_70448_g(), is, inv.func_70448_g().func_77976_d())) {
            inv.func_70299_a(inv.field_70461_c, InventoryUtils.addition(inv.func_70448_g(), is));
            return true;
        }
        return inv.func_70441_a(is);
    }

    public static void saveInventory(IInventory inv, NBTTagCompound nbtTagCompound, String name) {
        NBTTagList list = new NBTTagList();
        for (int currentIndex = 0; currentIndex < inv.func_70302_i_(); ++currentIndex) {
            if (inv.func_70301_a(currentIndex) == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)currentIndex);
            inv.func_70301_a(currentIndex).func_77955_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        nbtTagCompound.func_74782_a(name, (NBTBase)list);
    }

    public static void loadInventory(IInventory inv, NBTTagCompound nbtTagCompound, String name) {
        NBTTagList tagList = nbtTagCompound.func_150295_c(name, 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= inv.func_70302_i_()) continue;
            inv.func_70299_a((int)slot, ItemStack.func_77949_a((NBTTagCompound)tagCompound));
        }
    }

    public static boolean areExactlyEqual(ItemStack a, ItemStack b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && b != null && a.func_77973_b() != null && b.func_77973_b() != null && OreDictionary.itemMatches((ItemStack)a, (ItemStack)b, (boolean)true);
    }
}

