/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity.multiblock.controllers;

import com.cout970.magneticraft.api.access.RecipeSifter;
import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Base;
import com.cout970.magneticraft.tileentity.multiblock.TileMB_Inv;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryUtils;
import com.cout970.magneticraft.util.multiblock.Multiblock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileSifter
extends TileMB_Base {
    public int drawCounter;
    public boolean working;
    public int speed = 100;
    public int progress;
    public float[] leverCount = new float[4];
    public boolean[] leverState = new boolean[4];
    public IElectricConductor cond;
    public InventoryComponent in;
    public InventoryComponent out;
    private InventoryComponent inv = new InventoryComponent(this, 3, "Sifter");
    private long time;

    @Override
    public InventoryComponent getInv() {
        if (this.inv == null) {
            this.inv = new InventoryComponent(this, 3, "Sifter");
        }
        return this.inv;
    }

    @Override
    public void onBlockBreaks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockMg.dropItem(this.getInv().func_70301_a(0), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        BlockMg.dropItem(this.getInv().func_70301_a(1), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        BlockMg.dropItem(this.getInv().func_70301_a(2), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 40L == 0L) {
            this.cond = null;
        }
        if (this.cond == null || this.in == null || this.out == null) {
            this.search();
            if (this.cond == null || this.in == null || this.out == null) {
                return;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 40L == 0L && this.cond.getParent() instanceof TileBase) {
            ((TileBase)this.cond.getParent()).sendUpdateToClient();
        }
        if (this.working) {
            if (this.getInv().func_70301_a(0) == null) {
                this.inputItem();
            }
            if (this.canCraft()) {
                if (this.cond.getVoltage() > 60.0) {
                    this.cond.drainPower(EnergyConverter.RFtoW(40.0) * (double)(100.0f / (float)this.speed));
                    ++this.progress;
                    if (this.progress > this.speed) {
                        this.craft();
                        this.progress = 0;
                    }
                }
            } else {
                this.progress = 0;
            }
        }
    }

    @Override
    public void onDestroy(World w, VecInt p, Multiblock c, MgDirection e) {
    }

    private void inputItem() {
        if (this.getInv().func_70301_a(1) == null) {
            for (int i = 0; i < this.in.func_70302_i_(); ++i) {
                ItemStack it = this.in.func_70301_a(i);
                RecipeSifter r = RecipeSifter.getRecipe(it);
                if (r == null) continue;
                ItemStack item = it.func_77946_l();
                this.in.func_70298_a(i, 1);
                item.field_77994_a = 1;
                this.getInv().func_70299_a(0, item);
                this.getInv().func_70299_a(1, r.getOutput().func_77946_l());
                if (r.getProb() >= this.field_145850_b.field_73012_v.nextFloat() && r.getExtra() != null) {
                    this.getInv().func_70299_a(2, r.getExtra().func_77946_l());
                } else {
                    this.getInv().func_70299_a(2, null);
                }
                return;
            }
        } else {
            this.outputItem();
        }
    }

    private boolean canCraft() {
        return this.getInv().func_70301_a(0) != null;
    }

    private void craft() {
        this.getInv().func_70299_a(0, null);
        this.outputItem();
    }

    private void outputItem() {
        if (this.getInv().func_70301_a(1) != null && InventoryUtils.dropIntoInventory(this.getInv().func_70301_a(1), this.out)) {
            this.getInv().func_70299_a(1, null);
        }
        if (this.getInv().func_70301_a(2) != null && InventoryUtils.dropIntoInventory(this.getInv().func_70301_a(2), this.out)) {
            this.getInv().func_70299_a(2, null);
        }
    }

    private void search() {
        IElectricConductor[] comp;
        VecInt vec = new VecInt(this).add(this.getDirection().opposite().toVecInt());
        TileEntity tile = vec.getTileEntity((IBlockAccess)this.field_145850_b);
        if (tile != null && (comp = ElectricUtils.getElectricCond(tile, VecInt.NULL_VECTOR, 0)) != null) {
            this.cond = comp[0];
        }
        if ((tile = (vec = new VecInt(this).add(this.getDirection().opposite().toVecInt()).add(0, 1, 0)).getTileEntity((IBlockAccess)this.field_145850_b)) instanceof TileMB_Inv) {
            this.in = ((TileMB_Inv)tile).getInv();
        }
        vec = new VecInt(this).add(this.getDirection().opposite().toVecInt());
        vec.add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt());
        tile = vec.getTileEntity((IBlockAccess)this.field_145850_b);
        if (tile instanceof TileMB_Inv) {
            this.out = ((TileMB_Inv)tile).getInv();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInv().readFromNBT(nbt);
        this.working = nbt.func_74767_n("Work");
        this.progress = nbt.func_74762_e("Progress");
        this.speed = nbt.func_74762_e("Speed");
        for (int i = 0; i < 4; ++i) {
            this.leverState[i] = nbt.func_74767_n("Lever_" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.getInv().writeToNBT(nbt);
        nbt.func_74757_a("Work", this.working);
        nbt.func_74768_a("Progress", this.progress);
        nbt.func_74768_a("Speed", this.speed);
        for (int i = 0; i < 4; ++i) {
            nbt.func_74757_a("Lever_" + i, this.leverState[i]);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        VecInt v2 = VecIntUtil.getRotatedOffset(this.getDirection().opposite(), 1, 2, 3);
        VecInt block = new VecInt(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return VecIntUtil.getAABBFromVectors(block, v2.add(block));
    }

    public void switchClick(int id) {
        this.leverCount[id] = 50.0f;
        int n = id;
        this.leverState[n] = this.leverState[n] ^ true;
        this.working = this.leverState[0];
        int speed = 100;
        if (this.leverState[1]) {
            speed -= 25;
        }
        if (this.leverState[2]) {
            speed -= 25;
        }
        if (this.leverState[3]) {
            speed -= 25;
        }
        this.speed = speed;
        this.sendUpdateToClient();
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }
}

