/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import buildcraft.api.core.EnumColor;
import buildcraft.api.transport.IPipeTile;
import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.ManagerConfig;
import com.cout970.magneticraft.api.conveyor.IConveyorBelt;
import com.cout970.magneticraft.api.conveyor.prefab.ItemBox;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IEnergyTracker;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.compat.ManagerIntegration;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryUtils;
import com.cout970.magneticraft.util.Log;
import com.cout970.magneticraft.util.tile.TileConductorMedium;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class TileMiner
extends TileConductorMedium
implements IInventoryManaged,
IGuiSync,
IGuiListener {
    public static final int MINING_COST_PER_BLOCK = 1000;
    private static final int MAX_DIMENSION = 80;
    private static final int MIN_DIMENSION = 10;
    public InventoryComponent inv = new InventoryComponent(this, 1, "Miner");
    public WorkState state = WorkState.UNREADY;
    public List<BlockInfo> well = new ArrayList<BlockInfo>();
    public ArrayList<ItemStack> items = new ArrayList();
    public float coolDown = 1000.0f;
    public float consumptionCounter;
    public float consume;
    public int minedLastSecond;
    public int hole = 0;
    public int dim = 11;
    public int mined;
    public boolean removeWater = false;
    public boolean replaceWithDirt = true;
    public boolean scheduleUpdate = false;
    private boolean isFirstTime = false;
    private ForgeChunkManager.Ticket chunkTicket;

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this, 1, 0.01){

            @Override
            public double getVoltageCapacity() {
                return 10.0;
            }
        };
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isFirstTime) {
            this.loadChunk();
        }
        if (this.scheduleUpdate && this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.updateTicket();
            this.scheduleUpdate = false;
        }
        if (this.state == WorkState.UNREADY) {
            this.scanWell();
            ++this.hole;
            if (this.hole > this.dim * this.dim) {
                this.state = WorkState.FINISHED;
                this.hole = 0;
            } else {
                this.state = WorkState.WORKING;
            }
        }
        if (this.state == WorkState.WORKING && this.isControlled()) {
            if (this.items.isEmpty()) {
                double work = 50.0;
                double eff = this.cond.getVoltage() - work * this.cond.getVoltageMultiplier();
                double p = eff * 3.0;
                p *= p;
                if (this.coolDown > 0.0f && this.cond.getVoltage() > work * this.cond.getVoltageMultiplier()) {
                    this.coolDown = (float)((double)this.coolDown - EnergyConverter.WtoRF(p));
                    this.consumptionCounter = (float)((double)this.consumptionCounter + p);
                    this.cond.drainPower(p);
                }
                while (this.coolDown <= 0.0f) {
                    if (this.mineOneBlock()) {
                        this.coolDown += 1000.0f;
                    }
                    if (this.state == WorkState.WORKING) continue;
                }
            }
            while (this.items.iterator().hasNext() && this.ejectItems(this.items.get(0))) {
                this.items.remove(0);
            }
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.consume = this.consumptionCounter;
            this.minedLastSecond = this.mined;
            this.consumptionCounter = 0.0f;
            this.mined = 0;
        }
    }

    private boolean mineOneBlock() {
        if (this.well.size() > 0) {
            BlockInfo f = this.well.get(0);
            this.well.remove(f);
            Block b = this.field_145850_b.func_147439_a(f.getX(), f.getY(), f.getZ());
            int meta = this.field_145850_b.func_72805_g(f.getX(), f.getY(), f.getZ());
            BlockInfo f0 = new BlockInfo(b, meta);
            if (f0.getBlock() != Blocks.field_150350_a && MgUtils.isMineableBlock(this.func_145831_w(), f0) || Block.func_149680_a((Block)b, (Block)Blocks.field_150355_j) || Block.func_149680_a((Block)b, (Block)Blocks.field_150353_l) || Block.func_149680_a((Block)b, (Block)Blocks.field_150356_k) || Block.func_149680_a((Block)b, (Block)Blocks.field_150358_i)) {
                this.items.addAll(f.getBlock().getDrops(this.field_145850_b, f.getX(), f.getY(), f.getZ(), f.getMeta(), 0));
                if (this.replaceWithDirt) {
                    this.field_145850_b.func_147449_b(f.getX(), f.getY(), f.getZ(), Blocks.field_150346_d);
                } else {
                    this.field_145850_b.func_147468_f(f.getX(), f.getY(), f.getZ());
                }
                if (this.removeWater && !this.replaceWithDirt) {
                    for (MgDirection dir : MgDirection.values()) {
                        Block ba = this.field_145850_b.func_147439_a(f.getX() + dir.getOffsetX(), f.getY() + dir.getOffsetY(), f.getZ() + dir.getOffsetZ());
                        if (!Block.func_149680_a((Block)ba, (Block)Blocks.field_150355_j) && !Block.func_149680_a((Block)ba, (Block)Blocks.field_150353_l) && !Block.func_149680_a((Block)ba, (Block)Blocks.field_150356_k) && !Block.func_149680_a((Block)ba, (Block)Blocks.field_150358_i)) continue;
                        this.field_145850_b.func_147449_b(f.getX() + dir.getOffsetX(), f.getY() + dir.getOffsetY(), f.getZ() + dir.getOffsetZ(), Blocks.field_150346_d);
                    }
                }
                ++this.mined;
                return true;
            }
            return false;
        }
        this.state = WorkState.UNREADY;
        return true;
    }

    private void scanWell() {
        int z;
        int x;
        MgDirection d = this.getDirection();
        if (this.dim < 10) {
            this.dim = 10;
        }
        if (d == MgDirection.NORTH) {
            x = this.hole / this.dim - this.dim / 2;
            z = -(this.hole % this.dim + 1);
        } else if (d == MgDirection.SOUTH) {
            x = this.hole / this.dim - this.dim / 2;
            z = this.hole % this.dim + 1;
        } else if (d == MgDirection.EAST) {
            x = this.hole % this.dim + 1;
            z = this.hole / this.dim - this.dim / 2;
        } else {
            x = -(this.hole % this.dim + 1);
            z = this.hole / this.dim - this.dim / 2;
        }
        VecInt pos = new VecInt(this.field_145851_c + x, 0, this.field_145849_e + z);
        this.well.clear();
        for (int i = this.field_145848_d + 5; i >= 0; --i) {
            Block b = this.field_145850_b.func_147439_a(pos.getX(), i, pos.getZ());
            int meta = this.field_145850_b.func_72805_g(pos.getX(), i, pos.getZ());
            BlockInfo info = new BlockInfo(b, meta, pos.copy().add(0, i, 0));
            if (this.replaceWithDirt && Block.func_149680_a((Block)b, (Block)Blocks.field_150346_d) || !MgUtils.isMineableBlock(this.field_145850_b, info) && (!this.removeWater || !Block.func_149680_a((Block)b, (Block)Blocks.field_150355_j) && !Block.func_149680_a((Block)b, (Block)Blocks.field_150353_l) && !Block.func_149680_a((Block)b, (Block)Blocks.field_150356_k) && !Block.func_149680_a((Block)b, (Block)Blocks.field_150358_i))) continue;
            this.well.add(info);
        }
    }

    public boolean ejectItems(ItemStack i) {
        if (i == null) {
            return true;
        }
        for (MgDirection d : MgDirection.values()) {
            TileEntity t = MgUtils.getTileEntity((TileEntity)this, d);
            if (t instanceof IInventory) {
                ISidedInventory s;
                if (t instanceof ISidedInventory) {
                    s = (ISidedInventory)t;
                    for (int j : s.func_94128_d(d.opposite().ordinal())) {
                        if (!s.func_102007_a(j, i, d.opposite().ordinal())) continue;
                        s.func_70299_a(j, InventoryUtils.addition(i, s.func_70301_a(j)));
                        return true;
                    }
                    continue;
                }
                s = (IInventory)t;
                for (int j = 0; j < s.func_70302_i_(); ++j) {
                    if (s.func_70301_a(j) == null) {
                        s.func_70299_a(j, i);
                        return true;
                    }
                    if (!s.func_70301_a(j).func_77969_a(i) || s.func_70301_a((int)j).field_77994_a + i.field_77994_a > s.func_70297_j_()) continue;
                    s.func_70299_a(j, InventoryUtils.addition(i, s.func_70301_a(j)));
                    return true;
                }
                continue;
            }
            if (ManagerIntegration.BUILDCRAFT && t instanceof IPipeTile) {
                int r;
                IPipeTile a = (IPipeTile)t;
                if (a.getPipeType() != IPipeTile.PipeType.ITEM || (r = a.injectItem(i, true, d.toForgeDir().getOpposite(), EnumColor.WHITE)) <= 0) continue;
                return true;
            }
            if (!(t instanceof IConveyorBelt)) continue;
            IConveyorBelt c = (IConveyorBelt)t;
            ItemBox box = new ItemBox(i);
            if (!c.addItem(d.opposite(), 0, box, true)) continue;
            c.addItem(d.opposite(), 0, box, false);
            c.onChange();
            return true;
        }
        return false;
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p()).opposite();
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt);
        this.dim = nbt.func_74762_e("Dimension");
        this.hole = nbt.func_74762_e("Hole");
        this.replaceWithDirt = nbt.func_74767_n("Replace");
        this.removeWater = nbt.func_74767_n("Remove");
        this.items.clear();
        int size = nbt.func_74762_e("BufferSize");
        NBTTagList list = nbt.func_150295_c("BufferData", 10);
        for (int i = 0; i < size; ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            ItemStack it = ItemStack.func_77949_a((NBTTagCompound)t);
            this.items.add(it);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt);
        nbt.func_74768_a("Dimension", this.dim);
        nbt.func_74768_a("Hole", this.hole);
        nbt.func_74757_a("Replace", this.replaceWithDirt);
        nbt.func_74757_a("Remove", this.removeWater);
        if (!this.items.isEmpty()) {
            nbt.func_74768_a("BufferSize", this.items.size());
            NBTTagList list = new NBTTagList();
            for (ItemStack item : this.items) {
                NBTTagCompound t = new NBTTagCompound();
                if (item != null) {
                    item.func_77955_b(t);
                }
                list.func_74742_a((NBTBase)t);
            }
            nbt.func_74782_a("BufferData", (NBTBase)list);
        }
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, (int)this.coolDown);
        craft.func_71112_a(cont, 2, this.state.ordinal());
        craft.func_71112_a(cont, 3, (int)this.consume);
        craft.func_71112_a(cont, 4, this.minedLastSecond);
        craft.func_71112_a(cont, 5, this.hole);
        craft.func_71112_a(cont, 6, this.dim);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.coolDown = value;
        }
        if (id == 2) {
            this.state = WorkState.values()[value % WorkState.values().length];
        }
        if (id == 3) {
            this.consume = value;
        }
        if (id == 4) {
            this.minedLastSecond = value;
        }
        if (id == 5) {
            this.hole = value;
        }
        if (id == 6) {
            this.dim = value;
        }
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @Override
    public void onMessageReceive(int id, int data) {
        if (id == 0) {
            int old = this.dim;
            this.dim = Math.min(80, this.dim + data);
            if (old != this.dim) {
                this.hole = 0;
                this.state = WorkState.UNREADY;
                this.scheduleUpdate = true;
                this.sendUpdateToClient();
            }
        } else if (id == 1) {
            int old = this.dim;
            this.dim = Math.max(10, this.dim - data);
            if (old != this.dim) {
                this.hole = 0;
                this.state = WorkState.UNREADY;
                this.scheduleUpdate = true;
                this.sendUpdateToClient();
            }
        } else if (id == 2) {
            this.replaceWithDirt = data == 1;
            this.sendUpdateToClient();
        } else if (id == 3) {
            this.removeWater = data == 1;
            this.sendUpdateToClient();
        }
    }

    public IEnergyTracker getEnergyTracker() {
        return new IEnergyTracker(){

            @Override
            public boolean isConsume() {
                return true;
            }

            @Override
            public float getMaxChange() {
                return 70000.0f;
            }

            @Override
            public float getChangeInTheLastTick() {
                return TileMiner.this.consumptionCounter;
            }

            @Override
            public float getChangeInTheLastSecond() {
                return TileMiner.this.consume;
            }
        };
    }

    public IBarProvider getBlocksMinedLastSecondBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return "Blocks mined in the last second: " + TileMiner.this.minedLastSecond;
            }

            @Override
            public float getMaxLevel() {
                return 150.0f;
            }

            @Override
            public float getLevel() {
                return Math.min(TileMiner.this.minedLastSecond, 150);
            }
        };
    }

    public void updateTicket() {
        if (this.chunkTicket == null) {
            return;
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        this.chunkTicket = null;
        this.loadChunk();
    }

    public void loadChunk() {
        this.isFirstTime = true;
        if (ManagerConfig.MINER_CHUNKLOADING) {
            if (this.chunkTicket == null) {
                this.chunkTicket = ForgeChunkManager.requestTicket((Object)Magneticraft.INSTANCE, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            }
            this.chunkTicket.getModData().func_74768_a("quarryX", this.field_145851_c);
            this.chunkTicket.getModData().func_74768_a("quarryY", this.field_145848_d);
            this.chunkTicket.getModData().func_74768_a("quarryZ", this.field_145849_e);
            this.forceChunkLoading(this.chunkTicket);
        }
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        int zMax;
        int zMin;
        int xMax;
        int xMin;
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.field_145851_c >> 4, this.field_145849_e >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
        MgDirection d = this.getDirection();
        if (d == MgDirection.NORTH) {
            xMin = -this.dim / 2;
            xMax = this.dim / 2;
            zMin = -this.dim;
            zMax = -1;
        } else if (d == MgDirection.SOUTH) {
            xMin = -this.dim / 2;
            xMax = this.dim / 2;
            zMin = 1;
            zMax = this.dim;
        } else if (d == MgDirection.EAST) {
            xMin = 1;
            xMax = this.dim;
            zMin = -this.dim / 2;
            zMax = this.dim / 2;
        } else {
            xMin = -this.dim;
            xMax = -1;
            zMin = -this.dim / 2;
            zMax = this.dim / 2;
        }
        for (int chunkX = xMin + this.field_145851_c >> 4; chunkX <= xMax + this.field_145851_c >> 4; ++chunkX) {
            for (int chunkZ = zMin + this.field_145849_e >> 4; chunkZ <= zMax + this.field_145849_e >> 4; ++chunkZ) {
                ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                chunks.add(chunk);
            }
        }
        Log.info("Miner at " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e + " will keep " + chunks.size() + " chunks loaded");
    }

    public static enum WorkState {
        UNREADY,
        FINISHED,
        WORKING,
        IDLE,
        BLOCKED;

    }
}

