/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.tile.AverageBar;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import com.cout970.magneticraft.util.tile.TileConductorMedium;
import cpw.mods.fml.common.Optional;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.energy.IEnergyHandler", modid="CoFHAPI|energy")
public class TileKineticGenerator
extends TileConductorMedium
implements IEnergyHandler,
IGuiSync {
    protected EnergyStorage storage = new EnergyStorage(32000);
    public float rotation = 0.0f;
    private long time;
    private AverageBar energyBar = new AverageBar(20);

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p() % 6);
    }

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this, 1, 0.01){

            @Override
            public double getVoltageCapacity() {
                return 10.0;
            }
        };
    }

    @Override
    public IElectricConductor[] getConds(VecInt dir, int tier) {
        if (tier != 1) {
            return null;
        }
        if (VecInt.NULL_VECTOR.equals(dir)) {
            return new IElectricConductor[]{this.cond};
        }
        if (dir.toMgDirection() == this.getDirection().opposite()) {
            return new IElectricConductor[]{this.cond};
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        IEnergyReceiver e;
        TileEntity t;
        boolean working;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.energyBar.tick();
        if (this.cond.getVoltage() > 60.0 * this.cond.getVoltageMultiplier() && this.isControlled()) {
            float f = (float)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) * 10.0f / (float)this.storage.getMaxEnergyStored();
            double eff = TileConductorLow.getEfficiency(this.cond.getVoltage(), 60.0 * this.cond.getVoltageMultiplier(), 100.0 * this.cond.getVoltageMultiplier());
            int min = (int)Math.min(eff * 400.0, 40.0 * Math.ceil(f));
            min = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), min);
            if (min > 0) {
                this.cond.drainPower(EnergyConverter.RFtoW(min));
                this.storage.modifyEnergyStored(min);
                this.energyBar.addValue(min);
            }
        }
        boolean bl = working = this.energyBar.getAverage() > 0.0f;
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (working && !this.isActive()) {
                this.setActive(true);
            } else if (!working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.storage.getEnergyStored() > 0 && (t = MgUtils.getTileEntity((TileEntity)this, this.getDirection())) instanceof IEnergyReceiver && (e = (IEnergyReceiver)t).canConnectEnergy(this.getDirection().opposite().toForgeDir())) {
            int transfer = Math.min(400, this.storage.getEnergyStored());
            int accepted = e.receiveEnergy(this.getDirection().opposite().toForgeDir(), transfer, false);
            this.storage.modifyEnergyStored(-accepted);
        }
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() - 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return (float)((double)(this.time - aux) * 1.0E-6);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getDirection().toForgeDir() == from;
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.storage.getEnergyStored());
        craft.func_71112_a(cont, 2, (int)(this.energyBar.getAverage() * 16.0f));
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.cond.setVoltage(value);
                break;
            }
            case 1: {
                this.storage.setEnergyStored(value);
                break;
            }
            case 2: {
                this.energyBar.setStorage((float)value / 16.0f);
            }
        }
    }

    public IBarProvider getProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("%d RF", (int)TileKineticGenerator.this.energyBar.getStorage());
            }

            @Override
            public float getLevel() {
                return TileKineticGenerator.this.energyBar.getStorage();
            }

            @Override
            public float getMaxLevel() {
                return 400.0f;
            }
        };
    }
}

