/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.tool.IFurnaceCoil;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.tile.MachineElectricConductor;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;

public class TileElectricFurnace
extends TileConductorLow
implements IInventoryManaged,
IGuiSync,
ISidedInventory {
    public InventoryComponent inv = new InventoryComponent(this, 3, "Electric Furnace");
    public float progress = 0.0f;
    private boolean working;
    private float consumption;
    private float consumptionAux;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
            this.consumption = this.consumptionAux / 20.0f;
            this.consumptionAux = 0.0f;
        }
        if (this.cond.getVoltage() > 60.0 && this.isControlled()) {
            if (this.canSmelt()) {
                double speed = TileElectricFurnace.getEfficiency(this.cond.getVoltage(), 60.0, 85.0);
                if (speed > 0.0) {
                    this.progress = (float)((double)this.progress + speed);
                    this.cond.drainPower(this.getConsumption() * speed);
                    this.consumptionAux += (float)(this.getConsumption() * speed);
                    if (this.progress >= (float)this.getMaxProgress()) {
                        this.smelt();
                        this.progress = 0.0f;
                    }
                    this.working = true;
                }
            } else {
                this.working = false;
                this.progress = 0.0f;
            }
        } else {
            this.working = false;
        }
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() - 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    public double getConsumption() {
        if (this.getInv().func_70301_a(2) == null) {
            return 0.0;
        }
        if (!(this.getInv().func_70301_a(2).func_77973_b() instanceof IFurnaceCoil)) {
            return 0.0;
        }
        return ((IFurnaceCoil)this.getInv().func_70301_a(2).func_77973_b()).getElectricConsumption();
    }

    private void smelt() {
        if (this.canSmelt()) {
            ItemStack a = this.getInv().func_70301_a(0);
            ItemStack b = this.getInv().func_70301_a(1);
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(a);
            if (b == null) {
                this.getInv().func_70299_a(1, itemstack.func_77946_l());
            } else if (b.func_77969_a(itemstack)) {
                b.field_77994_a += itemstack.field_77994_a;
            }
            --a.field_77994_a;
            if (a.field_77994_a <= 0) {
                this.getInv().func_70299_a(0, null);
            }
        }
    }

    private boolean canSmelt() {
        ItemStack a = this.getInv().func_70301_a(2);
        if (a == null) {
            return false;
        }
        if (!(a.func_77973_b() instanceof IFurnaceCoil)) {
            return false;
        }
        if (this.getInv().func_70301_a(0) == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.getInv().func_70301_a(0));
        if (itemstack == null) {
            return false;
        }
        if (this.getInv().func_70301_a(1) == null) {
            return true;
        }
        if (!this.getInv().func_70301_a(1).func_77969_a(itemstack)) {
            return false;
        }
        int result = this.getInv().func_70301_a((int)1).field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return slot == 0 || slot == 2 && item.func_77973_b() instanceof IFurnaceCoil;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.getInv().readFromNBT(nbtTagCompound);
        this.progress = nbtTagCompound.func_74760_g("P");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.getInv().writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74776_a("P", this.progress);
    }

    @Override
    public IElectricConductor initConductor() {
        return new MachineElectricConductor(this);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, (int)this.progress);
        craft.func_71112_a(cont, 2, (int)(this.consumption * 16.0f));
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 0: {
                this.cond.setVoltage(value);
                break;
            }
            case 1: {
                this.progress = value;
                break;
            }
            case 2: {
                this.consumption = value / 16;
            }
        }
    }

    public int getMaxProgress() {
        if (this.getInv().func_70301_a(2) == null) {
            return -1;
        }
        if (!(this.getInv().func_70301_a(2).func_77973_b() instanceof IFurnaceCoil)) {
            return -1;
        }
        return ((IFurnaceCoil)this.getInv().func_70301_a(2).func_77973_b()).getCookTime();
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot == 1;
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public IBarProvider getProgressBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return TileElectricFurnace.this.getMaxProgress();
            }

            @Override
            public float getLevel() {
                return TileElectricFurnace.this.progress;
            }
        };
    }

    public IBarProvider getConsumptionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("%.2fW", Float.valueOf(TileElectricFurnace.this.consumption));
            }

            @Override
            public float getLevel() {
                return (float)Math.min((double)TileElectricFurnace.this.consumption, TileElectricFurnace.this.getConsumption());
            }

            @Override
            public float getMaxLevel() {
                return (float)TileElectricFurnace.this.getConsumption();
            }
        };
    }
}

