/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.ManagerConfig;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.EnergyConverter;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.MgBeltUtils;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class TileBreaker
extends TileConductorLow
implements IInventory,
IGuiListener,
IGuiSync {
    public InventoryComponent inv = new InventoryComponent(this, 9, "Block Breaker");
    public InventoryComponent filter = new InventoryComponent(this, 9, "Filter");
    public boolean whiteList;
    public boolean ignoreNBT;
    public boolean ignoreMeta;
    public boolean ignoreDict;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.isControlled() && this.cond.getVoltage() > 60.0) {
            this.breakBlock();
        }
        this.ejectFromInv();
    }

    private void ejectFromInv() {
        MgDirection d = MgDirection.getDirection(this.func_145832_p()).opposite();
        TileEntity t = MgUtils.getTileEntity((TileEntity)this, d);
        if (t instanceof IInventory) {
            for (int i = 0; i < this.inv.func_70302_i_(); ++i) {
                if (this.inv.func_70301_a(i) == null || MgBeltUtils.dropItemStackIntoInventory((IInventory)t, this.inv.func_70301_a(i), d.opposite(), true) != 0) continue;
                MgBeltUtils.dropItemStackIntoInventory((IInventory)t, this.inv.func_70301_a(i), d.opposite(), false);
                this.inv.func_70299_a(i, null);
                this.func_70296_d();
                return;
            }
        }
    }

    public void breakBlock() {
        ForgeDirection d = ForgeDirection.getOrientation((int)this.func_145832_p());
        for (int g = 1; g <= 16; ++g) {
            int x = this.field_145851_c + d.offsetX * g;
            int y = this.field_145848_d + d.offsetY * g;
            int z = this.field_145849_e + d.offsetZ * g;
            if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z)) continue;
            if (this.field_145850_b.func_147439_a(x, y, z) == ManagerBlocks.permagnet) break;
            BlockInfo bi = new BlockInfo(this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z), x, y, z);
            if (!this.canMine(this.field_145850_b, bi) || !this.canBeStored(bi)) continue;
            Block id = this.field_145850_b.func_147439_a(x, y, z);
            int metadata = this.field_145850_b.func_72805_g(x, y, z);
            this.cond.drainPower(EnergyConverter.RFtoW(500.0));
            ArrayList items = id.getDrops(this.field_145850_b, x, y, z, metadata, 0);
            items.forEach(this::ejectItems);
            this.func_70296_d();
            this.field_145850_b.func_147468_f(x, y, z);
            break;
        }
    }

    private boolean canMine(World w, BlockInfo info) {
        if (!MgUtils.isMineableBlock(this.field_145850_b, info)) {
            return false;
        }
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Block)info.getBlock());
        return !ManagerConfig.blockBreakerBlacklist.contains(id.modId + ":" + id.name);
    }

    private boolean canBeStored(BlockInfo bi) {
        ArrayList list = bi.getBlock().getDrops(this.field_145850_b, bi.getX(), bi.getY(), bi.getZ(), bi.getMeta(), 0);
        for (ItemStack i : list) {
            if (i == null) continue;
            if (this.canPassFilter(i)) {
                if (MgBeltUtils.dropItemStackIntoInventory(this.inv, i, MgDirection.UP, true) == 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean canPassFilter(ItemStack s) {
        if (s == null) {
            return false;
        }
        if (this.whiteList) {
            for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
                if (!this.checkFilter(i, s)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
            if (!this.checkFilter(i, s)) continue;
            return false;
        }
        return true;
    }

    public boolean checkFilter(int slot, ItemStack i) {
        ItemStack f = this.filter.func_70301_a(slot);
        if (f == null) {
            return false;
        }
        if (!this.ignoreDict && f.func_77973_b() != i.func_77973_b()) {
            int[] c = OreDictionary.getOreIDs((ItemStack)i);
            int[] d = OreDictionary.getOreIDs((ItemStack)f);
            if (c.length > 0 && d.length > 0) {
                for (int k : c) {
                    for (int j : d) {
                        if (k != j) continue;
                        return true;
                    }
                }
            }
        }
        if (f.func_77973_b() != i.func_77973_b()) {
            return false;
        }
        if (!this.ignoreMeta && f.func_77960_j() != i.func_77960_j()) {
            return false;
        }
        return this.ignoreNBT || (f.func_77978_p() == null || f.func_77978_p().equals((Object)i.func_77978_p())) && (f.func_77978_p() != null || i.func_77978_p() != null);
    }

    public void ejectItems(ItemStack i) {
        if (i == null) {
            return;
        }
        if (MgBeltUtils.dropItemStackIntoInventory(this.inv, i, MgDirection.UP, true) == 0) {
            MgBeltUtils.dropItemStackIntoInventory(this.inv, i, MgDirection.UP, false);
            return;
        }
        if (i.field_77994_a > 0) {
            BlockMg.dropItem(i, this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this);
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt, "Inv");
        this.filter.readFromNBT(nbt, "Filt");
        this.whiteList = nbt.func_74767_n("white");
        this.ignoreNBT = nbt.func_74767_n("nbt");
        this.ignoreMeta = nbt.func_74767_n("meta");
        this.ignoreDict = nbt.func_74767_n("dict");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt, "Inv");
        this.filter.writeToNBT(nbt, "Filt");
        nbt.func_74757_a("white", this.whiteList);
        nbt.func_74757_a("nbt", this.ignoreNBT);
        nbt.func_74757_a("meta", this.ignoreMeta);
        nbt.func_74757_a("dict", this.ignoreDict);
    }

    @Override
    public void onMessageReceive(int id, int data) {
        if (id == 0) {
            this.whiteList = data == 1;
            this.sendUpdateToClient();
        } else if (id == 1) {
            this.ignoreMeta = data == 1;
            this.sendUpdateToClient();
        } else if (id == 2) {
            this.ignoreNBT = data == 1;
            this.sendUpdateToClient();
        } else if (id == 3) {
            this.ignoreDict = data == 1;
            this.sendUpdateToClient();
        }
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
    }
}

