/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.heat;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.TMultiPart;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.IHeatMultipart;
import com.cout970.magneticraft.parts.MgPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public abstract class PartHeat
extends MgPart
implements IHeatMultipart {
    public IHeatConductor heat;
    public boolean toUpdate = true;
    public int oldHeat = -1;
    public List<NBTTagCompound> tempNBT = new ArrayList<NBTTagCompound>();
    private int counter;

    public PartHeat(Item i) {
        super(i);
    }

    @Override
    public IHeatConductor getHeatConductor() {
        return this.heat;
    }

    public abstract void create();

    public void update() {
        super.update();
        if (this.tile() == null) {
            return;
        }
        if (this.toUpdate) {
            if (this.heat == null) {
                this.create();
            }
            this.toUpdate = false;
            this.updateConnections();
            this.oldHeat = -1;
        }
        if (!this.tempNBT.isEmpty()) {
            this.heat.load(this.tempNBT.get(0));
            this.tempNBT.remove(0);
        }
        if (this.W().field_72995_K && this.W().func_82737_E() % 10L == 0L) {
            this.updateConnections();
        }
        if (!this.W().field_72995_K && this.W().func_82737_E() % 20L == 0L) {
            ++this.counter;
            if ((int)this.heat.getTemperature() != this.oldHeat || this.counter >= 10) {
                this.oldHeat = (int)this.heat.getTemperature();
                this.counter = 0;
                this.sendDescUpdate();
            }
        }
        if (this.W().field_72995_K) {
            return;
        }
        this.heat.iterate();
    }

    public void writeDesc(MCDataOutput p) {
        super.writeDesc(p);
        if (this.heat != null) {
            p.writeDouble(this.heat.getTemperature());
        } else {
            p.writeDouble(0.0);
        }
    }

    public void readDesc(MCDataInput p) {
        super.readDesc(p);
        if (this.heat != null) {
            this.heat.setTemperature(p.readDouble());
        } else {
            p.readDouble();
        }
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.toUpdate = true;
    }

    public void onPartChanged(TMultiPart part) {
        this.onNeighborChanged();
    }

    public void onAdded() {
        this.onNeighborChanged();
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.tile() == null) {
            return;
        }
        if (this.heat != null) {
            this.heat.save(nbt);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.tempNBT.add(nbt);
    }

    public abstract void updateConnections();
}

