/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.fluid;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import codechicken.multipart.scalatraits.TFluidHandlerTile;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.parts.MgPart;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.FluidNetwork;
import com.cout970.magneticraft.util.fluid.FluidUtils;
import com.cout970.magneticraft.util.fluid.IFluidTransport;
import com.cout970.magneticraft.util.fluid.TankMg;
import java.util.LinkedList;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class PartFluidPipe
extends MgPart
implements IFluidTransport,
TFluidHandlerTile,
IFluidHandler1_8 {
    private FluidNetwork net;
    public TankMg buffer;

    public PartFluidPipe(Item a) {
        super(a);
    }

    public void update() {
        if (this.W().field_72995_K) {
            return;
        }
        if (this.net == null) {
            boolean hasNetwork = false;
            for (MgDirection dir : MgDirection.values()) {
                IFluidTransport it;
                TileEntity e = MgUtils.getTileEntity((TileEntity)this.tile(), dir);
                if (!FluidUtils.isPipe(e) || (it = FluidUtils.getFluidTransport(e)) == null || !this.isCompatible(it) || !this.canConnectOnSide(dir) || !it.canConnectOnSide(dir.opposite()) || it.getNetwork() == null) continue;
                if (!hasNetwork) {
                    this.setNetwork(it.getNetwork());
                    this.getNetwork().addPipe(this);
                    hasNetwork = true;
                    continue;
                }
                this.getNetwork().mergeWith(it.getNetwork());
            }
            if (!hasNetwork) {
                this.setNetwork(FluidNetwork.create(this, (TileEntity)this.tile()));
            }
            if (this.net != null && !this.net.getPipes().contains(this)) {
                this.net.addPipe(this);
            }
            this.getNetwork().refresh();
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        ((TankMg)this.getTank()).writeToNBT(nbt, "net");
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        ((TankMg)this.getTank()).readFromNBT(nbt, "net");
        if (this.net != null && this.net.fluid == null && this.getTank().getFluid() != null) {
            this.net.fluid = this.getTank().getFluid().getFluid();
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this.tile();
    }

    @Override
    public void setNetwork(FluidNetwork fluidNetwork) {
        this.net = fluidNetwork;
    }

    @Override
    public void onNetworkUpdate() {
    }

    @Override
    public FluidNetwork getNetwork() {
        return this.net;
    }

    @Override
    public abstract IFluidTank getTank();

    public void bindPart(TMultiPart arg0) {
    }

    public void clearParts() {
    }

    public void copyFrom(TileMultipart arg0) {
    }

    public void partRemoved(TMultiPart arg0, int arg1) {
    }

    public LinkedList<IFluidHandler> tankList() {
        LinkedList<IFluidHandler> l = new LinkedList<IFluidHandler>();
        l.add(this);
        return l;
    }

    public void tankList_$eq(LinkedList<IFluidHandler> arg0) {
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
    }

    public static enum ConnectionMode {
        OUTPUT,
        INPUT,
        NOTHING;


        public static ConnectionMode getNext(ConnectionMode c) {
            if (c == null) {
                return OUTPUT;
            }
            if (c == OUTPUT) {
                return INPUT;
            }
            if (c == INPUT) {
                return NOTHING;
            }
            return OUTPUT;
        }
    }
}

