/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.electric;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.electricity.ElectricUtils;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.prefab.ElectricConductor;
import com.cout970.magneticraft.api.util.ConnectionClass;
import com.cout970.magneticraft.api.util.IConnectable;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.tilerender.TileRenderCableHigh;
import com.cout970.magneticraft.parts.electric.PartElectric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class PartCableHigh
extends PartElectric
implements ISidedHollowConnect {
    public boolean[] connections = new boolean[6];
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    private TileRenderCableHigh render;

    public PartCableHigh() {
        super(ManagerItems.part_copper_cable_high);
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Collections.singletonList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        t2.add(boxes.get(6));
        for (int i = 0; i < 6; ++i) {
            if (!this.connections[i]) continue;
            t2.add(boxes.get(i));
        }
        return t2;
    }

    public int getHollowSize(int arg0) {
        return 4;
    }

    @Override
    public void create() {
        this.cond = new ElectricConductor(this.getTile(), this.getTier(), 0.25){

            @Override
            public boolean isAbleToConnect(IConnectable c, VecInt d) {
                if (c.getConnectionClass(d.getOpposite()) == ConnectionClass.FULL_BLOCK || c.getConnectionClass(d.getOpposite()) == ConnectionClass.CABLE_HIGH) {
                    if (d.toMgDirection() == null) {
                        return false;
                    }
                    if (((TileMultipart)PartCableHigh.this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.toMgDirection().ordinal())))) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.CABLE_HIGH;
            }

            @Override
            public double getVoltageCapacity() {
                return 0.001;
            }
        };
    }

    @Override
    public void updateConnections() {
        Arrays.fill(this.connections, false);
        for (MgDirection d : MgDirection.values()) {
            IEnergyInterface inter;
            TileEntity t = MgUtils.getTileEntity(this.getTile(), d);
            IElectricConductor[] c = ElectricUtils.getElectricCond(t, VecInt.fromDirection(d).getOpposite(), this.getTier());
            if (c != null) {
                for (IElectricConductor e : c) {
                    if (!e.isAbleToConnect(this.cond, VecInt.fromDirection(d.opposite())) || !this.cond.isAbleToConnect(e, VecInt.fromDirection(d))) continue;
                    this.connections[d.ordinal()] = true;
                }
            }
            if ((inter = ElectricUtils.getInterface(t, d.toVecInt().getOpposite(), this.getTier())) == null || !inter.canConnect(d.toVecInt()) || !((TileMultipart)this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.ordinal())))) continue;
            this.connections[d.ordinal()] = true;
        }
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.render == null) {
            this.render = new TileRenderCableHigh();
        }
        this.render.render(this, pos);
    }

    @Override
    public int getTier() {
        return 2;
    }

    static {
        double w = 0.25;
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w, 1.0, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, 0.5 - w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w, 1.0));
        boxes.add(new Cuboid6(0.0, 0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 + w, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w));
    }
}

