/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.itemrenderer;

import com.cout970.magneticraft.util.CubeRenderer_Util;
import com.cout970.magneticraft.util.RenderUtil;
import com.cout970.magneticraft.util.fluid.TankMg;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ItemRenderCopperTank
implements IItemRenderer {
    private TankMg tank = new TankMg(null, 16000);
    private CubeRenderer_Util fluid;
    private CubeRenderer_Util box;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: {
                this.render(0.0f, -0.5f, 0.0f, 1.0f, item);
                return;
            }
            case EQUIPPED: {
                this.render(0.5f, 0.0f, 0.5f, 1.0f, item);
                return;
            }
            case INVENTORY: {
                this.render(0.0f, -0.5f, 0.0f, 1.0f, item);
                return;
            }
            case EQUIPPED_FIRST_PERSON: {
                this.render(0.5f, 0.0f, 0.5f, 1.0f, item);
            }
        }
    }

    public void render(float x, float y, float z, float scale, ItemStack i) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)(x - 0.5f), (float)y, (float)(z - 0.5f));
        if (this.box == null) {
            this.box = new CubeRenderer_Util();
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)200.0f, (float)100.0f);
        this.box.renderBox(Block.func_149634_a((Item)i.func_77973_b()).func_149691_a(0, 0), 1.0f, 1.0f, 1.0f);
        this.renderFluid(i.field_77990_d);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public TankMg getTank() {
        return this.tank;
    }

    private void renderFluid(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_74767_n("DATA")) {
            return;
        }
        FluidStack f = this.tank.getFluid();
        this.tank.readFromNBT(nbt, "fluid");
        if (this.tank.getFluid() == null) {
            return;
        }
        if (this.fluid == null) {
            this.fluid = new CubeRenderer_Util();
        }
        if (f != this.tank.getFluid() || f.amount == this.tank.getFluid().amount) {
            this.fluid.reset();
        }
        float k = 0.002f;
        IIcon i = this.getTank().getFluid().getFluid().getIcon();
        if (i == null) {
            return;
        }
        float h = (float)this.getTank().getFluidAmount() / (float)this.getTank().getCapacity();
        RenderUtil.bindTexture(TextureMap.field_110575_b);
        if (h > 0.0f) {
            if (h <= 0.01f) {
                h = 0.02f;
            }
            if (h >= 1.0f) {
                h = 0.99f;
            }
            GL11.glTranslatef((float)k, (float)0.01f, (float)k);
            this.fluid.renderBox(i, 1.0f - k * 2.0f, h - 0.01f, 1.0f - k * 2.0f);
        }
    }
}

