/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.ManagerNetwork;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompButtonRedstoneControl;
import com.cout970.magneticraft.client.gui.component.CompEnergyBarMediumVoltage;
import com.cout970.magneticraft.client.gui.component.CompEnergyTrackerBar;
import com.cout970.magneticraft.client.gui.component.CompGenericBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.messages.MessageGuiClick;
import com.cout970.magneticraft.tileentity.TileMiner;
import com.cout970.magneticraft.util.RenderUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiMiner
extends GuiBasic {
    public GuiMiner(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponents() {
        this.comp.add(new CompBackground(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/miner.png")));
        this.comp.add(new CompEnergyBarMediumVoltage(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar2.png"), new GuiPoint(23, 16), ((TileMiner)this.tile).cond));
        this.comp.add(new CompEnergyTrackerBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/consumptionbar.png"), new GuiPoint(32, 19), ((TileMiner)this.tile).getEnergyTracker()));
        this.comp.add(new CompGenericBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/efficiencybar.png"), new GuiPoint(41, 19), ((TileMiner)this.tile).getBlocksMinedLastSecondBar()));
        this.comp.add(new CompMiningBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/windbar.png"), new GuiPoint(50, 19)));
        this.comp.add(new CompMinerGui(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/miner.png"), new GuiPoint(104, 47)));
        this.comp.add(new CompButtonRedstoneControl(new GuiPoint(150, 8)));
    }

    public class CompMinerGui
    implements IGuiComp {
        public GuiPoint pos;
        public ResourceLocation texture;

        public CompMinerGui(ResourceLocation resourceLocation, GuiPoint guiPoint) {
            this.texture = resourceLocation;
            this.pos = guiPoint;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileMiner) {
                TileMiner t = (TileMiner)tile;
                if (!t.replaceWithDirt) {
                    RenderUtil.bindTexture(this.texture);
                    gui.func_73729_b(gui.xStart + this.pos.x, gui.yStart + this.pos.y, 176, 0, 17, 17);
                }
                if (!t.removeWater) {
                    RenderUtil.bindTexture(this.texture);
                    gui.func_73729_b(gui.xStart + this.pos.x + 21, gui.yStart + this.pos.y, 193, 0, 17, 17);
                }
            }
        }

        @Override
        public void onClick(int mx, int my, int button, GuiBasic gui) {
            if (gui.tile instanceof TileMiner) {
                if (GuiBasic.isIn(mx, my, this.pos.x + gui.xStart, this.pos.y + gui.yStart, 17, 17)) {
                    ManagerNetwork.INSTANCE.sendToServer((IMessage)new MessageGuiClick(gui.tile, 2, ((TileMiner)gui.tile).replaceWithDirt ? 0 : 1));
                } else if (GuiBasic.isIn(mx, my, this.pos.x + gui.xStart + 21, this.pos.y + gui.yStart, 17, 17)) {
                    ManagerNetwork.INSTANCE.sendToServer((IMessage)new MessageGuiClick(gui.tile, 3, ((TileMiner)gui.tile).removeWater ? 0 : 1));
                }
            }
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (gui.tile instanceof TileMiner) {
                TileMiner t = (TileMiner)gui.tile;
                if (GuiBasic.isIn(mx, my, this.pos.x + gui.xStart, this.pos.y + gui.yStart, 17, 17)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(t.replaceWithDirt ? "Replace Blocks with Dirt" : "Leave Spaces");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                } else if (GuiBasic.isIn(mx, my, this.pos.x + gui.xStart + 21, this.pos.y + gui.yStart, 17, 17)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(t.removeWater ? "Remove Water and Lava" : "Leave Water and Lava");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }

    public class CompMiningBar
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompMiningBar(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileMiner) {
                TileMiner c = (TileMiner)tile;
                float prod = (float)c.hole / ((float)c.dim * (float)c.dim);
                int scale = (int)(44.0f * prod);
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
                gui.func_73731_b(GuiMiner.this.getFontRenderer(), c.dim + "x" + c.dim, gui.xStart + 60, gui.yStart + 40, RenderUtil.fromRGB(255, 255, 255));
            }
        }

        @Override
        public void onClick(int mx, int my, int button, GuiBasic gui) {
            if (GuiBasic.isIn(mx, my, gui.xStart + 61, gui.yStart + 56, 9, 9)) {
                MessageGuiClick msg = new MessageGuiClick(gui.tile, 0, GuiScreen.func_146272_n() ? 10 : 1);
                ManagerNetwork.INSTANCE.sendToServer((IMessage)msg);
            } else if (GuiBasic.isIn(mx, my, gui.xStart + 72, gui.yStart + 56, 9, 9)) {
                MessageGuiClick msg = new MessageGuiClick(gui.tile, 1, GuiScreen.func_146272_n() ? 10 : 1);
                ManagerNetwork.INSTANCE.sendToServer((IMessage)msg);
            }
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileMiner) {
                TileMiner c = (TileMiner)tile;
                if (GuiBasic.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 44)) {
                    ArrayList<String> data = new ArrayList<String>();
                    float prod = c.hole * 100 / (c.dim * c.dim);
                    data.add("Mined " + (int)prod + "%");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }
}

