/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompButton;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.guide.BookEditMenu;
import com.cout970.magneticraft.guide.BookGuide;
import com.cout970.magneticraft.guide.BookPage;
import com.cout970.magneticraft.guide.Box2D;
import com.cout970.magneticraft.guide.Color;
import com.cout970.magneticraft.guide.CompHolder;
import com.cout970.magneticraft.guide.GuideBookIO;
import com.cout970.magneticraft.guide.IPageComp;
import com.cout970.magneticraft.guide.comps.CompCraftingRecipe;
import com.cout970.magneticraft.guide.comps.CompItemRender;
import com.cout970.magneticraft.guide.comps.CompLargeText;
import com.cout970.magneticraft.guide.comps.CompText;
import com.cout970.magneticraft.util.Log;
import com.cout970.magneticraft.util.RenderUtil;
import com.google.common.base.Function;
import java.util.List;
import java.util.Stack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGuideBook
extends GuiBasic {
    public static ResourceLocation background = new ResourceLocation("Magneticraft:textures/gui/guide_book.png");
    public static ResourceLocation arrows = new ResourceLocation("Magneticraft:textures/gui/arrows.png");
    public static ResourceLocation craftingGrid = new ResourceLocation("Magneticraft:textures/gui/crafting_grid.png");
    public Stack<BookPage> oldPages;
    public BookGuide book;
    public BookPage currentPage;
    public int xStart;
    public int yStart;
    public int xTam;
    public int yTam;
    public float scale = 2.5f;
    public IPageComp selectedComp;
    public boolean pressed;
    public BookEditMenu menuEdit;

    public GuiGuideBook(Container c) {
        super(c, null);
        this.field_146999_f = (int)(140.0f * this.scale);
        this.field_147000_g = (int)(93.0f * this.scale);
        this.xTam = this.field_146999_f;
        this.yTam = this.field_147000_g;
        this.book = GuideBookIO.getBook();
        this.currentPage = this.book.getMainPage();
        this.oldPages = new Stack();
    }

    @Override
    protected void func_146976_a(float fps, int mx, int my) {
        super.func_146976_a(fps, mx, my);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.xStart = (this.field_146294_l - this.field_146999_f) / 2;
        this.yStart = (this.field_146295_m - this.field_147000_g) / 2;
        RenderUtil.bindTexture(background);
        RenderUtil.drawTexturedModalRectScaled(this.xStart, this.yStart, 0, 0, (int)(140.0f * this.scale), (int)(93.0f * this.scale), (int)(180.0f * this.scale), (int)(132.0f * this.scale));
        if (this.currentPage != null) {
            this.currentPage.gadgets.stream().filter(holder -> holder != null).forEach(holder -> {
                IPageComp comp = holder.getComponent();
                if (comp != null) {
                    comp.render(mx, my, this, this.currentPage, this.book);
                }
            });
        }
        if (this.menuEdit != null) {
            this.menuEdit.draw(mx, my, this);
        }
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        if (this.currentPage != null) {
            this.currentPage.gadgets.stream().filter(holder -> holder != null).forEach(holder -> {
                IPageComp comp = holder.getComponent();
                if (comp != null) {
                    comp.renderTop(x, y, this, this.currentPage, this.book);
                }
            });
            if (Magneticraft.DEBUG) {
                this.currentPage.gadgets.stream().filter(holder -> holder != null).forEach(holder -> {
                    IPageComp comp = holder.getComponent();
                    if (comp != null) {
                        Box2D box = comp.getBox();
                        int color = this.selectedComp == comp ? -65536 : -1;
                        box.draw(color);
                    }
                });
                if (this.selectedComp != null) {
                    if (Mouse.isButtonDown((int)0)) {
                        if (!this.pressed) {
                            this.pressed = GuiGuideBook.isIn(this.selectedComp.getBox().copy().translate(this.xStart, this.yStart), x, y);
                        }
                        if (this.pressed) {
                            GuiPoint newPos = this.selectedComp.getPosition();
                            float dx = Math.round((float)Mouse.getDX() * 0.35f);
                            float dy = Math.round((float)Mouse.getDY() * 0.35f);
                            newPos.x = (int)((float)newPos.x + dx);
                            newPos.y = (int)((float)newPos.y - dy);
                            this.selectedComp.setPosition(newPos);
                        }
                    } else {
                        this.pressed = false;
                    }
                }
            }
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int b) {
        super.func_73864_a(x, y, b);
        if (this.menuEdit != null) {
            this.menuEdit.onClick(x, y, b, this);
        }
        if (this.currentPage != null) {
            this.currentPage.gadgets.stream().filter(holder -> holder != null).forEach(holder -> {
                IPageComp comp = holder.getComponent();
                if (comp != null) {
                    comp.onClick(x, y, b, this, this.currentPage, this.book);
                    if (b == 0 && GuiGuideBook.isIn(comp.getBox().copy().translate(this.xStart, this.yStart), x, y)) {
                        this.selectedComp = comp;
                    } else if (b == 1) {
                        this.selectedComp = null;
                        this.menuEdit = null;
                    }
                }
            });
        }
    }

    public static boolean isIn(Box2D box, int mx, int my) {
        return GuiBasic.isIn(mx, my, box.getMinX(), box.getMinY(), box.getMaxX() - box.getMinX(), box.getMaxY() - box.getMinY());
    }

    @Override
    protected void func_73869_a(char letra, int num) {
        boolean block = false;
        if (num == 19) {
            GuideBookIO.loadBook();
            this.book = GuideBookIO.book;
            this.currentPage = this.book.getMainPage();
        }
        if (num == 20) {
            GuideBookIO.saveBook();
            this.book = GuideBookIO.book;
            this.currentPage = this.book.getMainPage();
        }
        if (num == 14 && !this.oldPages.empty()) {
            this.currentPage = this.oldPages.pop();
        }
        if (this.menuEdit != null && this.menuEdit.onKey(letra, num, this)) {
            block = true;
        }
        if (this.currentPage != null) {
            for (CompHolder holder : this.currentPage.gadgets) {
                IPageComp comp;
                if (holder == null || (comp = holder.getComponent()) == null || !comp.onKey(num, letra, this, this.currentPage, this.book)) continue;
                block = true;
                break;
            }
        }
        if (!block) {
            super.func_73869_a(letra, num);
        }
    }

    @Override
    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    @Override
    public void drawHoveringText2(List<String> data, int x, int y) {
        this.drawHoveringText(data, x, y, this.field_146289_q);
    }

    public void changePage(String page) {
        BookPage p = this.book.getPage(page);
        if (p != null) {
            this.oldPages.push(this.currentPage);
            this.currentPage = p;
        }
    }

    @Override
    public void initComponents() {
        if (Magneticraft.DEBUG) {
            Log.debug("Starting guide book edit mode");
            this.comp.add(new CompButton(new GuiPoint(-18, 18), 16, 16, new GuiPoint(0, 96), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(0, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 96)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 96)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 96)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 36), 16, 16, new GuiPoint(0, 112), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(1, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 112)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 112)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 112)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 54), 16, 16, new GuiPoint(0, 128), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(2, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 128)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 128)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 128)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 72), 16, 16, new GuiPoint(0, 144), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(3, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 144)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 144)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 144)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 90), 16, 16, new GuiPoint(0, 160), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(4, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 160)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 160)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 160)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 108), 16, 16, new GuiPoint(0, 176), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(5, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 176)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 176)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 176)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 126), 16, 16, new GuiPoint(0, 192), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(6, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 192)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 192)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 192)).setClickable(CompButton.ButtonState.ACTIVE, false));
            this.comp.add(new CompButton(new GuiPoint(-18, 144), 16, 16, new GuiPoint(0, 208), "textures/gui/buttons.png", (Function<Integer, Boolean>)((Function)n -> this.apply(7, (Integer)n))).setUVForState(CompButton.ButtonState.HOVER, new GuiPoint(16, 208)).setUVForState(CompButton.ButtonState.DISABLED, new GuiPoint(32, 208)).setUVForState(CompButton.ButtonState.ACTIVE, new GuiPoint(48, 208)).setClickable(CompButton.ButtonState.ACTIVE, false));
        }
    }

    public Boolean apply(Integer type, Integer input) {
        if (type == 0) {
            GuideBookIO.saveBook();
        } else if (type == 1) {
            this.selectedComp = new CompText(80, -20, "sample text", new Color(1.0f, 1.0f, 1.0f), false);
            this.currentPage.addComponent(this.selectedComp);
        } else if (type == 2) {
            this.selectedComp = new CompCraftingRecipe(new ItemStack[10], 20, -50);
            this.currentPage.addComponent(this.selectedComp);
        } else if (type == 3) {
            this.selectedComp = new CompLargeText(80, -20, new String[]{"sample text"}, new Color(1.0f, 1.0f, 1.0f), false);
            this.currentPage.addComponent(this.selectedComp);
        } else if (type == 4) {
            this.selectedComp = new CompItemRender(new ItemStack(Items.field_151034_e), 80, -20);
            this.currentPage.addComponent(this.selectedComp);
        } else if (type != 5 && type != 6) {
            if (type == 7) {
                if (this.selectedComp != null) {
                    this.menuEdit = new BookEditMenu(this.selectedComp, this);
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

