/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.pressure;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.api.pressure.IExplodable;
import com.cout970.magneticraft.api.pressure.IPressureConductor;
import com.cout970.magneticraft.api.pressure.IPressureMultipart;
import com.cout970.magneticraft.api.pressure.IPressurePipe;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PressureUtils {
    public static IExplodable getExplodable(World world, VecInt pos) {
        TileEntity tile = pos.getTileEntity((IBlockAccess)world);
        if (tile instanceof TileMultipart) {
            TileMultipart mp = (TileMultipart)tile;
            for (TMultiPart part : mp.jPartList()) {
                if (!(part instanceof IExplodable)) continue;
                return (IExplodable)part;
            }
        }
        if (tile instanceof IExplodable) {
            return (IExplodable)tile;
        }
        Block b = pos.getBlock((IBlockAccess)world);
        if (b instanceof IExplodable) {
            return (IExplodable)b;
        }
        return null;
    }

    public static List<IPressureConductor> getPressureCond(TileEntity tile, VecInt f) {
        ArrayList<IPressureConductor> conds = new ArrayList<IPressureConductor>();
        if (tile instanceof IPressurePipe) {
            for (IPressureConductor con : ((IPressurePipe)tile).getPressureConductor()) {
                if (con == null) continue;
                conds.add(con);
            }
        }
        if (tile instanceof TileMultipart) {
            conds.addAll(((TileMultipart)tile).jPartList().stream().filter(part -> part instanceof IPressureMultipart).filter(part -> ((IPressureMultipart)part).getPressureConductor() != null).map(part -> ((IPressureMultipart)part).getPressureConductor()).collect(Collectors.toList()));
        }
        return conds;
    }
}

