/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.kinetic;

import com.cout970.magneticraft.api.kinetic.IKineticConductor;
import com.cout970.magneticraft.api.kinetic.IKineticTile;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class KineticPathFinder {
    public LinkedList<IKineticConductor> conds;
    public World w;
    public LinkedList<ExtendedVec> scanPosition;
    public HashSet<VecInt> scanMap;

    public KineticPathFinder(World w, IKineticConductor cond) {
        this.w = w;
        this.conds = new LinkedList();
        this.scanPosition = new LinkedList();
        this.scanMap = new HashSet();
        this.conds.addLast(cond);
        this.scanMap.add(new VecInt(cond.getParent()));
        for (MgDirection dir : cond.getValidSides()) {
            this.addBlock(new ExtendedVec(new VecInt(cond.getParent()).add(dir.toVecInt()), dir));
        }
    }

    public void addBlock(ExtendedVec v) {
        if (!this.scanMap.contains(v.vec)) {
            this.scanPosition.addLast(v);
            this.scanMap.add(v.vec);
        }
    }

    public boolean iterate() {
        if (this.scanPosition.size() == 0) {
            return false;
        }
        ExtendedVec vec = this.scanPosition.removeFirst();
        return this.step(vec);
    }

    public boolean step(ExtendedVec vec) {
        IKineticTile k;
        IKineticConductor cond;
        TileEntity tile = MgUtils.getTileEntity(this.w, vec.vec);
        if (tile instanceof IKineticTile && (cond = (k = (IKineticTile)tile).getKineticConductor(vec.dir)) != null) {
            this.conds.add(cond);
            for (MgDirection d : k.getValidSides()) {
                this.addBlock(new ExtendedVec(vec.vec.copy().add(d.toVecInt()), d.opposite()));
            }
        }
        return true;
    }

    public class ExtendedVec {
        public VecInt vec;
        public MgDirection dir;

        public ExtendedVec(VecInt vec, MgDirection d) {
            this.vec = vec;
            this.dir = d;
        }
    }
}

