/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft;

import com.cout970.magneticraft.Magneticraft;
import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.compat.ManagerIntegration;
import com.cout970.magneticraft.items.ItemMeta;
import com.cout970.magneticraft.util.NamedBlock;
import com.cout970.magneticraft.util.NamedItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;

public class LangHelper {
    public static List<String> unloc = new ArrayList<String>();
    public static List<String> name = new ArrayList<String>();

    public static void addName(Object obj, String name) {
        if (obj == null) {
            return;
        }
        if (name == null) {
            return;
        }
        if (obj instanceof ItemStack) {
            LangHelper.put(((ItemStack)obj).func_77977_a(), name);
        } else if (obj instanceof Block) {
            LangHelper.put(((Block)obj).func_149739_a(), name);
        } else if (obj instanceof Item) {
            LangHelper.put(((Item)obj).func_77658_a(), name);
        } else if (obj instanceof Fluid) {
            LangHelper.put(((Fluid)obj).getUnlocalizedName(), name);
        } else if (obj instanceof String) {
            LangHelper.put((String)obj, name);
        }
    }

    public static void put(String a, String b) {
        unloc.add(a);
        name.add(b);
    }

    public static void setupLangFile() {
        File f = new File(Magneticraft.DEV_HOME + "/src/main/resources/assets/magneticraft/lang/en_US.lang");
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(f)));
            for (String s : unloc) {
                if (s.contains("fluid.")) {
                    w.write(s + "=" + name.get(unloc.indexOf(s)) + "\n");
                    continue;
                }
                w.write(s + ".name=" + name.get(unloc.indexOf(s)) + "\n");
            }
            if (!ManagerIntegration.COFH_ENERGY) {
                w.write("kinetic_generator.name=Kinetic Generator\n");
                w.write("rf_alternator.name=RF Alternator\n");
            }
            if (!ManagerIntegration.RAILCRAFT) {
                w.write("rc_alternator.name=RailCraft Charge Alternator\n");
            }
            if (!ManagerIntegration.IC2) {
                w.write("eu_alternator.name=EU Alternator\n");
            }
            ((Writer)w).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerNames() {
        for (NamedItem namedItem : ManagerItems.named) {
            if (namedItem.item instanceof ItemMeta) {
                ItemMeta im = (ItemMeta)namedItem.item;
                for (int it = 0; it < im.getMetaAmount(); ++it) {
                    LangHelper.addName(new ItemStack((Item)im, 1, it), im.getName(it, Locale.US));
                }
                continue;
            }
            LangHelper.addName(namedItem.item, namedItem.name);
        }
        for (NamedBlock namedBlock : ManagerBlocks.named) {
            LangHelper.addName(namedBlock.block, namedBlock.name);
        }
        LangHelper.addName("itemGroup", "Magneticraft");
        LangHelper.addName("fluid.steam", "Steam");
        LangHelper.addName("fluid.oil", "Crude Oil");
        LangHelper.addName("fluid.heavyoil", "Heavy Oil");
        LangHelper.addName("fluid.lightoil", "Light Oil");
        LangHelper.addName("fluid.naturalgas", "Natural Gas");
        LangHelper.addName("fluid.hotcrude", "Hot Crude");
        LangHelper.addName("tile.mg_steam_block", "Steam");
        LangHelper.addName("tile.mg_oil_block", "Crude Oil");
        LangHelper.addName("tile.mg_heavy_oil_block", "Heavy Oil");
        LangHelper.addName("tile.mg_light_oil_block", "Light Oil");
        LangHelper.addName("tile.mg_natural_gas_block", "Natural Gas");
        LangHelper.addName("tile.mg_hot_crude_block", "Hot Crude");
    }
}

