/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.categories;

import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.base.CategoryBase;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class CategoryItemStack
extends CategoryBase {
    public ItemStack stack;

    public CategoryItemStack(List<EntryAbstract> entryList, String unlocCategoryName, ItemStack stack) {
        super(entryList, unlocCategoryName);
        this.stack = stack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, GuiBase guiBase, boolean drawOnLeft, RenderItem renderItem) {
        if (drawOnLeft) {
            guiBase.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("guideapi:textures/gui/category_left.png"));
            GuiHelper.drawIconWithColor(categoryX - 5, categoryY + 2, 102, 12, guiBase.publicZLevel, book.bookColor);
        } else {
            guiBase.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("guideapi:textures/gui/category_right.png"));
            GuiHelper.drawIconWithColor(categoryX - 80, categoryY + 2, 102, 12, guiBase.publicZLevel, book.bookColor);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Book book, int categoryX, int categoryY, int categoryWidth, int categoryHeight, int mouseX, int mouseY, GuiBase guiBase, boolean drawOnLeft, RenderItem renderItem) {
        GuiHelper.drawItemStack(this.stack, categoryX, categoryY);
        if (this.canSee(guiBase.player, guiBase.bookStack) && GuiHelper.isMouseBetween(mouseX, mouseY, categoryX, categoryY, categoryWidth, categoryHeight)) {
            guiBase.drawHoveringText(this.getTooltip(), mouseX, mouseY, Minecraft.func_71410_x().field_71466_p);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CategoryItemStack that = (CategoryItemStack)o;
        return !(this.stack != null ? !this.stack.func_77969_a(that.stack) : that.stack != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.stack != null ? this.stack.hashCode() : 0);
        return result;
    }
}

