/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.pages;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.base.PageBase;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class PageFurnaceRecipe
extends PageBase {
    public ItemStack input;
    public ItemStack output;

    public PageFurnaceRecipe(ItemStack input) {
        this.input = input;
        this.output = FurnaceRecipes.smelting().getSmeltingResult(input);
    }

    public PageFurnaceRecipe(Item input) {
        this.input = new ItemStack(input);
        this.output = FurnaceRecipes.smelting().getSmeltingResult(new ItemStack(input));
    }

    public PageFurnaceRecipe(Block input) {
        this.input = new ItemStack(input);
        this.output = FurnaceRecipes.smelting().getSmeltingResult(new ItemStack(input));
    }

    public PageFurnaceRecipe(String input) {
        this.input = new ItemStack((Block)Blocks.fire);
        if (!OreDictionary.getOres((String)input).isEmpty()) {
            for (int i = 0; i < OreDictionary.getOres((String)input).size(); ++i) {
                ItemStack stack;
                this.input = stack = (ItemStack)OreDictionary.getOres((String)input).get(i);
                this.output = FurnaceRecipes.smelting().getSmeltingResult(stack);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(new ResourceLocation("guideapi:textures/gui/recipe_elements.png"));
        guiBase.drawTexturedModalRect(guiLeft + 42, guiTop + 53, 0, 65, 105, 65);
        guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"text.furnace.smelting"), guiLeft + guiBase.xSize / 2, guiTop + 12, 0);
        int x = guiLeft + 66;
        int y = guiTop + 77;
        GuiHelper.drawItemStack(this.input, x, y);
        List<String> tooltip = null;
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.input);
        }
        if (this.output == null) {
            this.output = new ItemStack((Block)Blocks.fire);
        }
        x = guiLeft + 123;
        GuiHelper.drawItemStack(this.output, x, y);
        if (GuiHelper.isMouseBetween(mouseX, mouseY, x, y, 15, 15)) {
            tooltip = GuiHelper.getTooltip(this.output);
        }
        if (this.output.getItem() == Item.getItemFromBlock((Block)Blocks.fire)) {
            guiBase.drawCenteredString(fontRenderer, StatCollector.translateToLocal((String)"text.furnace.error"), guiLeft + guiBase.xSize / 2, guiTop + 4 * guiBase.ySize / 6, 15533885);
        }
        if (tooltip != null) {
            guiBase.func_146283_a(tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PageFurnaceRecipe that = (PageFurnaceRecipe)o;
        if (this.input != null ? !this.input.isItemEqual(that.input) : that.input != null) {
            return false;
        }
        return !(this.output != null ? !this.output.isItemEqual(that.output) : that.output != null);
    }

    public int hashCode() {
        int result = this.input != null ? this.input.hashCode() : 0;
        result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
        return result;
    }
}

