/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.buttons.ButtonBack;
import amerifrance.guideapi.buttons.ButtonNext;
import amerifrance.guideapi.buttons.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiHome;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.network.PacketSyncCategory;
import amerifrance.guideapi.wrappers.EntryWrapper;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiCategory
extends GuiBase {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public CategoryAbstract category;
    public HashMultimap<Integer, EntryWrapper> entryWrapperMap;
    public ButtonBack buttonBack;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public int entryPage;

    public GuiCategory(Book book, CategoryAbstract category, EntityPlayer player, ItemStack bookStack) {
        super(player, bookStack);
        this.book = book;
        this.category = category;
        this.pageTexture = book.pageTexture;
        this.outlineTexture = book.outlineTexture;
        this.entryWrapperMap = HashMultimap.create();
        this.entryPage = 0;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.entryWrapperMap.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.buttonBack = new ButtonBack(0, this.guiLeft + this.xSize / 6, this.guiTop, this);
        this.buttonList.add(this.buttonBack);
        this.buttonNext = new ButtonNext(1, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.buttonList.add(this.buttonNext);
        this.buttonPrev = new ButtonPrev(2, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.buttonList.add(this.buttonPrev);
        int eX = this.guiLeft + 37;
        int eY = this.guiTop + 15;
        int i = 0;
        int pageNumber = 0;
        for (EntryAbstract entry : this.category.entryList) {
            entry.onInit(this.book, this.category, this, this.player, this.bookStack);
            this.entryWrapperMap.put((Object)pageNumber, (Object)new EntryWrapper(this, this.book, this.category, entry, eX, eY, 4 * this.xSize / 6, 10, this.player, this.fontRendererObj, this.bookStack));
            eY += 13;
            if (++i < 11) continue;
            i = 0;
            eY = this.guiTop + 15;
            ++pageNumber;
        }
    }

    public void drawScreen(int mouseX, int mouseY, float renderPartialTicks) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.pageTexture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.getMinecraft().getTextureManager().bindTexture(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.bookColor);
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (wrapper.canPlayerSee()) {
                wrapper.draw(mouseX, mouseY, this);
                wrapper.drawExtras(mouseX, mouseY, this);
            }
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            wrapper.onHoverOver(mouseX, mouseY);
        }
        this.drawCenteredString(this.fontRendererObj, String.valueOf(this.entryPage + 1) + "/" + String.valueOf(this.entryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        this.drawCenteredStringWithShadow(this.fontRendererObj, this.category.getLocalizedName(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.visible = this.entryPage != 0;
        this.buttonNext.visible = this.entryPage != this.entryWrapperMap.asMap().size() - 1;
        super.drawScreen(mouseX, mouseY, renderPartialTicks);
    }

    public void mouseClicked(int mouseX, int mouseY, int typeofClick) {
        super.mouseClicked(mouseX, mouseY, typeofClick);
        for (EntryWrapper wrapper : this.entryWrapperMap.get((Object)this.entryPage)) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                wrapper.entry.onLeftClicked(this.book, this.category, mouseX, mouseY, this.player, this);
                continue;
            }
            if (typeofClick != 1) continue;
            wrapper.entry.onRightClicked(this.book, this.category, mouseX, mouseY, this.player, this);
        }
        if (typeofClick == 1) {
            this.mc.displayGuiScreen((GuiScreen)new GuiHome(this.book, this.player, this.bookStack));
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        super.keyTyped(typedChar, keyCode);
        if (keyCode == 14 || keyCode == this.mc.gameSettings.keyBindUseItem.getKeyCode()) {
            this.mc.displayGuiScreen((GuiScreen)new GuiHome(this.book, this.player, this.bookStack));
        }
        if ((keyCode == 200 || keyCode == 205) && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            ++this.entryPage;
        }
        if ((keyCode == 208 || keyCode == 203) && this.entryPage > 0) {
            --this.entryPage;
        }
    }

    public void actionPerformed(GuiButton button) {
        if (button.id == 0) {
            this.mc.displayGuiScreen((GuiScreen)new GuiHome(this.book, this.player, this.bookStack));
        } else if (button.id == 1 && this.entryPage + 1 < this.entryWrapperMap.asMap().size()) {
            ++this.entryPage;
        } else if (button.id == 2 && this.entryPage > 0) {
            --this.entryPage;
        }
    }

    @Override
    public void onGuiClosed() {
        super.onGuiClosed();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncCategory(this.book.categoryList.indexOf(this.category), this.entryPage));
    }
}

