/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.api.util;

import amerifrance.guideapi.api.abstraction.IPage;
import amerifrance.guideapi.pages.PageLocItemStack;
import amerifrance.guideapi.pages.PageLocText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import org.apache.commons.lang3.text.WordUtils;

public class PageHelper {
    public static List<IPage> pagesForLongText(String locText, int maxLength) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        for (String s : WordUtils.wrap((String)locText, (int)maxLength, (String)"/cut", (boolean)false).split("/cut")) {
            pageList.add(new PageLocText(s));
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(String locText) {
        return PageHelper.pagesForLongText(locText, 450);
    }

    public static List<IPage> pagesForLongText(String locText, ItemStack stack) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        String[] strings = WordUtils.wrap((String)locText, (int)450, (String)"/cut", (boolean)false).split("/cut");
        for (int i = 0; i < strings.length; ++i) {
            if (i == 0) {
                pageList.add(new PageLocItemStack(strings[i], stack));
                continue;
            }
            pageList.add(new PageLocText(strings[i]));
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(String locText, Item item) {
        return PageHelper.pagesForLongText(locText, new ItemStack(item));
    }

    public static List<IPage> pagesForLongText(String locText, Block block) {
        return PageHelper.pagesForLongText(locText, new ItemStack(block));
    }

    public static boolean areIRecipesEqual(IRecipe recipe1, IRecipe recipe2) {
        if (recipe1 == recipe2) {
            return true;
        }
        if (recipe1 == null || recipe2 == null || recipe1.getClass() != recipe2.getClass()) {
            return false;
        }
        if (recipe1.equals(recipe2)) {
            return true;
        }
        if (!recipe1.getRecipeOutput().isItemEqual(recipe2.getRecipeOutput())) {
            return false;
        }
        return recipe1.getRecipeSize() == recipe2.getRecipeSize();
    }

    @Deprecated
    public static List<IPage> pagesForLongText(String locText, FontRenderer fontRenderer) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        List stringList = fontRenderer.listFormattedStringToWidth(locText, 2250);
        for (String s : stringList) {
            pageList.add(new PageLocText(s));
        }
        return pageList;
    }

    @Deprecated
    public static List<IPage> pagesForLongText(String locText, FontRenderer fontRenderer, ItemStack stack) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        List stringList = fontRenderer.listFormattedStringToWidth(locText, 2250);
        for (int i = 0; i < stringList.size(); ++i) {
            if (i == 0) {
                pageList.add(new PageLocItemStack((String)stringList.get(i), stack));
                continue;
            }
            pageList.add(new PageLocText((String)stringList.get(i)));
        }
        return pageList;
    }
}

