/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.oreprocessing;

import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IOreRecipeRegistrator;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ProcessingPlate
implements IOreRecipeRegistrator {
    public ProcessingPlate() {
        OrePrefixes.plate.add(this);
        OrePrefixes.plateDouble.add(this);
        OrePrefixes.plateTriple.add(this);
        OrePrefixes.plateQuadruple.add(this);
        OrePrefixes.plateQuintuple.add(this);
        OrePrefixes.plateDense.add(this);
        OrePrefixes.plateAlloy.add(this);
        OrePrefixes.itemCasing.add(this);
    }

    @Override
    public void registerOre(OrePrefixes aPrefix, Materials aMaterial, String aOreDictName, String aModName, ItemStack aStack) {
        boolean aNoSmashing = aMaterial.contains(SubTag.NO_SMASHING);
        boolean aNoWorking = aMaterial.contains(SubTag.NO_WORKING);
        long aMaterialMass = aMaterial.getMass();
        switch (aPrefix) {
            case plate: {
                this.registerPlate(aMaterial, aStack, aNoSmashing);
                break;
            }
            case plateDouble: {
                this.registerPlateDouble(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateTriple: {
                this.registerPlateTriple(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateQuadruple: {
                this.registerPlateQuadruple(aMaterial, aStack, aNoSmashing, aMaterialMass, aNoWorking);
                break;
            }
            case plateQuintuple: {
                this.registerPlateQuintuple(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case plateDense: {
                this.registerPlateDense(aMaterial, aStack, aNoSmashing, aMaterialMass);
                break;
            }
            case itemCasing: {
                this.registerItemCasing(aPrefix, aMaterial, aStack, aNoSmashing);
                break;
            }
            case plateAlloy: {
                this.registerPlateAlloy(aOreDictName, aStack);
                break;
            }
        }
    }

    private void registerPlate(Materials aMaterial, ItemStack aStack, boolean aNoSmashing) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        GT_ModHandler.removeRecipeDelayed(aStack);
        GT_Utility.removeSimpleIC2MachineRecipe(GT_Utility.copyAmount(9L, aStack), GT_ModHandler.getCompressorRecipeList(), GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L));
        if (aMaterial.mFuelPower > 0) {
            GT_Values.RA.addFuel(GT_Utility.copyAmount(1L, aStack), GT_Values.NI, aMaterial.mFuelPower, aMaterial.mFuelType);
        }
        if (aMaterial.mStandardMoltenFluid != null && aMaterial != Materials.AnnealedCopper && aMaterial != Materials.WroughtIron) {
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Plate.get(0L, new Object[0]), aMaterial.getMolten(144L), aMaterial.getPlates(1), 32, 8);
        }
        GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.foil, aMaterial, 2L), GT_Proxy.tBits, new Object[]{"hX", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
        if (aMaterial == Materials.Paper) {
            GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.harderrecipes, aStack, true) ? 2L : 3L, aStack), GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"XXX", Character.valueOf('X'), new ItemStack(Items.reeds, 1, Short.MAX_VALUE)});
        }
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial) {
            if (!aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerplating, aMaterial.toString(), true)) {
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"h", "X", "X", Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.ingot.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"h", "X", Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
                GT_ModHandler.addCraftingRecipe(aMaterial.getPlates(1), GT_Proxy.tBits, new Object[]{"H", "X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.gem.get(aMaterial)});
            }
            if (aMaterial.contains(SubTag.MORTAR_GRINDABLE) && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.mortar, aMaterial.mName, true)) {
                GT_ModHandler.addCraftingRecipe(aMaterial.getDust(1), GT_Proxy.tBits, new Object[]{"X", "m", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
            }
        }
    }

    private void registerPlateDouble(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing) {
            GT_Values.RA.addBenderRecipe(GT_Utility.copyAmount(2L, aStack), GT_OreDictUnificator.get(OrePrefixes.plateQuadruple, aMaterial, 1L), (int)Math.max(aMaterialMass * 2L, 1L), 96);
            if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerdoubleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), aPlateStack, Character.valueOf('B'), aPlateStack});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack});
            }
            GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 2L, 1L), 96);
        } else {
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 2L), ItemList.Circuit_Integrated.getWithDamage(0L, 2L, new Object[0]), Materials.Glue.getFluid(10L), GT_Utility.copyAmount(1L, aStack), 64, 8);
        }
    }

    private void registerPlateTriple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing) {
            GT_Values.RA.addBenderRecipe(GT_Utility.copyAmount(3L, aStack), GT_OreDictUnificator.get(OrePrefixes.plateDense, aMaterial, 1L), (int)Math.max(aMaterialMass * 3L, 1L), 96);
            if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammertripleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateDouble.get(aMaterial), Character.valueOf('B'), aPlateStack});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack});
            }
            GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 3L, 1L), 96);
        } else {
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 3L), ItemList.Circuit_Integrated.getWithDamage(0L, 3L, new Object[0]), Materials.Glue.getFluid(20L), GT_Utility.copyAmount(1L, aStack), 96, 8);
        }
        GT_Values.RA.addImplosionRecipe(GT_Utility.copyAmount(1L, aStack), 2, GT_OreDictUnificator.get(OrePrefixes.compressed, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.dustTiny, Materials.DarkAsh, 1L));
    }

    private void registerPlateQuadruple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass, boolean aNoWorking) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoWorking) {
            GT_Values.RA.addCNCRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.get(OrePrefixes.gearGt, aMaterial, 1L), (int)Math.max(aMaterialMass * 2L, 1L), 30);
        }
        if (!aNoSmashing) {
            if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerquadrupleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateTriple.get(aMaterial), Character.valueOf('B'), aPlateStack});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
            }
            GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 4L, 1L), 96);
        } else {
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 4L), ItemList.Circuit_Integrated.getWithDamage(0L, 4L, new Object[0]), Materials.Glue.getFluid(30L), GT_Utility.copyAmount(1L, aStack), 128, 8);
        }
    }

    private void registerPlateQuintuple(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing) {
            if (GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerquintupleplate, OrePrefixes.plate.get(aMaterial).toString(), true)) {
                Object aPlateStack = OrePrefixes.plate.get(aMaterial);
                GT_ModHandler.addCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{"I", "B", "h", Character.valueOf('I'), OrePrefixes.plateQuadruple.get(aMaterial), Character.valueOf('B'), aPlateStack});
                GT_ModHandler.addShapelessCraftingRecipe(GT_Utility.copyAmount(1L, aStack), GT_ModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS | GT_ModHandler.RecipeBits.BUFFERED, new Object[]{ToolDictNames.craftingToolForgeHammer, aPlateStack, aPlateStack, aPlateStack, aPlateStack, aPlateStack});
            }
            GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 5L, 1L), 96);
        } else {
            GT_Values.RA.addAssemblerRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 5L), ItemList.Circuit_Integrated.getWithDamage(0L, 5L, new Object[0]), Materials.Glue.getFluid(40L), GT_Utility.copyAmount(1L, aStack), 160, 8);
        }
    }

    private void registerPlateDense(Materials aMaterial, ItemStack aStack, boolean aNoSmashing, long aMaterialMass) {
        this.registerCover(aMaterial, aStack);
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (!aNoSmashing) {
            GT_Values.RA.addBenderRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 9L), GT_Utility.copyAmount(1L, aStack), (int)Math.max(aMaterialMass * 9L, 1L), 96);
        }
    }

    private void registerItemCasing(OrePrefixes aPrefix, Materials aMaterial, ItemStack aStack, boolean aNoSmashing) {
        GT_ModHandler.removeRecipeByOutputDelayed(aStack);
        if (aMaterial.mStandardMoltenFluid != null) {
            GT_Values.RA.addFluidSolidifierRecipe(ItemList.Shape_Mold_Casing.get(0L, new Object[0]), aMaterial.getMolten(72L), GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), 16, 8);
        }
        if (aMaterial.mUnificatable && aMaterial.mMaterialInto == aMaterial && !aNoSmashing && GregTech_API.sRecipeFile.get((Object)ConfigCategories.Tools.hammerplating, aMaterial.toString(), true)) {
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"h X", Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
            GT_ModHandler.addCraftingRecipe(GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 1L), GT_Proxy.tBits, new Object[]{"H X", Character.valueOf('H'), ToolDictNames.craftingToolForgeHammer, Character.valueOf('X'), OrePrefixes.plate.get(aMaterial)});
        }
        GT_Values.RA.addAlloySmelterRecipe(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 2L), ItemList.Shape_Mold_Casing.get(0L, new Object[0]), GT_Utility.copyAmount(3L, aStack), 128, 15);
        GT_Values.RA.addCutterRecipe(GT_OreDictUnificator.get(OrePrefixes.plate, aMaterial, 1L), GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L), GT_Values.NI, (int)Math.max(aMaterial.getMass(), 1L), 16);
        GT_Values.RA.addExtruderRecipe(GT_OreDictUnificator.get(OrePrefixes.ingot, aMaterial, 1L), ItemList.Shape_Extruder_Casing.get(0L, new Object[0]), GT_OreDictUnificator.get(OrePrefixes.itemCasing, aMaterial, 2L), (int)Math.max(aMaterial.getMass(), 1L), 45);
        GT_RecipeRegistrator.registerReverseFluidSmelting(aStack, aMaterial, aPrefix.mMaterialAmount, null);
    }

    private void registerPlateAlloy(String aOreDictName, ItemStack aStack) {
        switch (aOreDictName) {
            case "plateAlloyCarbon": {
                GT_Values.RA.addAssemblerRecipe(GT_ModHandler.getIC2Item("generator", 1L), GT_Utility.copyAmount(4L, aStack), GT_ModHandler.getIC2Item("windMill", 1L), 6400, 8);
                GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), new ItemStack(Blocks.glass, 3, Short.MAX_VALUE), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), Materials.Glass.getDust(3), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                break;
            }
            case "plateAlloyAdvanced": {
                GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), new ItemStack(Blocks.glass, 3, Short.MAX_VALUE), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                GT_ModHandler.addAlloySmelterRecipe(GT_Utility.copyAmount(1L, aStack), Materials.Glass.getDust(3), GT_ModHandler.getIC2Item("reinforcedGlass", 4L), 400, 4, false);
                break;
            }
            case "plateAlloyIridium": {
                GT_ModHandler.removeRecipeByOutputDelayed(aStack);
                break;
            }
        }
    }

    private void registerCover(Materials aMaterial, ItemStack aStack) {
        OrePrefixes orePrefix;
        ItemStack tStack = GT_Values.NI;
        OrePrefixes[] orePrefixesArray = new OrePrefixes[]{OrePrefixes.block, OrePrefixes.block_, OrePrefixes.stoneSmooth, OrePrefixes.stone};
        int n = orePrefixesArray.length;
        for (int i = 0; i < n && (tStack = GT_OreDictUnificator.get(orePrefix = orePrefixesArray[i], aMaterial, 1L)) == GT_Values.NI; ++i) {
        }
        GregTech_API.registerCover(aStack, tStack == GT_Values.NI ? TextureFactory.builder().addIcon(aMaterial.mIconSet.mTextures[71]).setRGBA(aMaterial.mRGBa).stdOrient().build() : TextureFactory.of(Block.getBlockFromItem((Item)tStack.getItem()), tStack.getItemDamage()), null);
    }
}

