/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.long_distance;

import gregtech.api.GregTech_API;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_Block_LongDistancePipe;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicHull_NonElectric;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public abstract class GT_MetaTileEntity_LongDistancePipelineBase
extends GT_MetaTileEntity_BasicHull_NonElectric {
    protected GT_MetaTileEntity_LongDistancePipelineBase mTarget = null;
    protected GT_MetaTileEntity_LongDistancePipelineBase mSender = null;
    protected ChunkCoordinates mTargetPos = null;

    public GT_MetaTileEntity_LongDistancePipelineBase(int aID, String aName, String aNameRegional, int aTier, String aDescription) {
        super(aID, aName, aNameRegional, aTier, aDescription);
    }

    public GT_MetaTileEntity_LongDistancePipelineBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mTargetPos != null && this.mTarget != this) {
            aNBT.setBoolean("target", true);
            aNBT.setInteger("target.x", this.mTargetPos.posX);
            aNBT.setInteger("target.y", this.mTargetPos.posY);
            aNBT.setInteger("target.z", this.mTargetPos.posZ);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (aNBT.hasKey("target")) {
            this.mTargetPos = new ChunkCoordinates(aNBT.getInteger("target.x"), aNBT.getInteger("target.y"), aNBT.getInteger("target.z"));
        }
    }

    public boolean isSameClass(GT_MetaTileEntity_LongDistancePipelineBase other) {
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        ItemStack tCurrentItem = aPlayer.inventory.getCurrentItem();
        if (tCurrentItem != null && GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
            this.scanPipes();
            return true;
        }
        return false;
    }

    public boolean isDead() {
        return this.getBaseMetaTileEntity() == null || this.getBaseMetaTileEntity().isDead();
    }

    public boolean checkTarget() {
        IGregTechTileEntity gt_tile = this.getBaseMetaTileEntity();
        if (gt_tile == null || !gt_tile.isAllowedToWork() || gt_tile.isClientSide()) {
            return false;
        }
        World world = gt_tile.getWorld();
        if (world == null) {
            return false;
        }
        if (this.mTargetPos == null) {
            this.scanPipes();
        } else if (this.mTarget == null || this.mTarget.isDead()) {
            this.mTarget = null;
            if (world.blockExists(this.mTargetPos.posX, this.mTargetPos.posY, this.mTargetPos.posZ)) {
                IMetaTileEntity tMeta;
                TileEntity te = world.getTileEntity(this.mTargetPos.posX, this.mTargetPos.posY, this.mTargetPos.posZ);
                if (te instanceof BaseMetaTileEntity && (tMeta = ((BaseMetaTileEntity)te).getMetaTileEntity()) instanceof GT_MetaTileEntity_LongDistancePipelineBase && this.isSameClass((GT_MetaTileEntity_LongDistancePipelineBase)tMeta)) {
                    this.mTarget = (GT_MetaTileEntity_LongDistancePipelineBase)tMeta;
                } else if (te != null) {
                    this.mTargetPos = null;
                }
            }
        }
        if (this.mTarget == null || this.mTarget == this) {
            return false;
        }
        if (this.mTarget.mSender == null || this.mTarget.mSender.isDead() || this.mTarget.mSender.mTarget == null || this.mTarget.mSender.mTarget.isDead()) {
            this.mTarget.mSender = this;
        }
        return this.mTarget.mSender == this;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
            ChunkCoordinates coords = this.mSender.getCoords();
            aList.addAll(Arrays.asList("Is the Target", "Sender is at: X: " + coords.posX + " Y: " + coords.posY + " Z: " + coords.posZ));
        } else {
            aList.addAll(Arrays.asList(this.checkTarget() ? "Has Target" : "Has no loaded Target", "Target should be around: X: " + this.mTargetPos.posX + " Y: " + this.mTargetPos.posY + " Z: " + this.mTargetPos.posZ));
        }
        return aList;
    }

    public abstract int getPipeMeta();

    protected void scanPipes() {
        if (this.mSender != null && !this.mSender.isDead() && this.mSender.mTarget == this) {
            return;
        }
        IGregTechTileEntity gtTile = this.getBaseMetaTileEntity();
        if (gtTile == null) {
            return;
        }
        World world = gtTile.getWorld();
        if (world == null) {
            return;
        }
        this.mTargetPos = this.getCoords();
        this.mTarget = this;
        this.mSender = null;
        Block aBlock = gtTile.getBlockAtSide(gtTile.getBackFacing());
        if (aBlock instanceof GT_Block_LongDistancePipe) {
            byte aMetaData = gtTile.getMetaIDAtSide(gtTile.getBackFacing());
            if (aMetaData != this.getPipeMeta()) {
                return;
            }
            HashSet<ChunkCoordinates> tVisited = new HashSet<ChunkCoordinates>(Collections.singletonList(this.getCoords()));
            HashSet<ChunkCoordinates> tWires = new HashSet<ChunkCoordinates>();
            LinkedList<ChunkCoordinates> tQueue = new LinkedList<ChunkCoordinates>(Collections.singletonList(this.getFacingOffset(gtTile, gtTile.getBackFacing())));
            while (!tQueue.isEmpty()) {
                ChunkCoordinates aCoords = (ChunkCoordinates)tQueue.poll();
                if (world.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ) == aBlock && world.getBlockMetadata(aCoords.posX, aCoords.posY, aCoords.posZ) == aMetaData) {
                    tWires.add(aCoords);
                    ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.posX + 1, aCoords.posY, aCoords.posZ);
                    if (tVisited.add(tCoords)) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.posX - 1, aCoords.posY, aCoords.posZ))) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY + 1, aCoords.posZ))) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY - 1, aCoords.posZ))) {
                        tQueue.add(tCoords);
                    }
                    if (tVisited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY, aCoords.posZ + 1))) {
                        tQueue.add(tCoords);
                    }
                    if (!tVisited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY, aCoords.posZ - 1))) continue;
                    tQueue.add(tCoords);
                    continue;
                }
                TileEntity tTileEntity = world.getTileEntity(aCoords.posX, aCoords.posY, aCoords.posZ);
                if (tTileEntity == gtTile || !(tTileEntity instanceof BaseMetaTileEntity) || !(((BaseMetaTileEntity)tTileEntity).getMetaTileEntity() instanceof GT_MetaTileEntity_LongDistancePipelineBase)) continue;
                GT_MetaTileEntity_LongDistancePipelineBase tGtTile = (GT_MetaTileEntity_LongDistancePipelineBase)((BaseMetaTileEntity)tTileEntity).getMetaTileEntity();
                if (this.isSameClass(tGtTile) && tWires.contains(tGtTile.getFacingOffset((BaseMetaTileEntity)tTileEntity, ((BaseMetaTileEntity)tTileEntity).getFrontFacing()))) {
                    this.mTarget = tGtTile;
                    this.mTargetPos = tGtTile.getCoords();
                    return;
                }
                tVisited.remove(aCoords);
            }
        }
    }

    public ChunkCoordinates getFacingOffset(IGregTechTileEntity gt_tile, byte aSide) {
        return new ChunkCoordinates(gt_tile.getOffsetX(aSide, 1), (int)gt_tile.getOffsetY(aSide, 1), gt_tile.getOffsetZ(aSide, 1));
    }

    public ChunkCoordinates getCoords() {
        IGregTechTileEntity gt_tile = this.getBaseMetaTileEntity();
        return new ChunkCoordinates(gt_tile.getXCoord(), (int)gt_tile.getYCoord(), gt_tile.getZCoord());
    }

    @Override
    public void onMachineBlockUpdate() {
        this.mTargetPos = null;
        this.mSender = null;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public boolean shouldTriggerBlockUpdate() {
        return true;
    }
}

