/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.interfaces.IHasFluidDisplayItem;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_New;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MessageUpdateFluidDisplayItem
extends GT_Packet_New {
    private int mBlockX;
    private int mBlockY;
    private int mBlockZ;
    private int mDim;

    public MessageUpdateFluidDisplayItem() {
        super(true);
    }

    public MessageUpdateFluidDisplayItem(int mBlockX, int mBlockY, int mBlockZ, int mDim) {
        super(false);
        this.mBlockX = mBlockX;
        this.mBlockY = mBlockY;
        this.mBlockZ = mBlockZ;
        this.mDim = mDim;
    }

    @Override
    public byte getPacketID() {
        return 8;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mBlockX);
        aOut.writeInt(this.mBlockY);
        aOut.writeInt(this.mBlockZ);
        aOut.writeInt(this.mDim);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new MessageUpdateFluidDisplayItem(aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        IGregTechTileEntity gtTile;
        TileEntity tileEntity;
        WorldServer world = DimensionManager.getWorld((int)this.mDim);
        if (world != null && world.blockExists(this.mBlockX, this.mBlockY, this.mBlockZ) && (tileEntity = world.getTileEntity(this.mBlockX, this.mBlockY, this.mBlockZ)) instanceof IGregTechTileEntity && (gtTile = (IGregTechTileEntity)tileEntity).getMetaTileEntity() instanceof IHasFluidDisplayItem) {
            ((IHasFluidDisplayItem)((Object)gtTile.getMetaTileEntity())).updateFluidDisplayItem();
        }
    }
}

