/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Log;
import gregtech.api.world.GT_Worldgen;
import gregtech.common.blocks.GT_TileEntity_Ores;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;

public class GT_Worldgen_GT_Ore_Layer
extends GT_Worldgen {
    public static ArrayList<GT_Worldgen_GT_Ore_Layer> sList = new ArrayList();
    public static int sWeight = 0;
    public final short mMinY;
    public final short mMaxY;
    public final short mWeight;
    public final short mDensity;
    public final short mSize;
    public final short mPrimaryMeta;
    public final short mSecondaryMeta;
    public final short mBetweenMeta;
    public final short mSporadicMeta;
    public final String mRestrictBiome;
    public final boolean mOverworld;
    public final boolean mNether;
    public final boolean mEnd;
    public final boolean mEndAsteroid;
    public static final int WRONG_BIOME = 0;
    public static final int WRONG_DIMENSION = 1;
    public static final int NO_ORE_IN_BOTTOM_LAYER = 2;
    public static final int NO_OVERLAP = 3;
    public static final int ORE_PLACED = 4;
    public static final int NO_OVERLAP_AIR_BLOCK = 5;
    public final boolean mMoon = false;
    public final boolean mMars = false;
    public final boolean mAsteroid = false;
    public final String aTextWorldgen = "worldgen.";

    @Deprecated
    public GT_Worldgen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, boolean aNether, boolean aEnd, boolean GC_UNUSED1, boolean GC_UNUSED2, boolean GC_UNUSED3, int aPrimary, int aSecondary, int aBetween, int aSporadic) {
        super(aName, sList, aDefault);
        this.mOverworld = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mEndAsteroid = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "EndAsteroid", aEnd);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", aMinY);
        short mMaxY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", aMaxY);
        if (mMaxY < this.mMinY + 9) {
            GT_Log.out.println("Oremix " + this.mWorldGenName + " has invalid Min/Max heights!");
            mMaxY = (short)(this.mMinY + 9);
        }
        this.mMaxY = mMaxY;
        this.mWeight = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RandomWeight", aWeight);
        this.mDensity = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Density", aDensity);
        this.mSize = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Size", aSize));
        this.mPrimaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OrePrimaryLayer", aPrimary);
        this.mSecondaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSecondaryLayer", aSecondary);
        this.mBetweenMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporadiclyInbetween", aBetween);
        this.mSporadicMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporaticlyAround", aSporadic);
        this.mRestrictBiome = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RestrictToBiomeName", "None");
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    @Deprecated
    public GT_Worldgen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, boolean aNether, boolean aEnd, boolean GC_UNUSED1, boolean GC_UNUSED2, boolean GC_UNUSED3, Materials aPrimary, Materials aSecondary, Materials aBetween, Materials aSporadic) {
        this(aName, aDefault, aMinY, aMaxY, aWeight, aDensity, aSize, aOverworld, aNether, aEnd, aPrimary, aSecondary, aBetween, aSporadic);
    }

    public GT_Worldgen_GT_Ore_Layer(String aName, boolean aDefault, int aMinY, int aMaxY, int aWeight, int aDensity, int aSize, boolean aOverworld, boolean aNether, boolean aEnd, Materials aPrimary, Materials aSecondary, Materials aBetween, Materials aSporadic) {
        super(aName, sList, aDefault);
        this.mOverworld = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Overworld", aOverworld);
        this.mNether = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Nether", aNether);
        this.mEnd = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "TheEnd", aEnd);
        this.mEndAsteroid = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "EndAsteroid", aEnd);
        this.mMinY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MinHeight", aMinY);
        short mMaxY = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "MaxHeight", aMaxY);
        if (mMaxY < this.mMinY + 9) {
            GT_Log.out.println("Oremix " + this.mWorldGenName + " has invalid Min/Max heights!");
            mMaxY = (short)(this.mMinY + 9);
        }
        this.mMaxY = mMaxY;
        this.mWeight = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RandomWeight", aWeight);
        this.mDensity = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Density", aDensity);
        this.mSize = (short)Math.max(1, GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "Size", aSize));
        this.mPrimaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OrePrimaryLayer", aPrimary.mMetaItemSubID);
        this.mSecondaryMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSecondaryLayer", aSecondary.mMetaItemSubID);
        this.mBetweenMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporadiclyInbetween", aBetween.mMetaItemSubID);
        this.mSporadicMeta = (short)GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "OreSporaticlyAround", aSporadic.mMetaItemSubID);
        this.mRestrictBiome = GregTech_API.sWorldgenFile.get((Object)("worldgen." + this.mWorldGenName), "RestrictToBiomeName", "None");
        if (this.mEnabled) {
            sWeight += this.mWeight;
        }
    }

    @Override
    public int executeWorldgenChunkified(World aWorld, Random aRandom, String aBiome, int aDimensionType, int aChunkX, int aChunkZ, int aSeedX, int aSeedZ, IChunkProvider aChunkGenerator, IChunkProvider aChunkProvider) {
        int placeZ;
        int tZ;
        int placeX;
        int tX;
        int sZ;
        if (this.mWorldGenName.equals("NoOresInVein")) {
            if (GT_Values.debugOrevein) {
                GT_Log.out.println(" NoOresInVein");
            }
            return 4;
        }
        if (!this.isGenerationAllowed(aWorld, aDimensionType, aDimensionType == -1 && this.mNether || aDimensionType == 0 && this.mOverworld || aDimensionType == 1 && this.mEnd ? aDimensionType : ~aDimensionType)) {
            return 1;
        }
        if (!this.mRestrictBiome.equals("None") && !this.mRestrictBiome.equals(aBiome)) {
            return 0;
        }
        String tDimensionName = aWorld.provider.getDimensionName();
        boolean isUnderdark = tDimensionName.equals("Underdark");
        int[] placeCount = new int[4];
        int tMinY = this.mMinY + aRandom.nextInt(this.mMaxY - this.mMinY - 5);
        int wXVein = aSeedX - aRandom.nextInt(this.mSize);
        int eXVein = aSeedX + 16 + aRandom.nextInt(this.mSize);
        int wX = Math.max(wXVein, aChunkX + 2);
        int eX = Math.min(eXVein, aChunkX + 2 + 16);
        Block tBlock = aWorld.getBlock(aChunkX + 7, tMinY, aChunkZ + 9);
        if (wX >= eX) {
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.stone) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.netherrack) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.end_stone) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTech_API.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTech_API.sBlockStones)) {
                return 3;
            }
            return 5;
        }
        int nZVein = aSeedZ - aRandom.nextInt(this.mSize);
        int sZVein = aSeedZ + 16 + aRandom.nextInt(this.mSize);
        int nZ = Math.max(nZVein, aChunkZ + 2);
        if (nZ >= (sZ = Math.min(sZVein, aChunkZ + 2 + 16))) {
            if (tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.stone) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.netherrack) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, Blocks.end_stone) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTech_API.sBlockGranites) || tBlock.isReplaceableOreGen(aWorld, aChunkX + 7, tMinY, aChunkZ + 9, GregTech_API.sBlockStones)) {
                return 3;
            }
            return 5;
        }
        if (GT_Values.debugOrevein) {
            GT_Log.out.print("Trying Orevein:" + this.mWorldGenName + " Dimension=" + tDimensionName + " mX=" + aChunkX / 16 + " mZ=" + aChunkZ / 16 + " oreseedX=" + aSeedX / 16 + " oreseedZ=" + aSeedZ / 16 + " cY=" + tMinY);
        }
        int localDensity = Math.max(1, this.mDensity / (int)Math.sqrt(2.0 + Math.pow(aChunkX / 16 - aSeedX / 16, 2.0) + Math.pow(aChunkZ / 16 - aSeedZ / 16, 2.0)));
        int level = tMinY - 1;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (placeCount[1] + placeCount[3] == 0) {
            if (GT_Values.debugOrevein) {
                GT_Log.out.println(" No ore in bottom layer");
            }
            return 2;
        }
        for (level = tMinY; level < tMinY + 2; ++level) {
            for (tX = wX; tX < eX; ++tX) {
                placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
                for (tZ = nZ; tZ < sZ; ++tZ) {
                    placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                    if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta > 0) {
                        if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, isUnderdark)) continue;
                        placeCount[1] = placeCount[1] + 1;
                        continue;
                    }
                    if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                    placeCount[3] = placeCount[3] + 1;
                }
            }
        }
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mSecondaryMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSecondaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if (aRandom.nextInt(2) == 0 && (aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mBetweenMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mBetweenMeta, false, isUnderdark)) continue;
                    placeCount[2] = placeCount[2] + 1;
                    continue;
                }
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        ++level;
        for (tX = wX; tX < eX; ++tX) {
            placeX = Math.max(1, Math.max(MathHelper.abs_int((int)(wXVein - tX)), MathHelper.abs_int((int)(eXVein - tX))) / localDensity);
            for (tZ = nZ; tZ < sZ; ++tZ) {
                placeZ = Math.max(1, Math.max(MathHelper.abs_int((int)(sZVein - tZ)), MathHelper.abs_int((int)(nZVein - tZ))) / localDensity);
                if ((aRandom.nextInt(placeZ) == 0 || aRandom.nextInt(placeX) == 0) && this.mPrimaryMeta > 0) {
                    if (!GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mPrimaryMeta, false, isUnderdark)) continue;
                    placeCount[1] = placeCount[1] + 1;
                    continue;
                }
                if (aRandom.nextInt(7) != 0 || aRandom.nextInt(placeZ) != 0 && aRandom.nextInt(placeX) != 0 || this.mSporadicMeta <= 0 || !GT_TileEntity_Ores.setOreBlock(aWorld, tX, level, tZ, this.mSporadicMeta, false, isUnderdark)) continue;
                placeCount[3] = placeCount[3] + 1;
            }
        }
        if (GT_Values.oreveinPlacerOres) {
            int nSmallOres = (eX - wX) * (sZ - nZ) * this.mDensity / 10 * GT_Values.oreveinPlacerOresMultiplier;
            for (int nSmallOresCount = 0; nSmallOresCount < nSmallOres; ++nSmallOresCount) {
                int tX2 = aRandom.nextInt(16) + aChunkX + 2;
                int tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                int tY = aRandom.nextInt(160) + 10;
                if (this.mPrimaryMeta > 0) {
                    GT_TileEntity_Ores.setOreBlock(aWorld, tX2, tY, tZ2, this.mPrimaryMeta, true, isUnderdark);
                }
                tX2 = aRandom.nextInt(16) + aChunkX + 2;
                tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                tY = aRandom.nextInt(160) + 10;
                if (this.mSecondaryMeta > 0) {
                    GT_TileEntity_Ores.setOreBlock(aWorld, tX2, tY, tZ2, this.mSecondaryMeta, true, isUnderdark);
                }
                tX2 = aRandom.nextInt(16) + aChunkX + 2;
                tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                tY = aRandom.nextInt(160) + 10;
                if (this.mBetweenMeta > 0) {
                    GT_TileEntity_Ores.setOreBlock(aWorld, tX2, tY, tZ2, this.mBetweenMeta, true, isUnderdark);
                }
                tX2 = aRandom.nextInt(16) + aChunkX + 2;
                tZ2 = aRandom.nextInt(16) + aChunkZ + 2;
                tY = aRandom.nextInt(190) + 10;
                if (this.mSporadicMeta <= 0) continue;
                GT_TileEntity_Ores.setOreBlock(aWorld, tX2, tY, tZ2, this.mSporadicMeta, true, isUnderdark);
            }
        }
        if (GT_Values.debugOrevein) {
            GT_Log.out.println(" wXVein" + wXVein + " eXVein" + eXVein + " nZVein" + nZVein + " sZVein" + sZVein + " locDen=" + localDensity + " Den=" + this.mDensity + " Sec=" + placeCount[1] + " Spo=" + placeCount[3] + " Bet=" + placeCount[2] + " Pri=" + placeCount[0]);
        }
        return 4;
    }
}

