/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_Pollution;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkWatchEvent;

public class GT_Pollution {
    private List<ChunkCoordIntPair> pollutionList = new ArrayList<ChunkCoordIntPair>();
    private HashMap<ChunkCoordIntPair, int[]> chunkData;
    private int operationsPerTick = 0;
    private static final short cycleLen = 1200;
    private final World aWorld;
    public static int mPlayerPollution;
    private static int POLLUTIONPACKET_MINVALUE;
    private static GT_PollutionEventHandler EVENT_HANDLER;

    public GT_Pollution(World world) {
        this.aWorld = world;
        this.chunkData = GT_Proxy.dimensionWiseChunkData.get(this.aWorld.provider.dimensionId);
        if (this.chunkData == null) {
            this.chunkData = new HashMap(1024);
            GT_Proxy.dimensionWiseChunkData.put(world.provider.dimensionId, this.chunkData);
        }
        GT_Proxy.dimensionWisePollution.put(this.aWorld.provider.dimensionId, this);
        if (EVENT_HANDLER == null) {
            EVENT_HANDLER = new GT_PollutionEventHandler();
            MinecraftForge.EVENT_BUS.register((Object)EVENT_HANDLER);
        }
    }

    public static void onWorldTick(TickEvent.WorldTickEvent aEvent) {
        if (!GT_Mod.gregtechproxy.mPollution) {
            return;
        }
        GT_Pollution pollutionInstance = GT_Proxy.dimensionWisePollution.get(aEvent.world.provider.dimensionId);
        if (pollutionInstance == null) {
            return;
        }
        pollutionInstance.tickPollutionInWorld((int)(aEvent.world.getTotalWorldTime() % 1200L));
    }

    private void tickPollutionInWorld(int aTickID) {
        if (aTickID == 0) {
            this.pollutionList = new ArrayList<ChunkCoordIntPair>(this.chunkData.keySet());
            this.operationsPerTick = this.pollutionList.size() > 0 ? this.pollutionList.size() / 1200 : 0;
        }
        for (int chunksProcessed = 0; chunksProcessed <= this.operationsPerTick && this.pollutionList.size() != 0; ++chunksProcessed) {
            ChunkCoordIntPair actualPos = this.pollutionList.remove(this.pollutionList.size() - 1);
            if (!this.chunkData.containsKey(actualPos)) {
                this.chunkData.put(actualPos, GT_Proxy.getDefaultChunkDataOnCreation());
            }
            int tPollution = this.chunkData.get(actualPos)[1];
            if ((tPollution = (int)(0.9945f * (float)tPollution)) <= 0) {
                tPollution = 0;
            } else if (tPollution > 400000) {
                ChunkCoordIntPair[] tNeighbors = new ChunkCoordIntPair[]{new ChunkCoordIntPair(actualPos.chunkXPos + 1, actualPos.chunkZPos), new ChunkCoordIntPair(actualPos.chunkXPos - 1, actualPos.chunkZPos), new ChunkCoordIntPair(actualPos.chunkXPos, actualPos.chunkZPos + 1), new ChunkCoordIntPair(actualPos.chunkXPos, actualPos.chunkZPos - 1)};
                for (ChunkCoordIntPair neighborPosition : tNeighbors) {
                    int neighborPollution;
                    if (!this.chunkData.containsKey(neighborPosition)) {
                        this.chunkData.put(neighborPosition, GT_Proxy.getDefaultChunkDataOnCreation());
                    }
                    if ((neighborPollution = this.chunkData.get(neighborPosition)[1]) * 6 >= tPollution * 5) continue;
                    int tDiff = tPollution - neighborPollution;
                    neighborPollution = GT_Utility.safeInt((long)neighborPollution + (long)(tDiff /= 20));
                    tPollution -= tDiff;
                    this.chunkData.get((Object)neighborPosition)[1] = neighborPollution;
                }
                if (tPollution > GT_Mod.gregtechproxy.mPollutionSmogLimit) {
                    AxisAlignedBB chunk = AxisAlignedBB.getBoundingBox((double)(actualPos.chunkXPos << 4), (double)0.0, (double)(actualPos.chunkZPos << 4), (double)((actualPos.chunkXPos << 4) + 16), (double)256.0, (double)((actualPos.chunkZPos << 4) + 16));
                    List tEntitys = this.aWorld.getEntitiesWithinAABB(EntityLivingBase.class, chunk);
                    for (EntityLivingBase tEnt : tEntitys) {
                        if (tEnt instanceof EntityPlayerMP && ((EntityPlayerMP)tEnt).capabilities.isCreativeMode || GT_Utility.isWearingFullGasHazmat(tEnt)) continue;
                        switch (XSTR.XSTR_INSTANCE.nextInt(3)) {
                            default: {
                                tEnt.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                            }
                            case 1: {
                                tEnt.addPotionEffect(new PotionEffect(Potion.weakness.id, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                            }
                            case 2: 
                        }
                        tEnt.addPotionEffect(new PotionEffect(Potion.moveSlowdown.id, Math.min(tPollution / 1000, 1000), tPollution / 400000));
                    }
                    if (tPollution > GT_Mod.gregtechproxy.mPollutionPoisonLimit) {
                        for (EntityLivingBase tEnt : tEntitys) {
                            if (tEnt instanceof EntityPlayerMP && ((EntityPlayerMP)tEnt).capabilities.isCreativeMode || GT_Utility.isWearingFullGasHazmat(tEnt)) continue;
                            switch (XSTR.XSTR_INSTANCE.nextInt(4)) {
                                default: {
                                    tEnt.addPotionEffect(new PotionEffect(Potion.hunger.id, tPollution / 500000));
                                }
                                case 1: {
                                    tEnt.addPotionEffect(new PotionEffect(Potion.confusion.id, Math.min(tPollution / 2000, 1000), 1));
                                }
                                case 2: {
                                    tEnt.addPotionEffect(new PotionEffect(Potion.poison.id, Math.min(tPollution / 4000, 1000), tPollution / 500000));
                                }
                                case 3: 
                            }
                            tEnt.addPotionEffect(new PotionEffect(Potion.blindness.id, Math.min(tPollution / 2000, 1000), 1));
                        }
                        if (tPollution > GT_Mod.gregtechproxy.mPollutionVegetationLimit) {
                            for (int f = 20; f < tPollution / 25000; ++f) {
                                int x = (actualPos.chunkXPos << 4) + XSTR.XSTR_INSTANCE.nextInt(16);
                                int y = 60 + (-f + XSTR.XSTR_INSTANCE.nextInt(f * 2 + 1));
                                int z = (actualPos.chunkZPos << 4) + XSTR.XSTR_INSTANCE.nextInt(16);
                                GT_Pollution.damageBlock(this.aWorld, x, y, z, tPollution > GT_Mod.gregtechproxy.mPollutionSourRainLimit);
                            }
                        }
                    }
                }
            }
            this.chunkData.get((Object)actualPos)[1] = tPollution;
            if (tPollution <= POLLUTIONPACKET_MINVALUE) continue;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.aWorld.provider.dimensionId, (double)(actualPos.chunkXPos << 4), 64.0, (double)(actualPos.chunkZPos << 4), 256.0);
            GT_Values.NW.sendToAllAround(new GT_Packet_Pollution(actualPos, tPollution), point);
        }
    }

    private static void damageBlock(World world, int x, int y, int z, boolean sourRain) {
        if (world.isRemote) {
            return;
        }
        Block tBlock = world.getBlock(x, y, z);
        int tMeta = world.getBlockMetadata(x, y, z);
        if (tBlock == Blocks.air || tBlock == Blocks.stone || tBlock == Blocks.sand || tBlock == Blocks.deadbush) {
            return;
        }
        if (tBlock == Blocks.leaves || tBlock == Blocks.leaves2 || tBlock.getMaterial() == Material.leaves) {
            world.setBlockToAir(x, y, z);
        }
        if (tBlock == Blocks.reeds) {
            tBlock.dropBlockAsItem(world, x, y, z, tMeta, 0);
            world.setBlockToAir(x, y, z);
        }
        if (tBlock == Blocks.tallgrass) {
            world.setBlock(x, y, z, (Block)Blocks.deadbush);
        }
        if (tBlock == Blocks.vine) {
            tBlock.dropBlockAsItem(world, x, y, z, tMeta, 0);
            world.setBlockToAir(x, y, z);
        }
        if (tBlock == Blocks.waterlily || tBlock == Blocks.wheat || tBlock == Blocks.cactus || tBlock.getMaterial() == Material.cactus || tBlock == Blocks.melon_block || tBlock == Blocks.melon_stem) {
            tBlock.dropBlockAsItem(world, x, y, z, tMeta, 0);
            world.setBlockToAir(x, y, z);
        }
        if (tBlock == Blocks.red_flower || tBlock == Blocks.yellow_flower || tBlock == Blocks.carrots || tBlock == Blocks.potatoes || tBlock == Blocks.pumpkin || tBlock == Blocks.pumpkin_stem) {
            tBlock.dropBlockAsItem(world, x, y, z, tMeta, 0);
            world.setBlockToAir(x, y, z);
        }
        if (tBlock == Blocks.sapling || tBlock.getMaterial() == Material.plants) {
            world.setBlock(x, y, z, (Block)Blocks.deadbush);
        }
        if (tBlock == Blocks.cocoa) {
            tBlock.dropBlockAsItem(world, x, y, z, tMeta, 0);
            world.setBlockToAir(x, y, z);
        }
        if (tBlock == Blocks.mossy_cobblestone) {
            world.setBlock(x, y, z, Blocks.cobblestone);
        }
        if (tBlock == Blocks.grass || tBlock.getMaterial() == Material.grass) {
            world.setBlock(x, y, z, Blocks.dirt);
        }
        if (tBlock == Blocks.farmland || tBlock == Blocks.dirt) {
            world.setBlock(x, y, z, (Block)Blocks.sand);
        }
        if (sourRain && world.isRaining() && (tBlock == Blocks.stone || tBlock == Blocks.gravel || tBlock == Blocks.cobblestone) && world.getBlock(x, y + 1, z) == Blocks.air && world.canBlockSeeTheSky(x, y, z)) {
            if (tBlock == Blocks.stone) {
                world.setBlock(x, y, z, Blocks.cobblestone);
            } else if (tBlock == Blocks.cobblestone) {
                world.setBlock(x, y, z, Blocks.gravel);
            } else if (tBlock == Blocks.gravel) {
                world.setBlock(x, y, z, (Block)Blocks.sand);
            }
        }
    }

    public static void addPollution(IGregTechTileEntity te, int aPollution) {
        GT_Pollution.addPollution(te.getWorld().getChunkFromBlockCoords(te.getXCoord(), te.getZCoord()), aPollution);
    }

    public static void addPollution(Chunk ch, int aPollution) {
        int[] dataArr;
        if (!GT_Mod.gregtechproxy.mPollution) {
            return;
        }
        HashMap<Object, Object> dataMap = GT_Proxy.dimensionWiseChunkData.get(ch.worldObj.provider.dimensionId);
        if (dataMap == null) {
            dataMap = new HashMap(1024);
            GT_Proxy.dimensionWiseChunkData.put(ch.worldObj.provider.dimensionId, dataMap);
        }
        if ((dataArr = dataMap.get(ch.getChunkCoordIntPair())) == null) {
            dataArr = GT_Proxy.getDefaultChunkDataOnCreation();
            dataMap.put(ch.getChunkCoordIntPair(), dataArr);
        }
        dataArr[1] = dataArr[1] + aPollution;
        if (dataArr[1] < 0) {
            dataArr[1] = 0;
        }
    }

    public static int getPollution(IGregTechTileEntity te) {
        return GT_Pollution.getPollution(te.getWorld().getChunkFromBlockCoords(te.getXCoord(), te.getZCoord()));
    }

    public static int getPollution(Chunk ch) {
        if (!GT_Mod.gregtechproxy.mPollution) {
            return 0;
        }
        HashMap<ChunkCoordIntPair, int[]> dataMap = GT_Proxy.dimensionWiseChunkData.get(ch.worldObj.provider.dimensionId);
        if (dataMap == null || dataMap.get(ch.getChunkCoordIntPair()) == null) {
            return 0;
        }
        return dataMap.get(ch.getChunkCoordIntPair())[1];
    }

    public static int getPollution(ChunkCoordIntPair aCh, int aDim) {
        if (!GT_Mod.gregtechproxy.mPollution) {
            return 0;
        }
        HashMap<ChunkCoordIntPair, int[]> dataMap = GT_Proxy.dimensionWiseChunkData.get(aDim);
        if (dataMap == null || dataMap.get(aCh) == null) {
            return 0;
        }
        return dataMap.get(aCh)[1];
    }

    @Deprecated
    public static void addPollution(World aWorld, ChunkPosition aPos, int aPollution) {
        GT_Pollution.addPollution(aWorld.getChunkFromBlockCoords(aPos.chunkPosX, aPos.chunkPosZ), aPollution);
    }

    static {
        POLLUTIONPACKET_MINVALUE = 1000;
    }

    public class GT_PollutionEventHandler {
        @SubscribeEvent
        public void chunkWatch(ChunkWatchEvent.Watch event) {
            int pollution;
            if (!GT_Mod.gregtechproxy.mPollution) {
                return;
            }
            if (GT_Pollution.this.chunkData.containsKey(event.chunk) && (pollution = ((int[])GT_Pollution.this.chunkData.get(event.chunk))[1]) > POLLUTIONPACKET_MINVALUE) {
                GT_Values.NW.sendToPlayer(new GT_Packet_Pollution(event.chunk, pollution), event.player);
            }
        }
    }
}

