/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ConfigCategories;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TC_Aspects;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class GT_RecipeRegistrator {
    public static final List<Materials> sRodMaterialList = new ArrayList<Materials>();
    private static final ItemStack sMt1 = new ItemStack(Blocks.dirt, 1, 0);
    private static final ItemStack sMt2 = new ItemStack(Blocks.dirt, 1, 0);
    private static final String s_H = "h";
    private static final String s_F = "f";
    private static final String s_I = "I";
    private static final String s_P = "P";
    private static final String s_R = "R";
    private static final RecipeShape[] sShapes = new RecipeShape[]{new RecipeShape(sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1, null), new RecipeShape(sMt1, null, sMt1, sMt1, null, sMt1, sMt1, sMt1, sMt1), new RecipeShape(null, sMt1, null, sMt1, sMt1, sMt1, sMt1, null, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, null, sMt1, null, null, null), new RecipeShape(sMt1, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, null, sMt1, sMt1, null, sMt1), new RecipeShape(null, null, null, sMt1, null, sMt1, sMt1, null, sMt1), new RecipeShape(null, sMt1, null, null, sMt1, null, null, sMt2, null), new RecipeShape(sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, null, null, sMt2, null, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, sMt1, null, sMt2, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, sMt1, null, sMt2, null, null, sMt2, null), new RecipeShape(null, sMt1, null, sMt1, null, null, null, sMt1, sMt2), new RecipeShape(null, sMt1, null, null, null, sMt1, sMt2, sMt1, null), new RecipeShape(null, sMt1, null, sMt1, null, sMt1, null, null, sMt2), new RecipeShape(null, sMt1, null, sMt1, null, sMt1, sMt2, null, null), new RecipeShape(null, sMt2, null, null, sMt1, null, null, sMt1, null), new RecipeShape(null, sMt2, null, null, sMt2, null, sMt1, sMt1, sMt1), new RecipeShape(null, sMt2, null, null, sMt2, null, null, sMt1, null), new RecipeShape(null, sMt2, null, sMt1, sMt2, null, sMt1, sMt1, null), new RecipeShape(null, sMt2, null, null, sMt2, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, null, sMt2, null, sMt1, sMt1, null), new RecipeShape(sMt1, null, null, null, sMt2, null, null, null, sMt2), new RecipeShape(null, null, sMt1, null, sMt2, null, sMt2, null, null), new RecipeShape(sMt1, null, null, null, sMt2, null, null, null, null), new RecipeShape(null, null, sMt1, null, sMt2, null, null, null, null), new RecipeShape(sMt1, sMt2, null, null, null, null, null, null, null), new RecipeShape(sMt2, sMt1, null, null, null, null, null, null, null), new RecipeShape(sMt1, null, null, sMt2, null, null, null, null, null), new RecipeShape(sMt2, null, null, sMt1, null, null, null, null, null), new RecipeShape(sMt1, sMt1, sMt1, sMt1, sMt1, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt1, sMt2, sMt1, sMt1, null), new RecipeShape(null, sMt1, sMt1, sMt2, sMt1, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, sMt1, sMt1, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, sMt1, sMt1, sMt1, sMt2, sMt1, null, sMt2, null), new RecipeShape(sMt1, sMt1, null, sMt1, sMt2, sMt2, sMt1, sMt1, null), new RecipeShape(null, sMt1, sMt1, sMt2, sMt2, sMt1, null, sMt1, sMt1), new RecipeShape(null, sMt2, null, sMt1, sMt2, sMt1, sMt1, sMt1, sMt1), new RecipeShape(sMt1, null, null, null, sMt1, null, null, null, null), new RecipeShape(null, sMt1, null, sMt1, null, null, null, null, null), new RecipeShape(sMt1, sMt1, null, sMt2, null, sMt1, sMt2, null, null), new RecipeShape(null, sMt1, sMt1, sMt1, null, sMt2, null, null, sMt2)};
    private static final String[][] sShapesA = new String[][]{null, null, null, {"Helmet", "PPP", "PhP"}, {"ChestPlate", "PhP", "PPP", "PPP"}, {"Pants", "PPP", "PhP", "P P"}, {"Boots", "P P", "PhP"}, {"Sword", " P ", "fPh", " R "}, {"Pickaxe", "PII", "fRh", " R "}, {"Shovel", "fPh", " R ", " R "}, {"Axe", "PIh", "PR ", "fR "}, {"Axe", "PIh", "PR ", "fR "}, {"Hoe", "PIh", "fR ", " R "}, {"Hoe", "PIh", "fR ", " R "}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sickle", " P ", "Pf ", "hPR"}, {"Sword", " R ", "fPh", " P "}, {"Pickaxe", " R ", "fRh", "PII"}, {"Shovel", " R ", " R ", "fPh"}, {"Axe", "fR ", "PR ", "PIh"}, {"Axe", "fR ", "PR ", "PIh"}, {"Hoe", " R ", "fR ", "PIh"}, {"Hoe", " R ", "fR ", "PIh"}, {"Spear", "Ph ", "fR ", "  R"}, {"Spear", "Ph ", "fR ", "  R"}, {"Knive", "hP", "Rf"}, {"Knive", "fh", "PR"}, {"Knive", "fh", "PR"}, {"Knive", "Pf", "Rh"}, {"Knive", "Pf", "Rh"}, null, null, null, null, {"WarAxe", "PPP", "PRP", "fRh"}, null, null, null, {"Shears", "hP", "Pf"}, {"Shears", "hP", "Pf"}, {"Scythe", "IPh", "RfP", "R  "}, {"Scythe", "hPI", "PfR", "  R"}};
    public static volatile int VERSION = 509;
    private static final Materials[] VANILLA_MATS = new Materials[]{Materials.Cobalt, Materials.Gold, Materials.Iron, Materials.Lead, Materials.FierySteel, Materials.Void, Materials.Bronze, Materials.Diamond, Materials.Ruby, Materials.Sapphire, Materials.Steel, Materials.IronWood, Materials.Steeleaf, Materials.Knightmetal, Materials.Thaumium, Materials.DarkSteel};

    public static void registerMaterialRecycling(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByproduct) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        if (aByproduct != null) {
            aByproduct = aByproduct.clone();
            aByproduct.mAmount /= (long)aStack.stackSize;
        }
        GT_OreDictUnificator.addItemData(GT_Utility.copyAmount(1L, aStack), new ItemData(aMaterial, aMaterialAmount / (long)aStack.stackSize, aByproduct));
    }

    public static void registerMaterialRecycling(ItemStack aStack, ItemData aData) {
        if (GT_Utility.isStackInvalid(aStack) || GT_Utility.areStacksEqual(new ItemStack(Items.blaze_rod), aStack) || aData == null || !aData.hasValidMaterialData() || aData.mMaterial.mAmount <= 0L || GT_Utility.getFluidForFilledItem(aStack, false) != null) {
            return;
        }
        GT_RecipeRegistrator.registerReverseMacerating(GT_Utility.copyAmount(1L, aStack), aData, aData.mPrefix == null);
        GT_RecipeRegistrator.registerReverseSmelting(GT_Utility.copyAmount(1L, aStack), aData.mMaterial.mMaterial, aData.mMaterial.mAmount, true);
        GT_RecipeRegistrator.registerReverseFluidSmelting(GT_Utility.copyAmount(1L, aStack), aData.mMaterial.mMaterial, aData.mMaterial.mAmount, aData.getByProduct(0));
        GT_RecipeRegistrator.registerReverseArcSmelting(GT_Utility.copyAmount(1L, aStack), aData);
    }

    public static void registerReverseFluidSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByproduct) {
        boolean tHide;
        if (aStack == null || aMaterial == null || aMaterial.mSmeltInto.mStandardMoltenFluid == null || !aMaterial.contains(SubTag.SMELTING_TO_FLUID) || 144L * aMaterialAmount / (3628800L * (long)aStack.stackSize) <= 0L) {
            return;
        }
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        boolean bl = tHide = aStack.getUnlocalizedName().startsWith("gt.blockmachines") && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        if (GT_Mod.gregtechproxy.mHideRecyclingRecipes && tData != null && tData.hasValidPrefixData() && tData.mPrefix != OrePrefixes.dust && tData.mPrefix != OrePrefixes.ingot && !(tData.mPrefix == OrePrefixes.block | tData.mPrefix == OrePrefixes.plate)) {
            tHide = true;
        }
        GT_Values.RA.addFluidSmelterRecipe(GT_Utility.copyAmount(1L, aStack), (ItemStack)(aByproduct == null ? null : (aByproduct.mMaterial.contains(SubTag.NO_SMELTING) || !aByproduct.mMaterial.contains(SubTag.METAL) ? (aByproduct.mMaterial.contains(SubTag.FLAMMABLE) ? GT_OreDictUnificator.getDust(Materials.Ash, aByproduct.mAmount / 2L) : (aByproduct.mMaterial.contains(SubTag.UNBURNABLE) ? GT_OreDictUnificator.getDustOrIngot(aByproduct.mMaterial.mSmeltInto, aByproduct.mAmount) : null)) : GT_OreDictUnificator.getIngotOrDust(aByproduct.mMaterial.mSmeltInto, aByproduct.mAmount))), aMaterial.mSmeltInto.getMolten(144L * aMaterialAmount / (3628800L * (long)aStack.stackSize)), 10000, (int)Math.max(1L, 24L * aMaterialAmount / 3628800L), Math.max(8, (int)Math.sqrt(2 * aMaterial.mSmeltInto.mStandardMoltenFluid.getTemperature())), tHide);
    }

    public static void registerReverseSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, boolean aAllowAlloySmelter) {
        boolean tHide;
        if (aStack == null || aMaterial == null || aMaterialAmount <= 0L || aMaterial.contains(SubTag.NO_SMELTING) || aMaterialAmount > 3628800L && aMaterial.contains(SubTag.METAL)) {
            return;
        }
        aMaterialAmount /= (long)aStack.stackSize;
        if (aMaterial == Materials.Naquadah || aMaterial == Materials.NaquadahEnriched) {
            return;
        }
        boolean bl = tHide = aMaterial != Materials.Iron && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        if (aAllowAlloySmelter) {
            GT_ModHandler.addSmeltingAndAlloySmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.getIngot(aMaterial.mSmeltInto, aMaterialAmount), tHide);
        } else {
            GT_ModHandler.addSmeltingRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.getIngot(aMaterial.mSmeltInto, aMaterialAmount));
        }
    }

    public static void registerReverseArcSmelting(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByProduct01, MaterialStack aByProduct02, MaterialStack aByProduct03) {
        GT_RecipeRegistrator.registerReverseArcSmelting(aStack, new ItemData(aMaterial == null ? null : new MaterialStack(aMaterial, aMaterialAmount), aByProduct01, aByProduct02, aByProduct03));
    }

    public static void registerReverseArcSmelting(ItemStack aStack, ItemData aData) {
        if (aStack == null || aData == null) {
            return;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        boolean tIron = false;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            if (tMaterial.mMaterial == Materials.Iron || tMaterial.mMaterial == Materials.Copper || tMaterial.mMaterial == Materials.WroughtIron || tMaterial.mMaterial == Materials.AnnealedCopper) {
                tIron = true;
            }
            if (tMaterial.mMaterial.contains(SubTag.UNBURNABLE)) {
                tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mArcSmeltInto;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.EXPLOSIVE)) {
                tMaterial.mMaterial = Materials.Ash;
                tMaterial.mAmount /= 16L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.FLAMMABLE)) {
                tMaterial.mMaterial = Materials.Ash;
                tMaterial.mAmount /= 8L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.NO_SMELTING)) {
                tMaterial.mAmount = 0L;
                continue;
            }
            if (tMaterial.mMaterial.contains(SubTag.METAL)) {
                if (GT_Mod.gregtechproxy.mArcSmeltIntoAnnealed) {
                    tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mArcSmeltInto;
                    continue;
                }
                tMaterial.mMaterial = tMaterial.mMaterial.mSmeltInto.mSmeltInto;
                continue;
            }
            tMaterial.mAmount = 0L;
        }
        aData = new ItemData(aData);
        if (aData.mByProducts.length > 3) {
            for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
                if (tMaterial.mMaterial != Materials.Ash) continue;
                tMaterial.mAmount = 0L;
            }
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        long tAmount = 0L;
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
        }
        boolean tHide = !tIron && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        GT_Values.RA.addArcFurnaceRecipe(aStack, new ItemStack[]{GT_OreDictUnificator.getIngotOrDust(aData.mMaterial), GT_OreDictUnificator.getIngotOrDust(aData.getByProduct(0)), GT_OreDictUnificator.getIngotOrDust(aData.getByProduct(1)), GT_OreDictUnificator.getIngotOrDust(aData.getByProduct(2))}, null, (int)Math.max(16L, tAmount / 3628800L), 90, tHide);
    }

    public static void registerReverseMacerating(ItemStack aStack, Materials aMaterial, long aMaterialAmount, MaterialStack aByProduct01, MaterialStack aByProduct02, MaterialStack aByProduct03, boolean aAllowHammer) {
        GT_RecipeRegistrator.registerReverseMacerating(aStack, new ItemData(aMaterial == null ? null : new MaterialStack(aMaterial, aMaterialAmount), aByProduct01, aByProduct02, aByProduct03), aAllowHammer);
    }

    public static void registerReverseMacerating(ItemStack aStack, ItemData aData, boolean aAllowHammer) {
        ItemStack itemStack;
        if (aStack == null || aData == null) {
            return;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
            tMaterial.mMaterial = tMaterial.mMaterial.mMacerateInto;
        }
        if (!(aData = new ItemData(aData)).hasValidMaterialData()) {
            return;
        }
        long tAmount = 0L;
        for (MaterialStack materialStack : aData.getAllMaterialStacks()) {
            tAmount += materialStack.mAmount * materialStack.mMaterial.getMass();
        }
        boolean tHide = aData.mMaterial.mMaterial != Materials.Iron && GT_Mod.gregtechproxy.mHideRecyclingRecipes;
        GT_Values.RA.addPulveriserRecipe(aStack, new ItemStack[]{GT_OreDictUnificator.getDust(aData.mMaterial), GT_OreDictUnificator.getDust(aData.getByProduct(0)), GT_OreDictUnificator.getDust(aData.getByProduct(1)), GT_OreDictUnificator.getDust(aData.getByProduct(2))}, null, aData.mMaterial.mMaterial == Materials.Marble ? 1 : (int)Math.max(16L, tAmount / 3628800L), 4, tHide);
        if (aAllowHammer) {
            for (MaterialStack tMaterial : aData.getAllMaterialStacks()) {
                if (!tMaterial.mMaterial.contains(SubTag.CRYSTAL) || tMaterial.mMaterial.contains(SubTag.METAL) || tMaterial.mMaterial == Materials.Glass || !GT_Values.RA.addForgeHammerRecipe(GT_Utility.copyAmount(1L, aStack), GT_OreDictUnificator.getDust(aData.mMaterial), 200, 30)) continue;
                break;
            }
        }
        if ((itemStack = GT_OreDictUnificator.getDust(aData.mMaterial)) != null && GT_ModHandler.addPulverisationRecipe(GT_Utility.copyAmount(1L, aStack), itemStack, GT_OreDictUnificator.getDust(aData.getByProduct(0)), 100, GT_OreDictUnificator.getDust(aData.getByProduct(1)), 100, true) && GregTech_API.sThaumcraftCompat != null) {
            GregTech_API.sThaumcraftCompat.addCrucibleRecipe("GT_ADVANCEDENTROPICPROCESSING", aStack, itemStack, Arrays.asList(new TC_Aspects.TC_AspectStack(TC_Aspects.PERDITIO, Math.max(1L, aData.mMaterial.mAmount * 2L / 3628800L))));
        }
    }

    public static synchronized void registerUsagesForMaterials(String aPlate, boolean aRecipeReplacing, ItemStack ... aMats) {
        for (ItemStack aMat : aMats) {
            if ((aMat = GT_Utility.copyOrNull(aMat)) == null) continue;
            ItemData aItemData = GT_OreDictUnificator.getItemData(aMat);
            if (aItemData == null || aItemData.mPrefix != OrePrefixes.ingot) {
                aPlate = null;
            }
            if (aPlate != null && GT_OreDictUnificator.getFirstOre(aPlate, 1L) == null) {
                aPlate = null;
            }
            sMt1.func_150996_a(aMat.getItem());
            GT_RecipeRegistrator.sMt1.stackSize = 1;
            Items.feather.setDamage(sMt1, Items.feather.getDamage(aMat));
            sMt2.func_150996_a(new ItemStack(Blocks.dirt).getItem());
            GT_RecipeRegistrator.sMt2.stackSize = 1;
            Items.feather.setDamage(sMt2, 0);
            if (aItemData != null && aItemData.hasValidPrefixMaterialData()) {
                for (RecipeShape tRecipe : sShapes) {
                    for (ItemStack tCrafted : GT_ModHandler.getRecipeOutputsBuffered(tRecipe.shape)) {
                        GT_OreDictUnificator.addItemData(tCrafted, new ItemData(aItemData.mMaterial.mMaterial, aItemData.mMaterial.mAmount * (long)tRecipe.amount1, new MaterialStack[0]));
                    }
                }
            }
            GT_RecipeRegistrator.registerStickStuff(aPlate, aItemData, aRecipeReplacing);
        }
    }

    private static synchronized void registerStickStuff(String aPlate, ItemData aItemData, boolean aRecipeReplacing) {
        for (Materials tMaterial : sRodMaterialList) {
            ItemStack tMt2 = GT_OreDictUnificator.get(OrePrefixes.stick, tMaterial, 1L);
            if (tMt2 == null) continue;
            sMt2.func_150996_a(tMt2.getItem());
            GT_RecipeRegistrator.sMt2.stackSize = 1;
            Items.feather.setDamage(sMt2, Items.feather.getDamage(tMt2));
            for (int i = 0; i < sShapes.length; ++i) {
                RecipeShape tRecipe = sShapes[i];
                block6: for (ItemStack tCrafted : GT_ModHandler.getVanillyToolRecipeOutputs(tRecipe.shape)) {
                    ItemStack tStack;
                    if (aItemData != null && aItemData.hasValidPrefixMaterialData()) {
                        GT_OreDictUnificator.addItemData(tCrafted, new ItemData(aItemData.mMaterial.mMaterial, aItemData.mMaterial.mAmount * (long)tRecipe.amount1, new MaterialStack(tMaterial, OrePrefixes.stick.mMaterialAmount * (long)tRecipe.amount2)));
                    }
                    if (!aRecipeReplacing || aPlate == null || sShapesA[i] == null || sShapesA[i].length <= 1) continue;
                    assert (aItemData != null);
                    if (!GregTech_API.sRecipeFile.get((Object)ConfigCategories.Recipes.recipereplacements, aItemData.mMaterial.mMaterial + "." + sShapesA[i][0], true) || null == (tStack = GT_ModHandler.removeRecipe(tRecipe.shape))) continue;
                    switch (sShapesA[i].length) {
                        case 2: {
                            GT_ModHandler.addCraftingRecipe(tStack, GT_ModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                            continue block6;
                        }
                        case 3: {
                            GT_ModHandler.addCraftingRecipe(tStack, GT_ModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], sShapesA[i][2], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                            continue block6;
                        }
                    }
                    GT_ModHandler.addCraftingRecipe(tStack, GT_ModHandler.RecipeBits.BUFFERED, new Object[]{sShapesA[i][1], sShapesA[i][2], sShapesA[i][3], Character.valueOf(s_P.charAt(0)), aPlate, Character.valueOf(s_R.charAt(0)), OrePrefixes.stick.get(tMaterial), Character.valueOf(s_I.charAt(0)), aItemData});
                }
            }
        }
    }

    public static boolean hasVanillaRecipes(Materials materials) {
        return Arrays.stream(VANILLA_MATS).anyMatch(mat -> mat == materials);
    }

    private static class RecipeShape {
        private final ItemStack[] shape;
        private int amount1;
        private int amount2;

        public RecipeShape(ItemStack ... shape) {
            this.shape = shape;
            for (ItemStack stack : shape) {
                if (stack == sMt1) {
                    ++this.amount1;
                }
                if (stack != sMt2) continue;
                ++this.amount2;
            }
        }
    }
}

