/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.threads;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.tileentity.IMachineBlockUpdateable;
import gregtech.common.GT_Proxy;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class GT_Runnable_MachineBlockUpdate
implements Runnable {
    protected final ChunkCoordinates mCoords;
    protected final World world;
    protected final Set<ChunkCoordinates> visited = new HashSet<ChunkCoordinates>(80);
    protected final Queue<ChunkCoordinates> tQueue = new LinkedList<ChunkCoordinates>();
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread thread = new Thread(r);
        thread.setName("GT_MachineBlockUpdate");
        return thread;
    };
    protected static ExecutorService EXECUTOR_SERVICE;
    protected static boolean isEnabled;

    protected GT_Runnable_MachineBlockUpdate(World aWorld, ChunkCoordinates aCoords) {
        this.world = aWorld;
        this.mCoords = aCoords;
        this.visited.add(aCoords);
        this.tQueue.add(aCoords);
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static void setEnabled() {
        isEnabled = true;
    }

    public static void setDisabled() {
        isEnabled = false;
    }

    public static void setEnabled(boolean isEnabled) {
        GT_Runnable_MachineBlockUpdate.isEnabled = isEnabled;
    }

    public static void setMachineUpdateValues(World aWorld, ChunkCoordinates aCoords) {
        if (isEnabled) {
            EXECUTOR_SERVICE.submit(new GT_Runnable_MachineBlockUpdate(aWorld, aCoords));
        }
    }

    public static void initExecutorService() {
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() * 2 / 3), THREAD_FACTORY);
    }

    public static void shutdownExecutorService() {
        try {
            GT_Mod.GT_FML_LOGGER.info("Shutting down Machine block update executor service");
            EXECUTOR_SERVICE.shutdown();
            if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                EXECUTOR_SERVICE.shutdownNow();
                if (!EXECUTOR_SERVICE.awaitTermination(60L, TimeUnit.SECONDS)) {
                    GT_Mod.GT_FML_LOGGER.error("Well this didn't terminated well... GT_Runnable_MachineBlockUpdate.shutdownExecutorService");
                }
            }
        }
        catch (InterruptedException ie) {
            GT_Mod.GT_FML_LOGGER.error("Well this interruption got interrupted...", (Throwable)ie);
            EXECUTOR_SERVICE.shutdownNow();
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Well this didn't terminated well...", (Throwable)e);
            EXECUTOR_SERVICE.shutdownNow();
        }
        finally {
            GT_Mod.GT_FML_LOGGER.info("Leaving... GT_Runnable_MachineBlockUpdate.shutdownExecutorService");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.tQueue.isEmpty()) {
                boolean isMachineBlock;
                TileEntity tTileEntity;
                ChunkCoordinates aCoords = this.tQueue.poll();
                GT_Proxy.TICK_LOCK.lock();
                try {
                    tTileEntity = this.world.getTileEntity(aCoords.posX, aCoords.posY, aCoords.posZ);
                    isMachineBlock = GregTech_API.isMachineBlock(this.world.getBlock(aCoords.posX, aCoords.posY, aCoords.posZ), this.world.getBlockMetadata(aCoords.posX, aCoords.posY, aCoords.posZ));
                }
                finally {
                    GT_Proxy.TICK_LOCK.unlock();
                }
                if (tTileEntity instanceof IMachineBlockUpdateable) {
                    ((IMachineBlockUpdateable)tTileEntity).onMachineBlockUpdate();
                }
                if (this.visited.size() >= 5 && (!(tTileEntity instanceof IMachineBlockUpdateable) || !((IMachineBlockUpdateable)tTileEntity).isMachineBlockUpdateRecursive()) && !isMachineBlock) continue;
                ChunkCoordinates tCoords = new ChunkCoordinates(aCoords.posX + 1, aCoords.posY, aCoords.posZ);
                if (this.visited.add(tCoords)) {
                    this.tQueue.add(tCoords);
                }
                if (this.visited.add(tCoords = new ChunkCoordinates(aCoords.posX - 1, aCoords.posY, aCoords.posZ))) {
                    this.tQueue.add(tCoords);
                }
                if (this.visited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY + 1, aCoords.posZ))) {
                    this.tQueue.add(tCoords);
                }
                if (this.visited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY - 1, aCoords.posZ))) {
                    this.tQueue.add(tCoords);
                }
                if (this.visited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY, aCoords.posZ + 1))) {
                    this.tQueue.add(tCoords);
                }
                if (!this.visited.add(tCoords = new ChunkCoordinates(aCoords.posX, aCoords.posY, aCoords.posZ - 1))) continue;
                this.tQueue.add(tCoords);
            }
        }
        catch (Exception e) {
            GT_Mod.GT_FML_LOGGER.error("Well this update was broken... " + this.mCoords + ", mWorld={" + this.world.getProviderName() + " @dimId " + this.world.provider.dimensionId + "}", (Throwable)e);
        }
    }

    static {
        isEnabled = true;
    }
}

