/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_New;
import gregtech.api.net.GT_Packet_TileEntityCover;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class GT_Packet_WirelessRedstoneCover
extends GT_Packet_TileEntityCover {
    private static final int PRIVATE_MASK = -131072;
    private static final int PUBLIC_MASK = 65535;
    private static final int CHECKBOX_MASK = 65536;
    private EntityPlayerMP mPlayer;
    private int mPublicChannel;
    private int mCheckBoxValue;

    public GT_Packet_WirelessRedstoneCover() {
    }

    public GT_Packet_WirelessRedstoneCover(int mX, short mY, int mZ, byte coverSide, int coverID, int dimID, int publicChannel, int checkBoxValue) {
        super(mX, mY, mZ, coverSide, coverID, 0, dimID);
        this.mPublicChannel = publicChannel;
        this.mCheckBoxValue = checkBoxValue;
    }

    public GT_Packet_WirelessRedstoneCover(byte coverSide, int coverID, ICoverable tile, int publicChannel, int checkBoxValue) {
        super(coverSide, coverID, 0, tile);
        this.mPublicChannel = publicChannel;
        this.mCheckBoxValue = checkBoxValue;
    }

    @Override
    public byte getPacketID() {
        return 10;
    }

    @Override
    public void setINetHandler(INetHandler aHandler) {
        if (aHandler instanceof NetHandlerPlayServer) {
            this.mPlayer = ((NetHandlerPlayServer)aHandler).playerEntity;
        }
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeByte((int)this.side);
        aOut.writeInt(this.coverID);
        aOut.writeInt(this.dimID);
        aOut.writeInt(this.mPublicChannel);
        aOut.writeInt(this.mCheckBoxValue);
    }

    @Override
    public GT_Packet_New decode(ByteArrayDataInput aData) {
        return new GT_Packet_WirelessRedstoneCover(aData.readInt(), aData.readShort(), aData.readInt(), aData.readByte(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        TileEntity tile;
        WorldServer world = DimensionManager.getWorld((int)this.dimID);
        if (world != null && world.blockExists(this.mX, (int)this.mY, this.mZ) && (tile = world.getTileEntity(this.mX, (int)this.mY, this.mZ)) instanceof IGregTechTileEntity && !((IGregTechTileEntity)tile).isDead()) {
            int tPrivateChannel = this.mCheckBoxValue > 0 ? this.mPlayer.getUniqueID().hashCode() & 0xFFFE0000 : 0;
            int tCoverData = tPrivateChannel | this.mCheckBoxValue & 0x10000 | this.mPublicChannel & 0xFFFF;
            ((IGregTechTileEntity)tile).receiveCoverData(this.side, this.coverID, tCoverData);
        }
    }
}

