/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs;

import gregtech.api.graphs.Node;
import gregtech.api.graphs.NodeList;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.graphs.paths.PowerNodePath;

public class PowerNodes {
    public static int powerNode(Node aCurrentNode, Node aPreviousNode, NodeList aConsumers, int aVoltage, int aMaxAmps) {
        int tAmpsUsed = 0;
        ConsumerNode tConsumer = (ConsumerNode)aConsumers.getNode();
        int tLoopProtection = 0;
        while (tConsumer != null) {
            Node tNextNode;
            int tTargetNodeValue = tConsumer.mNodeValue;
            if (tTargetNodeValue < aCurrentNode.mNodeValue || tTargetNodeValue > aCurrentNode.mHighestNodeValue) {
                for (int j = 0; j < 6; ++j) {
                    tNextNode = aCurrentNode.mNeighbourNodes[j];
                    if (tNextNode == null || tNextNode.mNodeValue >= aCurrentNode.mNodeValue) continue;
                    if (tNextNode.mNodeValue == tConsumer.mNodeValue) {
                        tAmpsUsed += PowerNodes.processNodeInject(aCurrentNode, tConsumer, j, aMaxAmps - tAmpsUsed, aVoltage, false);
                        tConsumer = (ConsumerNode)aConsumers.getNextNode();
                    } else {
                        if (aPreviousNode == tNextNode) {
                            return tAmpsUsed;
                        }
                        tAmpsUsed += PowerNodes.processNextNode(aCurrentNode, tNextNode, aConsumers, j, aMaxAmps - tAmpsUsed, aVoltage);
                        tConsumer = (ConsumerNode)aConsumers.getNode();
                    }
                    break;
                }
            } else {
                for (int side = 5; side > -1; --side) {
                    tNextNode = aCurrentNode.mNeighbourNodes[side];
                    if (tNextNode == null) continue;
                    if (tNextNode.mNodeValue > aCurrentNode.mNodeValue && tNextNode.mNodeValue < tTargetNodeValue) {
                        if (tNextNode == aPreviousNode) {
                            return tAmpsUsed;
                        }
                        tAmpsUsed += PowerNodes.processNextNodeAbove(aCurrentNode, tNextNode, aConsumers, side, aMaxAmps - tAmpsUsed, aVoltage);
                        tConsumer = (ConsumerNode)aConsumers.getNode();
                    } else {
                        if (tNextNode.mNodeValue != tTargetNodeValue) continue;
                        tAmpsUsed += PowerNodes.processNodeInject(aCurrentNode, tConsumer, side, aMaxAmps - tAmpsUsed, aVoltage, true);
                        tConsumer = (ConsumerNode)aConsumers.getNextNode();
                    }
                    break;
                }
            }
            if (aMaxAmps - tAmpsUsed <= 0) {
                return tAmpsUsed;
            }
            if (tLoopProtection++ <= 20) continue;
            throw new NullPointerException("infinite loop in powering nodes ");
        }
        return tAmpsUsed;
    }

    protected static int powerNodeAbove(Node aCurrentNode, Node aPreviousNode, NodeList aConsumers, int aVoltage, int aMaxAmps) {
        int tAmpsUsed = 0;
        int tLoopProtection = 0;
        ConsumerNode tConsumer = (ConsumerNode)aConsumers.getNode();
        while (tConsumer != null) {
            int tTargetNodeValue = tConsumer.mNodeValue;
            if (tTargetNodeValue > aCurrentNode.mHighestNodeValue || tTargetNodeValue < aCurrentNode.mNodeValue) {
                return tAmpsUsed;
            }
            for (int side = 5; side > -1; --side) {
                Node tNextNode = aCurrentNode.mNeighbourNodes[side];
                if (tNextNode == null) continue;
                if (tNextNode.mNodeValue > aCurrentNode.mNodeValue && tNextNode.mNodeValue < tTargetNodeValue) {
                    if (tNextNode == aPreviousNode) {
                        return tAmpsUsed;
                    }
                    tAmpsUsed += PowerNodes.processNextNodeAbove(aCurrentNode, tNextNode, aConsumers, side, aMaxAmps - tAmpsUsed, aVoltage);
                    tConsumer = (ConsumerNode)aConsumers.getNode();
                    break;
                }
                if (tNextNode.mNodeValue != tTargetNodeValue) continue;
                tAmpsUsed += PowerNodes.processNodeInject(aCurrentNode, tConsumer, side, aMaxAmps - tAmpsUsed, aVoltage, true);
                tConsumer = (ConsumerNode)aConsumers.getNextNode();
                break;
            }
            if (aMaxAmps - tAmpsUsed <= 0) {
                return tAmpsUsed;
            }
            if (tLoopProtection++ <= 20) continue;
            throw new NullPointerException("infinite loop in powering nodes ");
        }
        return tAmpsUsed;
    }

    protected static int processNextNode(Node aCurrentNode, Node aNextNode, NodeList aConsumers, int aSide, int aMaxAmps, int aVoltage) {
        PowerNodePath tPath = (PowerNodePath)aCurrentNode.mNodePaths[aSide];
        PowerNodePath tSelfPath = (PowerNodePath)aCurrentNode.mSelfPath;
        int tVoltLoss = 0;
        if (tSelfPath != null) {
            tVoltLoss += tSelfPath.getLoss();
            tSelfPath.applyVoltage(aVoltage, false);
        }
        tPath.applyVoltage(aVoltage - tVoltLoss, true);
        int tAmps = PowerNodes.powerNode(aNextNode, aCurrentNode, aConsumers, aVoltage - (tVoltLoss += tPath.getLoss()), aMaxAmps);
        tPath.addAmps(tAmps);
        if (tSelfPath != null) {
            tSelfPath.addAmps(tAmps);
        }
        return tAmps;
    }

    protected static int processNextNodeAbove(Node aCurrentNode, Node aNextNode, NodeList aConsumers, int aSide, int aMaxAmps, int aVoltage) {
        PowerNodePath tPath = (PowerNodePath)aCurrentNode.mNodePaths[aSide];
        PowerNodePath tSelfPath = (PowerNodePath)aCurrentNode.mSelfPath;
        int tVoltLoss = 0;
        if (tSelfPath != null) {
            tVoltLoss += tSelfPath.getLoss();
            tSelfPath.applyVoltage(aVoltage, false);
        }
        tPath.applyVoltage(aVoltage - tVoltLoss, true);
        int tAmps = PowerNodes.powerNodeAbove(aNextNode, aCurrentNode, aConsumers, aVoltage - (tVoltLoss += tPath.getLoss()), aMaxAmps);
        tPath.addAmps(tAmps);
        if (tSelfPath != null) {
            tSelfPath.addAmps(tAmps);
        }
        return tAmps;
    }

    protected static int processNodeInject(Node aCurrentNode, ConsumerNode aConsumer, int aSide, int aMaxAmps, int aVoltage, boolean isUp) {
        PowerNodePath tPath = (PowerNodePath)aCurrentNode.mNodePaths[aSide];
        PowerNodePath tSelfPath = (PowerNodePath)aCurrentNode.mSelfPath;
        int tVoltLoss = 0;
        if (tSelfPath != null) {
            tVoltLoss += tSelfPath.getLoss();
            tSelfPath.applyVoltage(aVoltage, false);
        }
        tPath.applyVoltage(aVoltage - tVoltLoss, true);
        int tAmps = aConsumer.injectEnergy(aVoltage - (tVoltLoss += tPath.getLoss()), aMaxAmps);
        tPath.addAmps(tAmps);
        if (tSelfPath != null) {
            tSelfPath.addAmps(tAmps);
        }
        return tAmps;
    }
}

