/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.loaders.oreprocessing.ProcessingLog;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_PyrolyseOven
extends GT_MetaTileEntity_MultiBlockBase {
    private HeatingCoilLevel coilHeat;
    private static final int CASING_INDEX = 1090;

    public GT_MetaTileEntity_PyrolyseOven(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_PyrolyseOven(String aName) {
        super(aName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Coke Oven").addInfo("Controller block for the Pyrolyse Oven").addInfo("Industrial Charcoal producer").addInfo("Processing speed scales linearly with Coil tier:").addInfo("CuNi: 50%, FeAlCr: 100%, Ni4Cr: 150%, Fe50CW: 200%, etc.").addInfo("EU/t is not affected by Coil tier").addPollutionAmount(20 * this.getPollutionPerTick(null)).addSeparator().beginStructureBlock(5, 4, 5, true).addController("Front center").addCasingInfo("Pyrolyse Oven Casing", 60).addOtherStructurePart("Heating Coils", "Center 3x1x3 of the bottom layer").addEnergyHatch("Any bottom layer casing").addMaintenanceHatch("Any bottom layer casing").addMufflerHatch("Center 3x1x3 area in top layer").addInputBus("Center 3x1x3 area in top layer").addInputHatch("Center 3x1x3 area in top layer").addOutputBus("Any bottom layer casing").addOutputHatch("Any bottom layer casing").toolTipFinisher("Gregtech");
        if (Keyboard.isKeyDown((int)42)) {
            return tt.getStructureInformation();
        }
        return tt.getInformation();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][66]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "PyrolyseOven.png");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ItemStack[] tInputs = this.getCompactedInputs();
        FluidStack[] tFluids = this.getCompactedFluids();
        if (tInputs.length <= 0) {
            return false;
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier(tVoltage));
        GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
        if (tRecipe == null) {
            tRecipe = this.addRecipesDynamically(tInputs, tFluids, tTier);
        }
        if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) {
            return false;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(this.mMaxProgresstime * 2 / (1 + this.coilHeat.getTier()), 1);
        if (tRecipe.mOutputs.length > 0) {
            this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
        }
        if (tRecipe.mFluidOutputs.length > 0) {
            this.mOutputFluids = new FluidStack[]{tRecipe.getFluidOutput(0)};
        }
        this.updateSlots();
        return true;
    }

    private GT_Recipe addRecipesDynamically(ItemStack[] tInputs, FluidStack[] tFluids, int tTier) {
        if (tInputs.length > 1 || tInputs[0] != null && tInputs[0].func_77973_b() != GT_Utility.getIntegratedCircuit(0).func_77973_b()) {
            int oreId = OreDictionary.getOreID((String)"logWood");
            for (ItemStack is : tInputs) {
                for (int id : OreDictionary.getOreIDs((ItemStack)is)) {
                    if (oreId != id) continue;
                    ProcessingLog.addPyrolyeOvenRecipes(is);
                    return GT_Recipe.GT_Recipe_Map.sPyrolyseRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, tInputs);
                }
            }
        }
        return null;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        int casingMeta;
        Block casingBlock;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 2;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 2;
        if (Loader.isModLoaded((String)"dreamcraft")) {
            casingBlock = GameRegistry.findBlock((String)"dreamcraft", (String)"gt.blockcasingsNH");
            casingMeta = 2;
        } else {
            casingBlock = GregTech_API.sBlockCasings1;
            casingMeta = 0;
        }
        this.replaceDeprecatedCoils(aBaseMetaTileEntity);
        MutableBoolean firstCoil = new MutableBoolean(true);
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                for (int h = 0; h < 4; ++h) {
                    IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xDir + i, h, zDir + j);
                    if (!(i != -2 && i != 2 && j != -2 && j != 2 ? this.checkInnerBroken(xDir, zDir, i, h, j, aBaseMetaTileEntity, tTileEntity, casingBlock, casingMeta, firstCoil) : this.checkOuterBroken(xDir, zDir, i, h, j, aBaseMetaTileEntity, tTileEntity, casingBlock, casingMeta))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean checkInnerBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, IGregTechTileEntity tTileEntity, Block casingBlock, int casingMeta, MutableBoolean firstCoil) {
        if (b == 0) {
            return this.areCoilsBroken(xDir, zDir, a, b, c, aBaseMetaTileEntity, firstCoil);
        }
        if (b == 3) {
            return this.checkInnerCeilingBroken(xDir, zDir, a, b, c, aBaseMetaTileEntity, tTileEntity, casingBlock, casingMeta);
        }
        return !aBaseMetaTileEntity.getAirOffset(xDir + a, b, zDir + c);
    }

    private boolean checkOuterBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, IGregTechTileEntity tTileEntity, Block casingBlock, int casingMeta) {
        if (b == 0 && this.checkOuterFloorLoopControl(xDir, zDir, a, c, tTileEntity)) {
            return false;
        }
        if (aBaseMetaTileEntity.getBlockOffset(xDir + a, b, zDir + c) != casingBlock) {
            return true;
        }
        return aBaseMetaTileEntity.getMetaIDOffset(xDir + a, b, zDir + c) != casingMeta;
    }

    private boolean checkOuterFloorLoopControl(int xDir, int zDir, int a, int c, IGregTechTileEntity tTileEntity) {
        if (this.addMaintenanceToMachineList(tTileEntity, 1090)) {
            return true;
        }
        if (this.addOutputToMachineList(tTileEntity, 1090)) {
            return true;
        }
        if (this.addEnergyInputToMachineList(tTileEntity, 1090)) {
            return true;
        }
        return xDir + a == 0 && zDir + c == 0;
    }

    private boolean checkInnerCeilingBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, IGregTechTileEntity tTileEntity, Block casingBlock, int casingMeta) {
        if (this.addInputToMachineList(tTileEntity, 1090) || this.addMufflerToMachineList(tTileEntity, 1090)) {
            return false;
        }
        if (aBaseMetaTileEntity.getBlockOffset(xDir + a, b, zDir + c) != casingBlock) {
            return true;
        }
        return aBaseMetaTileEntity.getMetaIDOffset(xDir + a, b, zDir + c) != casingMeta;
    }

    private boolean areCoilsBroken(int xDir, int zDir, int a, int b, int c, IGregTechTileEntity aBaseMetaTileEntity, MutableBoolean firstCoil) {
        Block coil = aBaseMetaTileEntity.getBlockOffset(xDir + a, b, zDir + c);
        if (!(coil instanceof IHeatingCoil)) {
            return true;
        }
        byte metaID = aBaseMetaTileEntity.getMetaIDOffset(xDir + a, b, zDir + c);
        HeatingCoilLevel coilHeat = ((IHeatingCoil)coil).getCoilHeat(metaID);
        if (coilHeat == HeatingCoilLevel.None) {
            return true;
        }
        if (!firstCoil.isTrue()) {
            return coilHeat != this.coilHeat;
        }
        this.coilHeat = coilHeat;
        firstCoil.setFalse();
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 30;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_PyrolyseOven(this.mName);
    }

    private void replaceDeprecatedCoils(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ;
        int tX = aBaseMetaTileEntity.getXCoord() + xDir * 2;
        short tY = aBaseMetaTileEntity.getYCoord();
        int tZ = aBaseMetaTileEntity.getZCoord() + zDir * 2;
        for (int xPos = tX - 1; xPos <= tX + 1; ++xPos) {
            for (int zPos = tZ - 1; zPos <= tZ + 1; ++zPos) {
                if (aBaseMetaTileEntity.getBlock(xPos, tY, zPos) != GregTech_API.sBlockCasings1 || aBaseMetaTileEntity.getMetaID(xPos, tY, zPos) != 13) continue;
                aBaseMetaTileEntity.getWorld().func_147465_d(xPos, (int)tY, zPos, GregTech_API.sBlockCasings5, 1, 3);
            }
        }
    }
}

