/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.GT_Mod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;

class GT_RenderedGlowTexture
implements ITexture,
IColorModulationContainer {
    protected final IIconContainer mIconContainer;
    private final short[] mRGBa;

    GT_RenderedGlowTexture(IIconContainer aIcon, short[] aRGBa, boolean allowAlpha) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = GT_Mod.gregtechproxy.mRenderGlowTextures ? aIcon : Textures.BlockIcons.VOID;
        this.mRGBa = aRGBa;
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.field_147844_c) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.field_147863_w;
        aRenderer.field_147863_w = false;
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78376_a((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78376_a(255, 255, 255);
            aRenderer.func_147798_e(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_147863_w = enableAO;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.field_147844_c) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        aRenderer.field_152631_f = true;
        boolean enableAO = aRenderer.field_147863_w;
        aRenderer.field_147863_w = false;
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78376_a((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78376_a(255, 255, 255);
            aRenderer.func_147764_f(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
        aRenderer.field_147863_w = enableAO;
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.field_147844_c) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.field_147863_w;
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon aIcon = this.mIconContainer.getIcon();
        float minU = aIcon.func_94214_a((1.0 - aRenderer.field_147861_i) * 16.0);
        float maxU = aIcon.func_94214_a((1.0 - aRenderer.field_147859_h) * 16.0);
        float minV = aIcon.func_94207_b(aRenderer.field_147851_l * 16.0);
        float maxV = aIcon.func_94207_b(aRenderer.field_147853_m * 16.0);
        if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
            minU = 16.0f - aIcon.func_94212_f();
            maxU = 16.0f - aIcon.func_94209_e();
        }
        if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
            minV = aIcon.func_94206_g();
            maxV = aIcon.func_94210_h();
        }
        double minX = (double)aX + aRenderer.field_147859_h;
        double maxX = (double)aX + aRenderer.field_147861_i;
        double minY = (double)aY + aRenderer.field_147855_j;
        double minZ = (double)aZ + aRenderer.field_147851_l;
        double maxZ = (double)aZ + aRenderer.field_147853_m;
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78376_a((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        tessellator.func_78374_a(minX, minY, maxZ, (double)maxU, (double)maxV);
        tessellator.func_78374_a(minX, minY, minZ, (double)maxU, (double)minV);
        tessellator.func_78374_a(maxX, minY, minZ, (double)minU, (double)minV);
        tessellator.func_78374_a(maxX, minY, maxZ, (double)minU, (double)maxV);
        if (this.mIconContainer.getOverlayIcon() != null) {
            minU = aIcon.func_94214_a((1.0 - aRenderer.field_147861_i) * 16.0);
            maxU = aIcon.func_94214_a((1.0 - aRenderer.field_147859_h) * 16.0);
            minV = aIcon.func_94207_b(aRenderer.field_147851_l * 16.0);
            maxV = aIcon.func_94207_b(aRenderer.field_147853_m * 16.0);
            if (aRenderer.field_147859_h < 0.0 || aRenderer.field_147861_i > 1.0) {
                minU = 16.0f - aIcon.func_94212_f();
                maxU = 16.0f - aIcon.func_94209_e();
            }
            if (aRenderer.field_147851_l < 0.0 || aRenderer.field_147853_m > 1.0) {
                minV = aIcon.func_94206_g();
                maxV = aIcon.func_94210_h();
            }
            minX = (float)aX + (float)aRenderer.field_147859_h;
            maxX = (float)aX + (float)aRenderer.field_147861_i;
            minY = (float)aY + (float)aRenderer.field_147855_j;
            minZ = (float)aZ + (float)aRenderer.field_147851_l;
            maxZ = (float)aZ + (float)aRenderer.field_147853_m;
            Tessellator.field_78398_a.func_78376_a(255, 255, 255);
            tessellator.func_78374_a(minX, minY, maxZ, (double)maxU, (double)maxV);
            tessellator.func_78374_a(minX, minY, minZ, (double)maxU, (double)minV);
            tessellator.func_78374_a(maxX, minY, minZ, (double)minU, (double)minV);
            tessellator.func_78374_a(maxX, minY, maxZ, (double)minU, (double)maxV);
        }
        aRenderer.field_147863_w = enableAO;
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.field_147844_c) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.field_147863_w;
        aRenderer.field_147863_w = false;
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78376_a((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78376_a(255, 255, 255);
            aRenderer.func_147806_b(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_147863_w = enableAO;
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.field_147844_c) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.field_147863_w;
        aRenderer.field_147863_w = false;
        aRenderer.field_152631_f = true;
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78376_a((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.field_78398_a.func_78376_a(255, 255, 255);
            aRenderer.func_147761_c(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_152631_f = false;
        aRenderer.field_147863_w = enableAO;
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        if (aRenderer.field_147844_c) {
            return;
        }
        if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
            return;
        }
        boolean enableAO = aRenderer.field_147863_w;
        aRenderer.field_147863_w = false;
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        Tessellator.field_78398_a.func_78376_a((int)this.mRGBa[0], (int)this.mRGBa[1], (int)this.mRGBa[2]);
        aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getIcon());
        if (this.mIconContainer.getOverlayIcon() != null) {
            aRenderer.func_147734_d(aBlock, (double)aX, (double)aY, (double)aZ, this.mIconContainer.getOverlayIcon());
        }
        aRenderer.field_147863_w = enableAO;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }
}

