/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.GT_GuiTooltip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;

public class GT_GuiTooltipManager {
    private static final long DELAY = 5L;
    private int mouseStopped;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private final List<GT_GuiTooltip> tips = new ArrayList<GT_GuiTooltip>();

    public void addToolTip(GT_GuiTooltip tip) {
        if (!this.tips.contains(tip)) {
            this.tips.add(tip);
        }
    }

    public boolean removeToolTip(GT_GuiTooltip tip) {
        return this.tips.remove(tip);
    }

    public final void onTick(GT_IToolTipRenderer render, int mouseX, int mouseY) {
        this.mouseStopped = Math.abs(mouseX - this.lastMouseX) < 2 && Math.abs(mouseY - this.lastMouseY) < 2 ? Math.min(this.mouseStopped + 1, 50) : 0;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if ((long)this.mouseStopped > 5L) {
            mouseX -= render.getGuiLeft();
        }
        mouseY -= render.getGuiTop();
        for (GT_GuiTooltip tip : this.tips) {
            if (!tip.enabled || !tip.bounds.contains(mouseX, mouseY)) continue;
            tip.updateText();
            this.drawTooltip(tip, mouseX, mouseY, render);
            break;
        }
    }

    private void drawTooltip(GT_GuiTooltip tip, int mouseX, int mouseY, GT_IToolTipRenderer render) {
        List<String> text = tip.getToolTipText();
        if (text == null) {
            return;
        }
        if (mouseX > render.getGuiLeft() + render.getXSize() / 2) {
            int maxWidth = 0;
            for (String s : text) {
                int w = render.getFontRenderer().func_78256_a(s);
                if (w <= maxWidth) continue;
                maxWidth = w;
            }
            mouseX -= maxWidth + 18;
        }
        render.drawHoveringText(text, mouseX, mouseY, render.getFontRenderer());
    }

    public static interface GT_IToolTipRenderer {
        public int getGuiLeft();

        public int getGuiTop();

        public int getXSize();

        public FontRenderer getFontRenderer();

        public void drawHoveringText(List<String> var1, int var2, int var3, FontRenderer var4);
    }
}

