/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class Textures {

    public static enum ItemIcons implements IIconContainer,
    Runnable
    {
        VOID,
        RENDERING_ERROR,
        WRENCH,
        MORTAR,
        CROWBAR,
        JACKHAMMER,
        WIRE_CUTTER,
        KNIFE,
        BUTCHERYKNIFE,
        SICKLE,
        SCOOP,
        GRAFTER,
        PLUNGER,
        ROLLING_PIN,
        HANDLE_SWORD,
        HANDLE_FILE,
        HANDLE_SAW,
        HANDLE_SCREWDRIVER,
        HANDLE_BUZZSAW,
        HANDLE_ELECTRIC_SCREWDRIVER,
        HANDLE_SOLDERING,
        POWER_UNIT_LV,
        POWER_UNIT_MV,
        POWER_UNIT_HV,
        DURABILITY_BAR_0,
        DURABILITY_BAR_1,
        DURABILITY_BAR_2,
        DURABILITY_BAR_3,
        DURABILITY_BAR_4,
        DURABILITY_BAR_5,
        DURABILITY_BAR_6,
        DURABILITY_BAR_7,
        DURABILITY_BAR_8,
        ENERGY_BAR_0,
        ENERGY_BAR_1,
        ENERGY_BAR_2,
        ENERGY_BAR_3,
        ENERGY_BAR_4,
        ENERGY_BAR_5,
        ENERGY_BAR_6,
        ENERGY_BAR_7,
        ENERGY_BAR_8,
        TURBINE,
        TURBINE_SMALL,
        TURBINE_LARGE,
        TURBINE_HUGE;

        public static final IIconContainer[] DURABILITY_BAR;
        public static final IIconContainer[] ENERGY_BAR;
        public static final ITexture[] ERROR_RENDERING;
        protected IIcon mIcon;
        protected IIcon mOverlay;

        private ItemIcons() {
            GregTech_API.sGTItemIconload.add(this);
        }

        @Override
        public IIcon getIcon() {
            return this.mIcon;
        }

        @Override
        public IIcon getOverlayIcon() {
            return this.mOverlay;
        }

        @Override
        public ResourceLocation getTextureFile() {
            return TextureMap.field_110576_c;
        }

        @Override
        public void run() {
            this.mIcon = GregTech_API.sItemIcons.func_94245_a("gregtech:iconsets/" + this);
            this.mOverlay = GregTech_API.sItemIcons.func_94245_a("gregtech:iconsets/" + this + "_OVERLAY");
        }

        static {
            DURABILITY_BAR = new IIconContainer[]{DURABILITY_BAR_0, DURABILITY_BAR_1, DURABILITY_BAR_2, DURABILITY_BAR_3, DURABILITY_BAR_4, DURABILITY_BAR_5, DURABILITY_BAR_6, DURABILITY_BAR_7, DURABILITY_BAR_8};
            ENERGY_BAR = new IIconContainer[]{ENERGY_BAR_0, ENERGY_BAR_1, ENERGY_BAR_2, ENERGY_BAR_3, ENERGY_BAR_4, ENERGY_BAR_5, ENERGY_BAR_6, ENERGY_BAR_7, ENERGY_BAR_8};
            ERROR_RENDERING = new ITexture[]{TextureFactory.of(RENDERING_ERROR)};
        }

        public static class CustomIcon
        implements IIconContainer,
        Runnable {
            protected IIcon mIcon;
            protected IIcon mOverlay;
            protected String mIconName;

            public CustomIcon(String aIconName) {
                this.mIconName = aIconName;
                GregTech_API.sGTItemIconload.add(this);
            }

            @Override
            public IIcon getIcon() {
                return this.mIcon;
            }

            @Override
            public IIcon getOverlayIcon() {
                return this.mOverlay;
            }

            @Override
            public ResourceLocation getTextureFile() {
                return TextureMap.field_110576_c;
            }

            @Override
            public void run() {
                this.mIcon = GregTech_API.sItemIcons.func_94245_a("gregtech:" + this.mIconName);
                this.mOverlay = GregTech_API.sItemIcons.func_94245_a("gregtech:" + this.mIconName + "_OVERLAY");
            }
        }
    }

    public static enum BlockIcons implements IIconContainer,
    Runnable
    {
        MACHINE_UEV_SIDE,
        MACHINE_UIV_SIDE,
        MACHINE_UMV_SIDE,
        MACHINE_UXV_SIDE,
        MACHINE_OPV_SIDE,
        MACHINE_MAXV_SIDE,
        MACHINE_UEV_TOP,
        MACHINE_UIV_TOP,
        MACHINE_UMV_TOP,
        MACHINE_UXV_TOP,
        MACHINE_OPV_TOP,
        MACHINE_MAXV_TOP,
        MACHINE_UEV_BOTTOM,
        MACHINE_UIV_BOTTOM,
        MACHINE_UMV_BOTTOM,
        MACHINE_UXV_BOTTOM,
        MACHINE_OPV_BOTTOM,
        MACHINE_MAXV_BOTTOM,
        OVERLAY_SCHEST,
        OVERLAY_SCHEST_GLOW,
        OVERLAY_STANK,
        OVERLAY_STANK_GLOW,
        OVERLAY_PIPELINE_FLUID_BACK,
        OVERLAY_PIPELINE_FLUID_FRONT,
        OVERLAY_PIPELINE_FLUID_SIDE,
        OVERLAY_PIPELINE_FLUID_SIDE_GLOW,
        OVERLAY_PIPELINE_ITEM_BACK,
        OVERLAY_PIPELINE_ITEM_FRONT,
        OVERLAY_PIPELINE_ITEM_SIDE,
        OVERLAY_PIPELINE_ITEM_SIDE_GLOW,
        LONG_DISTANCE_PIPE_FLUID,
        LONG_DISTANCE_PIPE_ITEM,
        HIDDEN_FACE,
        MACHINE_CASING_TANK_1,
        MACHINE_CASING_TANK_2,
        MACHINE_CASING_TANK_3,
        MACHINE_CASING_TANK_4,
        MACHINE_CASING_TANK_5,
        MACHINE_CASING_TANK_6,
        MACHINE_CASING_TANK_7,
        MACHINE_CASING_TANK_8,
        MACHINE_CASING_TANK_9,
        MACHINE_CASING_TANK_10,
        MACHINE_CASING_TANK_11,
        MACHINE_CASING_TANK_12,
        MACHINE_CASING_TANK_13,
        MACHINE_CASING_TANK_14,
        MACHINE_CASING_TANK_15,
        MACHINE_CASING_TANK_0,
        BLOCK_STEELEAF,
        BLOCK_ICHORIUM,
        BLOCK_FIRESTONE,
        BLOCK_SHADOW,
        OVERLAY_ENERGY_IN_POWER,
        OVERLAY_ENERGY_OUT_POWER,
        OVERLAY_AUTOMAINTENANCE,
        OVERLAY_AUTOMAINTENANCE_GLOW,
        OVERLAY_AUTOMAINTENANCE_IDLE,
        OVERLAY_AUTOMAINTENANCE_IDLE_GLOW,
        VOID,
        RENDERING_ERROR,
        PIPE_RESTRICTOR,
        INSULATION_FULL,
        INSULATION_TINY,
        INSULATION_SMALL,
        INSULATION_MEDIUM,
        INSULATION_MEDIUM_PLUS,
        INSULATION_LARGE,
        INSULATION_HUGE,
        CFOAM_FRESH,
        CFOAM_HARDENED,
        SOLARPANEL,
        SOLARPANEL_8V,
        SOLARPANEL_LV,
        SOLARPANEL_MV,
        SOLARPANEL_HV,
        SOLARPANEL_EV,
        SOLARPANEL_IV,
        SOLARPANEL_LuV,
        SOLARPANEL_ZPM,
        SOLARPANEL_UV,
        SOLARPANEL_UHV,
        SOLARPANEL_UEV,
        SOLARPANEL_UIV,
        VENT_NORMAL,
        VENT_ADVANCED,
        COVER_WOOD_PLATE,
        ARROW_UP,
        ARROW_UP_GLOW,
        ARROW_DOWN,
        ARROW_DOWN_GLOW,
        ARROW_LEFT,
        ARROW_LEFT_GLOW,
        ARROW_RIGHT,
        ARROW_RIGHT_GLOW,
        AUTOMATION_FILTER,
        AUTOMATION_FILTER_GLOW,
        AUTOMATION_TYPEFILTER,
        AUTOMATION_TYPEFILTER_GLOW,
        AUTOMATION_CHESTBUFFER,
        AUTOMATION_CHESTBUFFER_GLOW,
        AUTOMATION_SUPERBUFFER,
        AUTOMATION_SUPERBUFFER_GLOW,
        AUTOMATION_REGULATOR,
        AUTOMATION_REGULATOR_GLOW,
        AUTOMATION_ITEMDISTRIBUTOR,
        AUTOMATION_ITEMDISTRIBUTOR_GLOW,
        CONCRETE_LIGHT_STONE,
        CONCRETE_LIGHT_COBBLE,
        CONCRETE_LIGHT_COBBLE_MOSSY,
        CONCRETE_LIGHT_BRICKS,
        CONCRETE_LIGHT_BRICKS_CRACKED,
        CONCRETE_LIGHT_BRICKS_MOSSY,
        CONCRETE_LIGHT_BRICKS_CHISELED,
        CONCRETE_LIGHT_SMOOTH,
        CONCRETE_DARK_STONE,
        CONCRETE_DARK_COBBLE,
        CONCRETE_DARK_COBBLE_MOSSY,
        CONCRETE_DARK_BRICKS,
        CONCRETE_DARK_BRICKS_CRACKED,
        CONCRETE_DARK_BRICKS_MOSSY,
        CONCRETE_DARK_BRICKS_CHISELED,
        CONCRETE_DARK_SMOOTH,
        GRANITE_BLACK_STONE,
        GRANITE_BLACK_COBBLE,
        GRANITE_BLACK_COBBLE_MOSSY,
        GRANITE_BLACK_BRICKS,
        GRANITE_BLACK_BRICKS_CRACKED,
        GRANITE_BLACK_BRICKS_MOSSY,
        GRANITE_BLACK_BRICKS_CHISELED,
        GRANITE_BLACK_SMOOTH,
        GRANITE_RED_STONE,
        GRANITE_RED_COBBLE,
        GRANITE_RED_COBBLE_MOSSY,
        GRANITE_RED_BRICKS,
        GRANITE_RED_BRICKS_CRACKED,
        GRANITE_RED_BRICKS_MOSSY,
        GRANITE_RED_BRICKS_CHISELED,
        GRANITE_RED_SMOOTH,
        MACHINE_BRONZEBRICKS_TOP,
        MACHINE_BRONZEBRICKS_SIDE,
        MACHINE_BRONZEBRICKS_BOTTOM,
        MACHINE_STEELBRICKS_TOP,
        MACHINE_STEELBRICKS_SIDE,
        MACHINE_STEELBRICKS_BOTTOM,
        MACHINE_BRONZE_TOP,
        MACHINE_BRONZE_SIDE,
        MACHINE_BRONZE_BOTTOM,
        MACHINE_STEEL_TOP,
        MACHINE_STEEL_SIDE,
        MACHINE_STEEL_BOTTOM,
        MACHINE_8V_TOP,
        MACHINE_8V_SIDE,
        MACHINE_8V_BOTTOM,
        MACHINE_LV_TOP,
        MACHINE_LV_SIDE,
        MACHINE_LV_BOTTOM,
        MACHINE_MV_TOP,
        MACHINE_MV_SIDE,
        MACHINE_MV_BOTTOM,
        MACHINE_HV_TOP,
        MACHINE_HV_SIDE,
        MACHINE_HV_BOTTOM,
        MACHINE_EV_TOP,
        MACHINE_EV_SIDE,
        MACHINE_EV_BOTTOM,
        MACHINE_IV_TOP,
        MACHINE_IV_SIDE,
        MACHINE_IV_BOTTOM,
        MACHINE_LuV_TOP,
        MACHINE_LuV_SIDE,
        MACHINE_LuV_BOTTOM,
        MACHINE_ZPM_TOP,
        MACHINE_ZPM_SIDE,
        MACHINE_ZPM_BOTTOM,
        MACHINE_UV_TOP,
        MACHINE_UV_SIDE,
        MACHINE_UV_BOTTOM,
        MACHINE_MAX_TOP,
        MACHINE_MAX_SIDE,
        MACHINE_MAX_BOTTOM,
        MACHINE_BRONZEPLATEDBRICKS,
        MACHINE_HEATPROOFCASING,
        MACHINE_COIL_SUPERCONDUCTOR,
        MACHINE_BRONZEBLASTFURNACE,
        MACHINE_BRONZEBLASTFURNACE_ACTIVE,
        MACHINE_BRONZEBLASTFURNACE_ACTIVE_GLOW,
        MACHINE_CASING_ROBUST_TUNGSTENSTEEL,
        MACHINE_CASING_CLEAN_STAINLESSSTEEL,
        MACHINE_CASING_STABLE_TITANIUM,
        MACHINE_CASING_MINING_OSMIRIDIUM,
        MACHINE_CASING_MINING_NEUTRONIUM,
        MACHINE_CASING_MINING_BLACKPLUTONIUM,
        MACHINE_CASING_FIREBOX_TITANIUM,
        MACHINE_CASING_FUSION_COIL,
        MACHINE_CASING_FUSION,
        MACHINE_CASING_FUSION_GLASS,
        MACHINE_CASING_FUSION_GLASS_YELLOW,
        MACHINE_CASING_FUSION_GLASS_YELLOW_GLOW,
        MACHINE_CASING_FUSION_2,
        MACHINE_CASING_MAGIC,
        MACHINE_CASING_MAGIC_GLOW,
        MACHINE_CASING_MAGIC_ACTIVE,
        MACHINE_CASING_MAGIC_ACTIVE_GLOW,
        MACHINE_CASING_MAGIC_FRONT,
        MACHINE_CASING_MAGIC_FRONT_GLOW,
        MACHINE_CASING_MAGIC_FRONT_ACTIVE,
        MACHINE_CASING_MAGIC_FRONT_ACTIVE_GLOW,
        MACHINE_CASING_DRAGONEGG,
        MACHINE_CASING_DRAGONEGG_GLOW,
        MACHINE_CASING_SOLID_STEEL,
        MACHINE_CASING_FROST_PROOF,
        MACHINE_CASING_PUMP,
        MACHINE_CASING_MOTOR,
        MACHINE_CASING_PIPE_BRONZE,
        MACHINE_CASING_PIPE_STEEL,
        MACHINE_CASING_PIPE_TITANIUM,
        MACHINE_CASING_PIPE_TUNGSTENSTEEL,
        MACHINE_CASING_PIPE_POLYTETRAFLUOROETHYLENE,
        MACHINE_CASING_GEARBOX_BRONZE,
        MACHINE_CASING_GEARBOX_STEEL,
        MACHINE_CASING_GEARBOX_TITANIUM,
        MACHINE_CASING_GEARBOX_TUNGSTENSTEEL,
        MACHINE_CASING_DATA_DRIVE,
        MACHINE_CASING_CONTAINMENT_FIELD,
        MACHINE_CASING_ASSEMBLER,
        MACHINE_CASING_PROCESSOR,
        MACHINE_CASING_STRIPES_A,
        MACHINE_CASING_STRIPES_B,
        MACHINE_CASING_RADIOACTIVEHAZARD,
        MACHINE_CASING_BIOHAZARD,
        MACHINE_CASING_EXPLOSIONHAZARD,
        MACHINE_CASING_FIREHAZARD,
        MACHINE_CASING_ACIDHAZARD,
        MACHINE_CASING_MAGICHAZARD,
        MACHINE_CASING_FROSTHAZARD,
        MACHINE_CASING_NOISEHAZARD,
        MACHINE_CASING_GRATE,
        MACHINE_CASING_VENT,
        MACHINE_CASING_RADIATIONPROOF,
        MACHINE_CASING_FIREBOX_BRONZE,
        MACHINE_CASING_FIREBOX_STEEL,
        MACHINE_CASING_FIREBOX_TUNGSTENSTEEL,
        MACHINE_CASING_ENGINE_INTAKE,
        MACHINE_CASING_EXTREME_ENGINE_INTAKE,
        MACHINE_CASING_CHEMICALLY_INERT,
        MACHINE_COIL_CUPRONICKEL,
        MACHINE_CASING_DENSEBRICKS,
        MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE,
        MACHINE_CASING_BRICKEDBLASTFURNACE_ACTIVE_GLOW,
        MACHINE_CASING_BRICKEDBLASTFURNACE_INACTIVE,
        MACHINE_COIL_KANTHAL,
        MACHINE_COIL_NICHROME,
        MACHINE_COIL_TUNGSTENSTEEL,
        MACHINE_COIL_HSSG,
        MACHINE_COIL_NAQUADAH,
        MACHINE_COIL_NAQUADAHALLOY,
        MACHINE_COIL_ELECTRUMFLUX,
        MACHINE_COIL_AWAKENEDDRACONIUM,
        MACHINE_COIL_HSSS,
        MACHINE_COIL_TRINIUM,
        BOILER_SOLAR,
        BOILER_FRONT,
        BOILER_FRONT_ACTIVE,
        BOILER_FRONT_ACTIVE_GLOW,
        BOILER_LAVA_FRONT,
        BOILER_LAVA_FRONT_ACTIVE,
        BOILER_LAVA_FRONT_ACTIVE_GLOW,
        NAQUADAH_REACTOR_SOLID_BACK,
        NAQUADAH_REACTOR_SOLID_FRONT,
        NAQUADAH_REACTOR_SOLID_SIDE,
        NAQUADAH_REACTOR_SOLID_BOTTOM,
        NAQUADAH_REACTOR_SOLID_TOP,
        NAQUADAH_REACTOR_SOLID_BACK_ACTIVE,
        NAQUADAH_REACTOR_SOLID_BACK_ACTIVE_GLOW,
        NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE,
        NAQUADAH_REACTOR_SOLID_FRONT_ACTIVE_GLOW,
        NAQUADAH_REACTOR_SOLID_SIDE_ACTIVE,
        NAQUADAH_REACTOR_SOLID_SIDE_ACTIVE_GLOW,
        NAQUADAH_REACTOR_SOLID_BOTTOM_ACTIVE,
        NAQUADAH_REACTOR_SOLID_BOTTOM_ACTIVE_GLOW,
        NAQUADAH_REACTOR_SOLID_TOP_ACTIVE,
        NAQUADAH_REACTOR_SOLID_TOP_ACTIVE_GLOW,
        NAQUADAH_REACTOR_FLUID_BACK,
        NAQUADAH_REACTOR_FLUID_FRONT,
        NAQUADAH_REACTOR_FLUID_SIDE,
        NAQUADAH_REACTOR_FLUID_BOTTOM,
        NAQUADAH_REACTOR_FLUID_TOP,
        NAQUADAH_REACTOR_FLUID_BACK_ACTIVE,
        NAQUADAH_REACTOR_FLUID_BACK_ACTIVE_GLOW,
        NAQUADAH_REACTOR_FLUID_FRONT_ACTIVE,
        NAQUADAH_REACTOR_FLUID_FRONT_ACTIVE_GLOW,
        NAQUADAH_REACTOR_FLUID_SIDE_ACTIVE,
        NAQUADAH_REACTOR_FLUID_SIDE_ACTIVE_GLOW,
        NAQUADAH_REACTOR_FLUID_BOTTOM_ACTIVE,
        NAQUADAH_REACTOR_FLUID_BOTTOM_ACTIVE_GLOW,
        NAQUADAH_REACTOR_FLUID_TOP_ACTIVE,
        NAQUADAH_REACTOR_FLUID_TOP_ACTIVE_GLOW,
        DIESEL_GENERATOR_BACK,
        DIESEL_GENERATOR_FRONT,
        DIESEL_GENERATOR_SIDE,
        DIESEL_GENERATOR_BOTTOM,
        DIESEL_GENERATOR_TOP,
        DIESEL_GENERATOR_BACK_ACTIVE,
        DIESEL_GENERATOR_FRONT_ACTIVE,
        DIESEL_GENERATOR_SIDE_ACTIVE,
        DIESEL_GENERATOR_BOTTOM_ACTIVE,
        DIESEL_GENERATOR_TOP_ACTIVE,
        GAS_TURBINE_BACK,
        GAS_TURBINE_FRONT,
        GAS_TURBINE_SIDE,
        GAS_TURBINE_BOTTOM,
        GAS_TURBINE_TOP,
        GAS_TURBINE_BACK_ACTIVE,
        GAS_TURBINE_FRONT_ACTIVE,
        GAS_TURBINE_SIDE_ACTIVE,
        GAS_TURBINE_BOTTOM_ACTIVE,
        GAS_TURBINE_TOP_ACTIVE,
        STEAM_TURBINE_BACK,
        STEAM_TURBINE_FRONT,
        STEAM_TURBINE_SIDE,
        STEAM_TURBINE_BOTTOM,
        STEAM_TURBINE_TOP,
        STEAM_TURBINE_BACK_ACTIVE,
        STEAM_TURBINE_FRONT_ACTIVE,
        STEAM_TURBINE_SIDE_ACTIVE,
        STEAM_TURBINE_BOTTOM_ACTIVE,
        STEAM_TURBINE_TOP_ACTIVE,
        BLOCK_BRONZEPREIN,
        BLOCK_STEELPREIN,
        BLOCK_TITANIUMPREIN,
        BLOCK_NAQUADAHPREIN,
        BLOCK_NEUTRONIUMPREIN,
        BLOCK_DEEP_DARK_RAW,
        BLOCK_IRREIN,
        BLOCK_PLASCRETE,
        BLOCK_TSREIN,
        OVERLAY_LOCKER,
        OVERLAY_LOCKER_000,
        OVERLAY_LOCKER_001,
        OVERLAY_LOCKER_002,
        OVERLAY_LOCKER_003,
        OVERLAY_LOCKER_004,
        OVERLAY_LOCKER_005,
        OVERLAY_LOCKER_006,
        OVERLAY_LOCKER_007,
        OVERLAY_LOCKER_008,
        OVERLAY_LOCKER_009,
        OVERLAY_LOCKER_010,
        OVERLAY_LOCKER_011,
        OVERLAY_LOCKER_012,
        OVERLAY_LOCKER_013,
        OVERLAY_LENS,
        OVERLAY_PIPE,
        OVERLAY_PIPE_IN,
        OVERLAY_PIPE_OUT,
        OVERLAY_MUFFLER,
        OVERLAY_CONTROLLER,
        OVERLAY_ACTIVITYDETECTOR,
        OVERLAY_ACTIVITYDETECTOR_GLOW,
        OVERLAY_ENERGYDETECTOR,
        OVERLAY_FLUIDDETECTOR,
        OVERLAY_ITEMDETECTOR,
        OVERLAY_FUSION1,
        OVERLAY_FUSION1_GLOW,
        OVERLAY_FUSION2,
        OVERLAY_FUSION2_GLOW,
        OVERLAY_FUSION3,
        OVERLAY_FUSION3_GLOW,
        OVERLAY_SCREEN,
        OVERLAY_SCREEN_GLOW,
        OVERLAY_QTANK,
        OVERLAY_QTANK_GLOW,
        OVERLAY_QCHEST,
        OVERLAY_QCHEST_GLOW,
        OVERLAY_SHUTTER,
        OVERLAY_CLOSET,
        OVERLAY_DUCTTAPE,
        OVERLAY_MAINTENANCE,
        OVERLAY_DATA_ACCESS,
        OVERLAY_CONVEYOR,
        OVERLAY_PUMP,
        OVERLAY_VALVE,
        OVERLAY_ARM,
        OVERLAY_DRAIN,
        OVERLAY_CRAFTING,
        OVERLAY_ENERGY_IN,
        OVERLAY_ENERGY_OUT,
        OVERLAY_ENERGY_IN_MULTI,
        OVERLAY_ENERGY_OUT_MULTI,
        OVERLAY_FRONT_LARGE_BOILER,
        OVERLAY_FRONT_LARGE_BOILER_GLOW,
        OVERLAY_FRONT_LARGE_BOILER_ACTIVE,
        OVERLAY_FRONT_LARGE_BOILER_ACTIVE_GLOW,
        OVERLAY_FRONT_VACUUM_FREEZER,
        OVERLAY_FRONT_VACUUM_FREEZER_GLOW,
        OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE,
        OVERLAY_FRONT_VACUUM_FREEZER_ACTIVE_GLOW,
        OVERLAY_FRONT_MULTI_SMELTER,
        OVERLAY_FRONT_MULTI_SMELTER_GLOW,
        OVERLAY_FRONT_MULTI_SMELTER_ACTIVE,
        OVERLAY_FRONT_MULTI_SMELTER_ACTIVE_GLOW,
        OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE,
        OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_GLOW,
        OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE,
        OVERLAY_FRONT_ELECTRIC_BLAST_FURNACE_ACTIVE_GLOW,
        OVERLAY_FRONT_IMPLOSION_COMPRESSOR,
        OVERLAY_FRONT_IMPLOSION_COMPRESSOR_GLOW,
        OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE,
        OVERLAY_FRONT_IMPLOSION_COMPRESSOR_ACTIVE_GLOW,
        OVERLAY_TOP_POTIONBREWER,
        OVERLAY_TOP_REPLICATOR,
        OVERLAY_TOP_MASSFAB,
        OVERLAY_TOP_STEAM_HAMMER,
        OVERLAY_TOP_STEAM_FURNACE,
        OVERLAY_TOP_STEAM_ALLOY_SMELTER,
        OVERLAY_TOP_STEAM_MACERATOR,
        OVERLAY_TOP_STEAM_COMPRESSOR,
        OVERLAY_TOP_STEAM_EXTRACTOR,
        OVERLAY_TOP_DISASSEMBLER,
        OVERLAY_TOP_BOXINATOR,
        OVERLAY_TOP_ROCK_BREAKER,
        OVERLAY_TOP_SCANNER,
        OVERLAY_FRONT_POTIONBREWER,
        OVERLAY_FRONT_REPLICATOR,
        OVERLAY_FRONT_MASSFAB,
        OVERLAY_FRONT_STEAM_HAMMER,
        OVERLAY_FRONT_STEAM_HAMMER_ACTIVE,
        OVERLAY_FRONT_STEAM_HAMMER_ACTIVE_GLOW,
        OVERLAY_FRONT_STEAM_FURNACE,
        OVERLAY_FRONT_STEAM_ALLOY_SMELTER,
        OVERLAY_FRONT_STEAM_MACERATOR,
        OVERLAY_FRONT_STEAM_MACERATOR_ACTIVE,
        OVERLAY_FRONT_STEAM_MACERATOR_ACTIVE_GLOW,
        OVERLAY_FRONT_STEAM_COMPRESSOR,
        OVERLAY_FRONT_STEAM_EXTRACTOR,
        OVERLAY_FRONT_DISASSEMBLER,
        OVERLAY_FRONT_DISASSEMBLER_GLOW,
        OVERLAY_FRONT_DISASSEMBLER_ACTIVE,
        OVERLAY_FRONT_DISASSEMBLER_ACTIVE_GLOW,
        OVERLAY_FRONT_BOXINATOR,
        OVERLAY_FRONT_ROCK_BREAKER,
        OVERLAY_FRONT_SCANNER,
        OVERLAY_FRONT_SCANNER_GLOW,
        OVERLAY_BOTTOM_POTIONBREWER,
        OVERLAY_BOTTOM_REPLICATOR,
        OVERLAY_BOTTOM_MASSFAB,
        OVERLAY_BOTTOM_STEAM_HAMMER,
        OVERLAY_BOTTOM_STEAM_FURNACE,
        OVERLAY_BOTTOM_STEAM_ALLOY_SMELTER,
        OVERLAY_BOTTOM_STEAM_MACERATOR,
        OVERLAY_BOTTOM_STEAM_COMPRESSOR,
        OVERLAY_BOTTOM_STEAM_EXTRACTOR,
        OVERLAY_BOTTOM_DISASSEMBLER,
        OVERLAY_BOTTOM_BOXINATOR,
        OVERLAY_BOTTOM_ROCK_BREAKER,
        OVERLAY_BOTTOM_SCANNER,
        OVERLAY_SIDE_POTIONBREWER,
        OVERLAY_SIDE_REPLICATOR,
        OVERLAY_SIDE_MASSFAB,
        OVERLAY_SIDE_STEAM_HAMMER,
        OVERLAY_SIDE_STEAM_FURNACE,
        OVERLAY_SIDE_STEAM_ALLOY_SMELTER,
        OVERLAY_SIDE_STEAM_MACERATOR,
        OVERLAY_SIDE_STEAM_COMPRESSOR,
        OVERLAY_SIDE_STEAM_EXTRACTOR,
        OVERLAY_SIDE_DISASSEMBLER,
        OVERLAY_SIDE_BOXINATOR,
        OVERLAY_SIDE_ROCK_BREAKER,
        OVERLAY_SIDE_SCANNER,
        OVERLAY_TOP_POTIONBREWER_ACTIVE,
        OVERLAY_TOP_REPLICATOR_ACTIVE,
        OVERLAY_TOP_MASSFAB_ACTIVE,
        OVERLAY_TOP_STEAM_HAMMER_ACTIVE,
        OVERLAY_TOP_STEAM_FURNACE_ACTIVE,
        OVERLAY_TOP_STEAM_ALLOY_SMELTER_ACTIVE,
        OVERLAY_TOP_STEAM_MACERATOR_ACTIVE,
        OVERLAY_TOP_STEAM_MACERATOR_ACTIVE_GLOW,
        OVERLAY_TOP_STEAM_COMPRESSOR_ACTIVE,
        OVERLAY_TOP_STEAM_EXTRACTOR_ACTIVE,
        OVERLAY_TOP_DISASSEMBLER_ACTIVE,
        OVERLAY_TOP_DISASSEMBLER_ACTIVE_GLOW,
        OVERLAY_TOP_BOXINATOR_ACTIVE,
        OVERLAY_TOP_ROCK_BREAKER_ACTIVE,
        OVERLAY_TOP_SCANNER_ACTIVE,
        OVERLAY_FRONT_POTIONBREWER_ACTIVE,
        OVERLAY_FRONT_POTIONBREWER_ACTIVE_GLOW,
        OVERLAY_FRONT_REPLICATOR_ACTIVE,
        OVERLAY_FRONT_REPLICATOR_ACTIVE_GLOW,
        OVERLAY_FRONT_MASSFAB_ACTIVE,
        OVERLAY_FRONT_MASSFAB_ACTIVE_GLOW,
        OVERLAY_FRONT_STEAM_FURNACE_ACTIVE,
        OVERLAY_FRONT_STEAM_FURNACE_ACTIVE_GLOW,
        OVERLAY_FRONT_STEAM_ALLOY_SMELTER_ACTIVE,
        OVERLAY_FRONT_STEAM_ALLOY_SMELTER_ACTIVE_GLOW,
        OVERLAY_FRONT_STEAM_COMPRESSOR_ACTIVE,
        OVERLAY_FRONT_STEAM_COMPRESSOR_ACTIVE_GLOW,
        OVERLAY_FRONT_STEAM_EXTRACTOR_ACTIVE,
        OVERLAY_FRONT_STEAM_EXTRACTOR_ACTIVE_GLOW,
        OVERLAY_FRONT_BOXINATOR_ACTIVE,
        OVERLAY_FRONT_BOXINATOR_ACTIVE_GLOW,
        OVERLAY_FRONT_ROCK_BREAKER_ACTIVE,
        OVERLAY_FRONT_ROCK_BREAKER_ACTIVE_GLOW,
        OVERLAY_FRONT_SCANNER_ACTIVE,
        OVERLAY_FRONT_SCANNER_ACTIVE_GLOW,
        OVERLAY_BOTTOM_POTIONBREWER_ACTIVE,
        OVERLAY_BOTTOM_REPLICATOR_ACTIVE,
        OVERLAY_BOTTOM_MASSFAB_ACTIVE,
        OVERLAY_BOTTOM_STEAM_HAMMER_ACTIVE,
        OVERLAY_BOTTOM_STEAM_FURNACE_ACTIVE,
        OVERLAY_BOTTOM_STEAM_ALLOY_SMELTER_ACTIVE,
        OVERLAY_BOTTOM_STEAM_MACERATOR_ACTIVE,
        OVERLAY_BOTTOM_STEAM_COMPRESSOR_ACTIVE,
        OVERLAY_BOTTOM_STEAM_EXTRACTOR_ACTIVE,
        OVERLAY_BOTTOM_DISASSEMBLER_ACTIVE,
        OVERLAY_BOTTOM_BOXINATOR_ACTIVE,
        OVERLAY_BOTTOM_ROCK_BREAKER_ACTIVE,
        OVERLAY_BOTTOM_SCANNER_ACTIVE,
        OVERLAY_SIDE_POTIONBREWER_ACTIVE,
        OVERLAY_SIDE_REPLICATOR_ACTIVE,
        OVERLAY_SIDE_MASSFAB_ACTIVE,
        OVERLAY_SIDE_STEAM_HAMMER_ACTIVE,
        OVERLAY_SIDE_STEAM_FURNACE_ACTIVE,
        OVERLAY_SIDE_STEAM_ALLOY_SMELTER_ACTIVE,
        OVERLAY_SIDE_STEAM_MACERATOR_ACTIVE,
        OVERLAY_SIDE_STEAM_COMPRESSOR_ACTIVE,
        OVERLAY_SIDE_STEAM_EXTRACTOR_ACTIVE,
        OVERLAY_SIDE_DISASSEMBLER_ACTIVE,
        OVERLAY_SIDE_BOXINATOR_ACTIVE,
        OVERLAY_SIDE_ROCK_BREAKER_ACTIVE,
        OVERLAY_SIDE_SCANNER_ACTIVE,
        OVERLAY_ADV_PUMP,
        OVERLAY_TELEPORTER,
        OVERLAY_TELEPORTER_GLOW,
        OVERLAY_TELEPORTER_ACTIVE,
        OVERLAY_TELEPORTER_ACTIVE_GLOW,
        OVERLAY_TELEPORTER_SIDES,
        OVERLAY_TELEPORTER_SIDES_GLOW,
        FUSIONI_1,
        FUSIONI_2,
        FUSIONI_3,
        FUSIONI_4,
        FUSIONI_5,
        FUSIONI_6,
        FUSIONI_7,
        FUSIONI_8,
        FUSIONI_9,
        FUSIONI_10,
        FUSIONI_11,
        FUSIONI_12,
        FUSIONII_1,
        FUSIONII_2,
        FUSIONII_3,
        FUSIONII_4,
        FUSIONII_5,
        FUSIONII_6,
        FUSIONII_7,
        FUSIONII_8,
        FUSIONII_9,
        FUSIONII_10,
        FUSIONII_11,
        FUSIONII_12,
        LARGETURBINE_ST1,
        LARGETURBINE_ST2,
        LARGETURBINE_ST3,
        LARGETURBINE_ST4,
        LARGETURBINE_ST5,
        LARGETURBINE_ST6,
        LARGETURBINE_ST7,
        LARGETURBINE_ST8,
        LARGETURBINE_ST9,
        LARGETURBINE_ST_ACTIVE1,
        LARGETURBINE_ST_ACTIVE2,
        LARGETURBINE_ST_ACTIVE3,
        LARGETURBINE_ST_ACTIVE4,
        LARGETURBINE_ST_ACTIVE5,
        LARGETURBINE_ST_ACTIVE6,
        LARGETURBINE_ST_ACTIVE7,
        LARGETURBINE_ST_ACTIVE8,
        LARGETURBINE_ST_ACTIVE9,
        LARGETURBINE_SS1,
        LARGETURBINE_SS2,
        LARGETURBINE_SS3,
        LARGETURBINE_SS4,
        LARGETURBINE_SS5,
        LARGETURBINE_SS6,
        LARGETURBINE_SS7,
        LARGETURBINE_SS8,
        LARGETURBINE_SS9,
        LARGETURBINE_SS_ACTIVE1,
        LARGETURBINE_SS_ACTIVE2,
        LARGETURBINE_SS_ACTIVE3,
        LARGETURBINE_SS_ACTIVE4,
        LARGETURBINE_SS_ACTIVE5,
        LARGETURBINE_SS_ACTIVE6,
        LARGETURBINE_SS_ACTIVE7,
        LARGETURBINE_SS_ACTIVE8,
        LARGETURBINE_SS_ACTIVE9,
        LARGETURBINE_TI1,
        LARGETURBINE_TI2,
        LARGETURBINE_TI3,
        LARGETURBINE_TI4,
        LARGETURBINE_TI5,
        LARGETURBINE_TI6,
        LARGETURBINE_TI7,
        LARGETURBINE_TI8,
        LARGETURBINE_TI9,
        LARGETURBINE_TI_ACTIVE1,
        LARGETURBINE_TI_ACTIVE2,
        LARGETURBINE_TI_ACTIVE3,
        LARGETURBINE_TI_ACTIVE4,
        LARGETURBINE_TI_ACTIVE5,
        LARGETURBINE_TI_ACTIVE6,
        LARGETURBINE_TI_ACTIVE7,
        LARGETURBINE_TI_ACTIVE8,
        LARGETURBINE_TI_ACTIVE9,
        LARGETURBINE_TU1,
        LARGETURBINE_TU2,
        LARGETURBINE_TU3,
        LARGETURBINE_TU4,
        LARGETURBINE_TU5,
        LARGETURBINE_TU6,
        LARGETURBINE_TU7,
        LARGETURBINE_TU8,
        LARGETURBINE_TU9,
        LARGETURBINE_TU_ACTIVE1,
        LARGETURBINE_TU_ACTIVE2,
        LARGETURBINE_TU_ACTIVE3,
        LARGETURBINE_TU_ACTIVE4,
        LARGETURBINE_TU_ACTIVE5,
        LARGETURBINE_TU_ACTIVE6,
        LARGETURBINE_TU_ACTIVE7,
        LARGETURBINE_TU_ACTIVE8,
        LARGETURBINE_TU_ACTIVE9,
        MACHINE_CASING_TURBINE,
        BLOCK_ADAMANTIUM,
        BLOCK_ALUMINIUM,
        BLOCK_AMERICIUM,
        BLOCK_ANNEALEDCOPPER,
        BLOCK_ANTIMONY,
        BLOCK_ARSENIC,
        BLOCK_ASTRALSILVER,
        BLOCK_BATTERYALLOY,
        BLOCK_BERYLLIUM,
        BLOCK_BISMUTH,
        BLOCK_BISMUTHBRONZE,
        BLOCK_BLACKBRONZE,
        BLOCK_BLACKSTEEL,
        BLOCK_BLUEALLOY,
        BLOCK_BLUESTEEL,
        BLOCK_BRASS,
        BLOCK_BRONZE,
        BLOCK_CAESIUM,
        BLOCK_CERIUM,
        BLOCK_CHROME,
        BLOCK_CHROMIUMDIOXIDE,
        BLOCK_COBALT,
        BLOCK_COBALTBRASS,
        BLOCK_COPPER,
        BLOCK_CUPRONICKEL,
        BLOCK_DAMASCUSSTEEL,
        BLOCK_DARKIRON,
        BLOCK_DEEPIRON,
        BLOCK_DESH,
        BLOCK_DURANIUM,
        BLOCK_DYSPROSIUM,
        BLOCK_ELECTRUM,
        BLOCK_ELECTRUMFLUX,
        BLOCK_ENDERIUM,
        BLOCK_ERBIUM,
        BLOCK_EUROPIUM,
        BLOCK_FIERYSTEEL,
        BLOCK_GADOLINIUM,
        BLOCK_GALLIUM,
        BLOCK_HOLMIUM,
        BLOCK_HSLA,
        BLOCK_INDIUM,
        BLOCK_INFUSEDGOLD,
        BLOCK_INVAR,
        BLOCK_IRIDIUM,
        BLOCK_IRONMAGNETIC,
        BLOCK_IRONWOOD,
        BLOCK_KANTHAL,
        BLOCK_KNIGHTMETAL,
        BLOCK_LANTHANUM,
        BLOCK_LEAD,
        BLOCK_LUTETIUM,
        BLOCK_MAGNALIUM,
        BLOCK_MAGNESIUM,
        BLOCK_MANGANESE,
        BLOCK_METEORICIRON,
        BLOCK_METEORICSTEEL,
        BLOCK_MIDASIUM,
        BLOCK_TRINIUM,
        BLOCK_MITHRIL,
        BLOCK_MOLYBDENUM,
        BLOCK_NAQUADAH,
        BLOCK_NAQUADAHALLOY,
        BLOCK_NAQUADAHENRICHED,
        BLOCK_NAQUADRIA,
        BLOCK_NEODYMIUM,
        BLOCK_NEODYMIUMMAGNETIC,
        BLOCK_NEUTRONIUM,
        BLOCK_NICHROME,
        BLOCK_NICKEL,
        BLOCK_NIOBIUM,
        BLOCK_NIOBIUMNITRIDE,
        BLOCK_NIOBIUMTITANIUM,
        BLOCK_OSMIRIDIUM,
        BLOCK_OSMIUM,
        BLOCK_PALLADIUM,
        BLOCK_PIGIRON,
        BLOCK_PLATINUM,
        BLOCK_PLUTONIUM,
        BLOCK_PLUTONIUM241,
        BLOCK_PRASEODYMIUM,
        BLOCK_PROMETHIUM,
        BLOCK_REDALLOY,
        BLOCK_REDSTEEL,
        BLOCK_ROSEGOLD,
        BLOCK_RUBIDIUM,
        BLOCK_SAMARIUM,
        BLOCK_SCANDIUM,
        BLOCK_SHADOWIRON,
        BLOCK_SHADOWSTEEL,
        BLOCK_SILICON,
        BLOCK_SILVER,
        BLOCK_SOLDERINGALLOY,
        BLOCK_STAINLESSSTEEL,
        BLOCK_STEEL,
        BLOCK_STEELMAGNETIC,
        BLOCK_STERLINGSILVER,
        BLOCK_SUNNARIUM,
        BLOCK_TANTALUM,
        BLOCK_TELLURIUM,
        BLOCK_TERBIUM,
        BLOCK_THAUMIUM,
        BLOCK_THORIUM,
        BLOCK_THULIUM,
        BLOCK_TIN,
        BLOCK_TINALLOY,
        BLOCK_TITANIUM,
        BLOCK_TRITANIUM,
        BLOCK_TUNGSTEN,
        BLOCK_TUNGSTENSTEEL,
        BLOCK_ULTIMET,
        BLOCK_URANIUM,
        BLOCK_URANIUM235,
        BLOCK_VANADIUM,
        BLOCK_VANADIUMGALLIUM,
        BLOCK_WROUGHTIRON,
        BLOCK_YTTRBIUM,
        BLOCK_YTTRIUM,
        BLOCK_YTTRIUMBARIUMCUPRATE,
        BLOCK_ZINC,
        BLOCK_TUNGSTENCARBIDE,
        BLOCK_VANADIUMSTEEL,
        BLOCK_HSSG,
        BLOCK_HSSE,
        BLOCK_HSSS,
        BLOCK_AERCRYSTAL,
        BLOCK_AMBER,
        BLOCK_AMETHYST,
        BLOCK_AQUACRYSTAL,
        BLOCK_BLUETOPAZ,
        BLOCK_CERTUSQUARTZ,
        BLOCK_DILITHIUM,
        BLOCK_ENDEREYE,
        BLOCK_ENDERPEARL,
        BLOCK_FOOLSRUBY,
        BLOCK_FORCE,
        BLOCK_FORCICIUM,
        BLOCK_FORCILLIUM,
        BLOCK_GREENSAPPHIRE,
        BLOCK_IGNISCRYSTAL,
        BLOCK_JASPER,
        BLOCK_LAZURITE,
        BLOCK_LIGNITE,
        BLOCK_MONAZITE,
        BLOCK_NITER,
        BLOCK_OLIVINE,
        BLOCK_OPAL,
        BLOCK_ORDOCRYSTAL,
        BLOCK_PERDITIOCRYSTAL,
        BLOCK_PHOSPHORUS,
        BLOCK_QUARTZITE,
        BLOCK_REDGARNET,
        BLOCK_RUBY,
        BLOCK_SAPPHIRE,
        BLOCK_SODALITE,
        BLOCK_TANZANITE,
        BLOCK_TERRACRYSTAL,
        BLOCK_TOPAZ,
        BLOCK_VINTEUM,
        BLOCK_YELLOWGARNET,
        BLOCK_NETHERSTAR,
        BLOCK_CHARCOAL,
        BLOCK_BLAZE,
        MARBLE_STONE,
        MARBLE_COBBLE,
        MARBLE_COBBLE_MOSSY,
        MARBLE_BRICKS,
        MARBLE_BRICKS_CRACKED,
        MARBLE_BRICKS_MOSSY,
        MARBLE_BRICKS_CHISELED,
        MARBLE_SMOOTH,
        BASALT_STONE,
        BASALT_COBBLE,
        BASALT_COBBLE_MOSSY,
        BASALT_BRICKS,
        BASALT_BRICKS_CRACKED,
        BASALT_BRICKS_MOSSY,
        BASALT_BRICKS_CHISELED,
        BASALT_SMOOTH,
        OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE,
        OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW,
        OVERLAY_FRONT_HEAT_EXCHANGER,
        OVERLAY_FRONT_HEAT_EXCHANGER_GLOW,
        OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE,
        OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW,
        OVERLAY_FRONT_PROCESSING_ARRAY,
        OVERLAY_FRONT_PROCESSING_ARRAY_GLOW,
        OVERLAY_FRONT_OIL_DRILL_ACTIVE,
        OVERLAY_FRONT_OIL_DRILL_ACTIVE_GLOW,
        OVERLAY_FRONT_OIL_DRILL,
        OVERLAY_FRONT_OIL_DRILL_GLOW,
        OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE,
        OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE_GLOW,
        OVERLAY_FRONT_DIESEL_ENGINE,
        OVERLAY_FRONT_DIESEL_ENGINE_GLOW,
        OVERLAY_FRONT_EXTREME_DIESEL_ENGINE_ACTIVE,
        OVERLAY_FRONT_EXTREME_DIESEL_ENGINE_ACTIVE_GLOW,
        OVERLAY_FRONT_EXTREME_DIESEL_ENGINE,
        OVERLAY_FRONT_EXTREME_DIESEL_ENGINE_GLOW,
        OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE,
        OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE_GLOW,
        OVERLAY_FRONT_PYROLYSE_OVEN,
        OVERLAY_FRONT_PYROLYSE_OVEN_GLOW,
        OVERLAY_FRONT_OIL_CRACKER_ACTIVE,
        OVERLAY_FRONT_OIL_CRACKER_ACTIVE_GLOW,
        OVERLAY_FRONT_OIL_CRACKER,
        OVERLAY_FRONT_OIL_CRACKER_GLOW,
        OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE,
        OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW,
        OVERLAY_FRONT_DISTILLATION_TOWER,
        OVERLAY_FRONT_DISTILLATION_TOWER_GLOW,
        OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE,
        OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW,
        OVERLAY_FRONT_ASSEMBLY_LINE,
        OVERLAY_FRONT_ASSEMBLY_LINE_GLOW,
        OVERLAY_FRONT_ORE_DRILL_ACTIVE,
        OVERLAY_FRONT_ORE_DRILL_ACTIVE_GLOW,
        OVERLAY_FRONT_ORE_DRILL,
        OVERLAY_FRONT_ORE_DRILL_GLOW,
        OVERLAY_TOP_CLEANROOM_ACTIVE,
        OVERLAY_TOP_CLEANROOM,
        OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR,
        OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW,
        OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE,
        OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW,
        PIPE_RESTRICTOR_UP,
        PIPE_RESTRICTOR_DOWN,
        PIPE_RESTRICTOR_LEFT,
        PIPE_RESTRICTOR_RIGHT,
        PIPE_RESTRICTOR_NU,
        PIPE_RESTRICTOR_ND,
        PIPE_RESTRICTOR_NL,
        PIPE_RESTRICTOR_NR,
        PIPE_RESTRICTOR_UD,
        PIPE_RESTRICTOR_UL,
        PIPE_RESTRICTOR_UR,
        PIPE_RESTRICTOR_DL,
        PIPE_RESTRICTOR_DR,
        PIPE_RESTRICTOR_LR,
        OVERLAY_ME_HATCH;

        public static final ITexture[] FRESHFOAM;
        public static final ITexture[][] HARDENEDFOAMS;
        public static final IIconContainer[] MACHINECASINGS_SIDE;
        public static final IIconContainer[] MACHINECASINGS_TOP;
        public static final IIconContainer[] MACHINECASINGS_BOTTOM;
        public static final IIconContainer[] GRANITES;
        public static final IIconContainer[] CONCRETES;
        public static final IIconContainer[] STONES;
        public static final IIconContainer[] TURBINE;
        public static final IIconContainer[] TURBINE_ACTIVE;
        public static final IIconContainer[] TURBINE1;
        public static final IIconContainer[] TURBINE_ACTIVE1;
        public static final IIconContainer[] TURBINE2;
        public static final IIconContainer[] TURBINE_ACTIVE2;
        public static final IIconContainer[] TURBINE3;
        public static final IIconContainer[] TURBINE_ACTIVE3;
        public static final IIconContainer[] CONNECTED_HULLS;
        public static final IIconContainer[] STORAGE_BLOCKS1;
        public static final IIconContainer[] STORAGE_BLOCKS2;
        public static final IIconContainer[] STORAGE_BLOCKS3;
        public static final IIconContainer[] STORAGE_BLOCKS4;
        public static final IIconContainer[] STORAGE_BLOCKS5;
        public static final IIconContainer[] STORAGE_BLOCKS6;
        public static final IIconContainer[] STORAGE_BLOCKS7;
        public static final IIconContainer[] STORAGE_BLOCKS8;
        public static final IIconContainer[] STORAGE_BLOCKS9;
        public static final IIconContainer[] STORAGE_BLOCKS10;
        public static final IIconContainer[] STORAGE_BLOCKS11;
        public static ITexture[] HIDDEN_TEXTURE;
        public static ITexture[] ERROR_RENDERING;
        public static ITexture[] OVERLAYS_ENERGY_IN;
        public static ITexture[] OVERLAYS_ENERGY_OUT;
        public static ITexture[] OVERLAYS_ENERGY_IN_MULTI;
        public static ITexture[] OVERLAYS_ENERGY_OUT_MULTI;
        public static ITexture[] OVERLAYS_ENERGY_IN_POWER;
        public static ITexture[] OVERLAYS_ENERGY_OUT_POWER;
        public static ITexture[] LOCKERS;
        @Deprecated
        public static ITexture[] CASING_BLOCKS;
        public static ITexture[][] MACHINE_CASINGS;
        public static ITexture[][] casingTexturePages;
        protected IIcon mIcon;

        private BlockIcons() {
            GregTech_API.sGTBlockIconload.add(this);
        }

        public static ITexture getCasingTextureForId(int id) {
            return casingTexturePages[id >> 7 & 0x7F][id & 0x7F];
        }

        public static void setCasingTextureForId(int id, ITexture iTexture) {
            BlockIcons.casingTexturePages[id >> 7 & 0x7F][id & 0x7F] = iTexture;
        }

        public static void setCasingTexture(byte page, byte index, ITexture iTexture) {
            BlockIcons.casingTexturePages[page][index] = iTexture;
        }

        @Override
        public IIcon getIcon() {
            return this.mIcon;
        }

        @Override
        public IIcon getOverlayIcon() {
            return null;
        }

        @Override
        public ResourceLocation getTextureFile() {
            return TextureMap.field_110575_b;
        }

        @Override
        public void run() {
            this.mIcon = GregTech_API.sBlockIcons.func_94245_a("gregtech:iconsets/" + this);
        }

        static {
            FRESHFOAM = new ITexture[]{TextureFactory.of(CFOAM_FRESH)};
            HARDENEDFOAMS = new ITexture[][]{{TextureFactory.of(CFOAM_HARDENED, Dyes.CONSTRUCTION_FOAM.mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[0].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[1].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[2].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[3].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[4].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[5].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[6].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[7].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[8].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[9].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[10].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[11].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[12].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[13].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[14].mRGBa)}, {TextureFactory.of(CFOAM_HARDENED, Dyes.VALUES[15].mRGBa)}};
            MACHINECASINGS_SIDE = new IIconContainer[]{MACHINE_8V_SIDE, MACHINE_LV_SIDE, MACHINE_MV_SIDE, MACHINE_HV_SIDE, MACHINE_EV_SIDE, MACHINE_IV_SIDE, MACHINE_LuV_SIDE, MACHINE_ZPM_SIDE, MACHINE_UV_SIDE, MACHINE_MAX_SIDE, MACHINE_UEV_SIDE, MACHINE_UIV_SIDE, MACHINE_UMV_SIDE, MACHINE_UXV_SIDE, MACHINE_OPV_SIDE, MACHINE_MAXV_SIDE};
            MACHINECASINGS_TOP = new IIconContainer[]{MACHINE_8V_TOP, MACHINE_LV_TOP, MACHINE_MV_TOP, MACHINE_HV_TOP, MACHINE_EV_TOP, MACHINE_IV_TOP, MACHINE_LuV_TOP, MACHINE_ZPM_TOP, MACHINE_UV_TOP, MACHINE_MAX_TOP, MACHINE_UEV_TOP, MACHINE_UIV_TOP, MACHINE_UMV_TOP, MACHINE_UXV_TOP, MACHINE_OPV_TOP, MACHINE_MAXV_TOP};
            MACHINECASINGS_BOTTOM = new IIconContainer[]{MACHINE_8V_BOTTOM, MACHINE_LV_BOTTOM, MACHINE_MV_BOTTOM, MACHINE_HV_BOTTOM, MACHINE_EV_BOTTOM, MACHINE_IV_BOTTOM, MACHINE_LuV_BOTTOM, MACHINE_ZPM_BOTTOM, MACHINE_UV_BOTTOM, MACHINE_MAX_BOTTOM, MACHINE_UEV_BOTTOM, MACHINE_UIV_BOTTOM, MACHINE_UMV_BOTTOM, MACHINE_UXV_BOTTOM, MACHINE_OPV_BOTTOM, MACHINE_MAXV_BOTTOM};
            GRANITES = new IIconContainer[]{GRANITE_BLACK_STONE, GRANITE_BLACK_COBBLE, GRANITE_BLACK_COBBLE_MOSSY, GRANITE_BLACK_BRICKS, GRANITE_BLACK_BRICKS_CRACKED, GRANITE_BLACK_BRICKS_MOSSY, GRANITE_BLACK_BRICKS_CHISELED, GRANITE_BLACK_SMOOTH, GRANITE_RED_STONE, GRANITE_RED_COBBLE, GRANITE_RED_COBBLE_MOSSY, GRANITE_RED_BRICKS, GRANITE_RED_BRICKS_CRACKED, GRANITE_RED_BRICKS_MOSSY, GRANITE_RED_BRICKS_CHISELED, GRANITE_RED_SMOOTH};
            CONCRETES = new IIconContainer[]{CONCRETE_DARK_STONE, CONCRETE_DARK_COBBLE, CONCRETE_DARK_COBBLE_MOSSY, CONCRETE_DARK_BRICKS, CONCRETE_DARK_BRICKS_CRACKED, CONCRETE_DARK_BRICKS_MOSSY, CONCRETE_DARK_BRICKS_CHISELED, CONCRETE_DARK_SMOOTH, CONCRETE_LIGHT_STONE, CONCRETE_LIGHT_COBBLE, CONCRETE_LIGHT_COBBLE_MOSSY, CONCRETE_LIGHT_BRICKS, CONCRETE_LIGHT_BRICKS_CRACKED, CONCRETE_LIGHT_BRICKS_MOSSY, CONCRETE_LIGHT_BRICKS_CHISELED, CONCRETE_LIGHT_SMOOTH};
            STONES = new IIconContainer[]{MARBLE_STONE, MARBLE_COBBLE, MARBLE_COBBLE_MOSSY, MARBLE_BRICKS, MARBLE_BRICKS_CRACKED, MARBLE_BRICKS_MOSSY, MARBLE_BRICKS_CHISELED, MARBLE_SMOOTH, BASALT_STONE, BASALT_COBBLE, BASALT_COBBLE_MOSSY, BASALT_BRICKS, BASALT_BRICKS_CRACKED, BASALT_BRICKS_MOSSY, BASALT_BRICKS_CHISELED, BASALT_SMOOTH};
            TURBINE = new IIconContainer[]{LARGETURBINE_ST1, LARGETURBINE_ST2, LARGETURBINE_ST3, LARGETURBINE_ST4, LARGETURBINE_ST5, LARGETURBINE_ST6, LARGETURBINE_ST7, LARGETURBINE_ST8, LARGETURBINE_ST9};
            TURBINE_ACTIVE = new IIconContainer[]{LARGETURBINE_ST_ACTIVE1, LARGETURBINE_ST_ACTIVE2, LARGETURBINE_ST_ACTIVE3, LARGETURBINE_ST_ACTIVE4, LARGETURBINE_ST_ACTIVE5, LARGETURBINE_ST_ACTIVE6, LARGETURBINE_ST_ACTIVE7, LARGETURBINE_ST_ACTIVE8, LARGETURBINE_ST_ACTIVE9};
            TURBINE1 = new IIconContainer[]{LARGETURBINE_SS1, LARGETURBINE_SS2, LARGETURBINE_SS3, LARGETURBINE_SS4, LARGETURBINE_SS5, LARGETURBINE_SS6, LARGETURBINE_SS7, LARGETURBINE_SS8, LARGETURBINE_SS9};
            TURBINE_ACTIVE1 = new IIconContainer[]{LARGETURBINE_SS_ACTIVE1, LARGETURBINE_SS_ACTIVE2, LARGETURBINE_SS_ACTIVE3, LARGETURBINE_SS_ACTIVE4, LARGETURBINE_SS_ACTIVE5, LARGETURBINE_SS_ACTIVE6, LARGETURBINE_SS_ACTIVE7, LARGETURBINE_SS_ACTIVE8, LARGETURBINE_SS_ACTIVE9};
            TURBINE2 = new IIconContainer[]{LARGETURBINE_TI1, LARGETURBINE_TI2, LARGETURBINE_TI3, LARGETURBINE_TI4, LARGETURBINE_TI5, LARGETURBINE_TI6, LARGETURBINE_TI7, LARGETURBINE_TI8, LARGETURBINE_TI9};
            TURBINE_ACTIVE2 = new IIconContainer[]{LARGETURBINE_TI_ACTIVE1, LARGETURBINE_TI_ACTIVE2, LARGETURBINE_TI_ACTIVE3, LARGETURBINE_TI_ACTIVE4, LARGETURBINE_TI_ACTIVE5, LARGETURBINE_TI_ACTIVE6, LARGETURBINE_TI_ACTIVE7, LARGETURBINE_TI_ACTIVE8, LARGETURBINE_TI_ACTIVE9};
            TURBINE3 = new IIconContainer[]{LARGETURBINE_TU1, LARGETURBINE_TU2, LARGETURBINE_TU3, LARGETURBINE_TU4, LARGETURBINE_TU5, LARGETURBINE_TU6, LARGETURBINE_TU7, LARGETURBINE_TU8, LARGETURBINE_TU9};
            TURBINE_ACTIVE3 = new IIconContainer[]{LARGETURBINE_TU_ACTIVE1, LARGETURBINE_TU_ACTIVE2, LARGETURBINE_TU_ACTIVE3, LARGETURBINE_TU_ACTIVE4, LARGETURBINE_TU_ACTIVE5, LARGETURBINE_TU_ACTIVE6, LARGETURBINE_TU_ACTIVE7, LARGETURBINE_TU_ACTIVE8, LARGETURBINE_TU_ACTIVE9};
            CONNECTED_HULLS = new IIconContainer[]{CONCRETE_DARK_STONE, FUSIONI_1, FUSIONI_2, FUSIONI_3, FUSIONI_4, FUSIONI_5, FUSIONI_6, FUSIONI_7, FUSIONI_8, FUSIONI_9, FUSIONI_10, FUSIONI_11, FUSIONI_12, FUSIONII_1, FUSIONII_2, FUSIONII_3, FUSIONII_4, FUSIONII_5, FUSIONII_6, FUSIONII_7, FUSIONII_8, FUSIONII_9, FUSIONII_10, FUSIONII_11, FUSIONII_12};
            STORAGE_BLOCKS1 = new IIconContainer[]{BLOCK_ADAMANTIUM, BLOCK_ALUMINIUM, BLOCK_AMERICIUM, BLOCK_ANNEALEDCOPPER, BLOCK_ANTIMONY, BLOCK_ARSENIC, BLOCK_ASTRALSILVER, BLOCK_BATTERYALLOY, BLOCK_BERYLLIUM, BLOCK_BISMUTH, BLOCK_BISMUTHBRONZE, BLOCK_BLACKBRONZE, BLOCK_BLACKSTEEL, BLOCK_BLUEALLOY, BLOCK_BLUESTEEL, BLOCK_BRASS};
            STORAGE_BLOCKS2 = new IIconContainer[]{BLOCK_BRONZE, BLOCK_CAESIUM, BLOCK_CERIUM, BLOCK_CHROME, BLOCK_CHROMIUMDIOXIDE, BLOCK_COBALT, BLOCK_COBALTBRASS, BLOCK_COPPER, BLOCK_CUPRONICKEL, BLOCK_DAMASCUSSTEEL, BLOCK_DARKIRON, BLOCK_DEEPIRON, BLOCK_DESH, BLOCK_DURANIUM, BLOCK_DYSPROSIUM, BLOCK_ELECTRUM};
            STORAGE_BLOCKS3 = new IIconContainer[]{BLOCK_ELECTRUMFLUX, BLOCK_ENDERIUM, BLOCK_ERBIUM, BLOCK_EUROPIUM, BLOCK_FIERYSTEEL, BLOCK_GADOLINIUM, BLOCK_GALLIUM, BLOCK_HOLMIUM, BLOCK_HSLA, BLOCK_INDIUM, BLOCK_INFUSEDGOLD, BLOCK_INVAR, BLOCK_IRIDIUM, BLOCK_IRONMAGNETIC, BLOCK_IRONWOOD, BLOCK_KANTHAL};
            STORAGE_BLOCKS4 = new IIconContainer[]{BLOCK_KNIGHTMETAL, BLOCK_LANTHANUM, BLOCK_LEAD, BLOCK_LUTETIUM, BLOCK_MAGNALIUM, BLOCK_MAGNESIUM, BLOCK_MANGANESE, BLOCK_METEORICIRON, BLOCK_METEORICSTEEL, BLOCK_TRINIUM, BLOCK_MITHRIL, BLOCK_MOLYBDENUM, BLOCK_NAQUADAH, BLOCK_NAQUADAHALLOY, BLOCK_NAQUADAHENRICHED, BLOCK_NAQUADRIA};
            STORAGE_BLOCKS5 = new IIconContainer[]{BLOCK_NEODYMIUM, BLOCK_NEODYMIUMMAGNETIC, BLOCK_NEUTRONIUM, BLOCK_NICHROME, BLOCK_NICKEL, BLOCK_NIOBIUM, BLOCK_NIOBIUMNITRIDE, BLOCK_NIOBIUMTITANIUM, BLOCK_OSMIRIDIUM, BLOCK_OSMIUM, BLOCK_PALLADIUM, BLOCK_PIGIRON, BLOCK_PLATINUM, BLOCK_PLUTONIUM, BLOCK_PLUTONIUM241, BLOCK_PRASEODYMIUM};
            STORAGE_BLOCKS6 = new IIconContainer[]{BLOCK_PROMETHIUM, BLOCK_REDALLOY, BLOCK_REDSTEEL, BLOCK_ROSEGOLD, BLOCK_RUBIDIUM, BLOCK_SAMARIUM, BLOCK_SCANDIUM, BLOCK_SHADOWIRON, BLOCK_SHADOWSTEEL, BLOCK_SILICON, BLOCK_SILVER, BLOCK_SOLDERINGALLOY, BLOCK_STAINLESSSTEEL, BLOCK_STEEL, BLOCK_STEELMAGNETIC, BLOCK_STERLINGSILVER};
            STORAGE_BLOCKS7 = new IIconContainer[]{BLOCK_SUNNARIUM, BLOCK_TANTALUM, BLOCK_TELLURIUM, BLOCK_TERBIUM, BLOCK_THAUMIUM, BLOCK_THORIUM, BLOCK_THULIUM, BLOCK_TIN, BLOCK_TINALLOY, BLOCK_TITANIUM, BLOCK_TRITANIUM, BLOCK_TUNGSTEN, BLOCK_TUNGSTENSTEEL, BLOCK_ULTIMET, BLOCK_URANIUM, BLOCK_URANIUM235};
            STORAGE_BLOCKS8 = new IIconContainer[]{BLOCK_VANADIUM, BLOCK_VANADIUMGALLIUM, BLOCK_WROUGHTIRON, BLOCK_YTTRBIUM, BLOCK_YTTRIUM, BLOCK_YTTRIUMBARIUMCUPRATE, BLOCK_ZINC, BLOCK_TUNGSTENCARBIDE, BLOCK_VANADIUMSTEEL, BLOCK_HSSG, BLOCK_HSSE, BLOCK_HSSS, BLOCK_STEELEAF, BLOCK_ICHORIUM, BLOCK_FIRESTONE, BLOCK_SHADOW};
            STORAGE_BLOCKS9 = new IIconContainer[]{BLOCK_AERCRYSTAL, BLOCK_AMBER, BLOCK_AMETHYST, BLOCK_AQUACRYSTAL, BLOCK_BLUETOPAZ, BLOCK_CERTUSQUARTZ, BLOCK_DILITHIUM, BLOCK_ENDEREYE, BLOCK_ENDERPEARL, BLOCK_FOOLSRUBY, BLOCK_FORCE, BLOCK_FORCICIUM, BLOCK_FORCILLIUM, BLOCK_GREENSAPPHIRE, BLOCK_IGNISCRYSTAL, BLOCK_JASPER};
            STORAGE_BLOCKS10 = new IIconContainer[]{BLOCK_LAZURITE, BLOCK_LIGNITE, BLOCK_MONAZITE, BLOCK_NITER, BLOCK_OLIVINE, BLOCK_OPAL, BLOCK_ORDOCRYSTAL, BLOCK_PERDITIOCRYSTAL, BLOCK_PHOSPHORUS, BLOCK_QUARTZITE, BLOCK_REDGARNET, BLOCK_RUBY, BLOCK_SAPPHIRE, BLOCK_SODALITE, BLOCK_TANZANITE, BLOCK_TERRACRYSTAL};
            STORAGE_BLOCKS11 = new IIconContainer[]{BLOCK_TOPAZ, BLOCK_VINTEUM, BLOCK_YELLOWGARNET, BLOCK_NETHERSTAR, BLOCK_CHARCOAL, BLOCK_BLAZE};
            HIDDEN_TEXTURE = new ITexture[]{TextureFactory.builder().addIcon(HIDDEN_FACE).stdOrient().build()};
            ERROR_RENDERING = new ITexture[]{TextureFactory.of(RENDERING_ERROR)};
            OVERLAYS_ENERGY_IN = new ITexture[]{TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{180, 180, 180, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{220, 220, 220, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{255, 100, 0, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{255, 255, 30, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{128, 128, 128, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{240, 240, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{220, 220, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{200, 200, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{180, 180, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{160, 160, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{140, 140, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{120, 120, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{100, 100, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{80, 80, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{60, 60, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN, new short[]{40, 40, 245, 0})};
            OVERLAYS_ENERGY_OUT = new ITexture[]{TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{180, 180, 180, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{220, 220, 220, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{255, 100, 0, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{255, 255, 30, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{128, 128, 128, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{240, 240, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{220, 220, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{200, 200, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{180, 180, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{160, 160, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{140, 140, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{120, 120, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{100, 100, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{80, 80, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{60, 60, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT, new short[]{40, 40, 245, 0})};
            OVERLAYS_ENERGY_IN_MULTI = new ITexture[]{TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{180, 180, 180, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{220, 220, 220, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{255, 100, 0, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{255, 255, 30, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{128, 128, 128, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{240, 240, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{220, 220, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{200, 200, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{180, 180, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{160, 160, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{140, 140, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{120, 120, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{100, 100, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{80, 80, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{60, 60, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_MULTI, new short[]{40, 40, 245, 0})};
            OVERLAYS_ENERGY_OUT_MULTI = new ITexture[]{TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{180, 180, 180, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{220, 220, 220, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{255, 100, 0, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{255, 255, 30, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{128, 128, 128, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{240, 240, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{220, 220, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{200, 200, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{180, 180, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{160, 160, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{140, 140, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{120, 120, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{100, 100, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{80, 80, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{60, 60, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_MULTI, new short[]{40, 40, 245, 0})};
            OVERLAYS_ENERGY_IN_POWER = new ITexture[]{TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{180, 180, 180, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{220, 220, 220, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{255, 100, 0, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{255, 255, 30, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{128, 128, 128, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{240, 240, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{220, 220, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{200, 200, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{180, 180, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{160, 160, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{140, 140, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{120, 120, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{100, 100, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{80, 80, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{60, 60, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_IN_POWER, new short[]{40, 40, 245, 0})};
            OVERLAYS_ENERGY_OUT_POWER = new ITexture[]{TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{180, 180, 180, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{220, 220, 220, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{255, 100, 0, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{255, 255, 30, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{128, 128, 128, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{240, 240, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{220, 220, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{200, 200, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{180, 180, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{160, 160, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{140, 140, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{120, 120, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{100, 100, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{80, 80, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{60, 60, 245, 0}), TextureFactory.of(OVERLAY_ENERGY_OUT_POWER, new short[]{40, 40, 245, 0})};
            LOCKERS = new ITexture[]{TextureFactory.of(OVERLAY_LOCKER_000), TextureFactory.of(OVERLAY_LOCKER_001), TextureFactory.of(OVERLAY_LOCKER_002), TextureFactory.of(OVERLAY_LOCKER_003), TextureFactory.of(OVERLAY_LOCKER_004), TextureFactory.of(OVERLAY_LOCKER_005), TextureFactory.of(OVERLAY_LOCKER_006), TextureFactory.of(OVERLAY_LOCKER_007), TextureFactory.of(OVERLAY_LOCKER_008), TextureFactory.of(OVERLAY_LOCKER_009), TextureFactory.of(OVERLAY_LOCKER_010), TextureFactory.of(OVERLAY_LOCKER_011), TextureFactory.of(OVERLAY_LOCKER_012), TextureFactory.of(OVERLAY_LOCKER_013)};
            CASING_BLOCKS = new ITexture[128];
            MACHINE_CASINGS = new ITexture[16][17];
            casingTexturePages = new ITexture[128][];
            for (int i = 0; i < MACHINE_CASINGS.length; i = (int)((byte)(i + 1))) {
                for (int j = 0; j < MACHINE_CASINGS[i].length; j = (int)((byte)(j + 1))) {
                    BlockIcons.MACHINE_CASINGS[i][j] = TextureFactory.of(MACHINECASINGS_BOTTOM[i], MACHINECASINGS_TOP[i], MACHINECASINGS_SIDE[i], Dyes.getModulation(j - 1, Dyes.MACHINE_METAL.mRGBa));
                }
            }
            BlockIcons.casingTexturePages[0] = new ITexture[128];
            GT_Utility.addTexturePage((byte)1);
            GT_Utility.addTexturePage((byte)8);
        }

        public static class CustomIcon
        implements IIconContainer,
        Runnable {
            protected IIcon mIcon;
            protected String mIconName;

            public CustomIcon(String aIconName) {
                this.mIconName = aIconName;
                GregTech_API.sGTBlockIconload.add(this);
            }

            @Override
            public IIcon getIcon() {
                return this.mIcon;
            }

            @Override
            public IIcon getOverlayIcon() {
                return null;
            }

            @Override
            public ResourceLocation getTextureFile() {
                return TextureMap.field_110575_b;
            }

            @Override
            public void run() {
                this.mIcon = GregTech_API.sBlockIcons.func_94245_a("gregtech:" + this.mIconName);
            }
        }
    }
}

