/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import appeng.util.item.ItemList;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.AE2DigitalChestHandler;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.gui.GT_Container_QuantumChest;
import gregtech.common.gui.GT_GUIContainer_QuantumChest;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

@Optional.Interface(iface="appeng.api.storage.IMEMonitor", modid="appliedenergistics2", striprefs=true)
public abstract class GT_MetaTileEntity_DigitalChestBase
extends GT_MetaTileEntity_TieredMachineBlock
implements IMEMonitor<IAEItemStack> {
    protected boolean mVoidOverflow = false;
    private Map<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = null;

    public GT_MetaTileEntity_DigitalChestBase(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, new String[]{"This Chest stores " + GT_MetaTileEntity_DigitalChestBase.commonSizeCompute(aTier) + " Blocks", "Use a screwdriver to enable", "voiding items on overflow"}, new ITexture[0]);
    }

    protected static int commonSizeCompute(int tier) {
        switch (tier) {
            case 1: {
                return 4000000;
            }
            case 2: {
                return 8000000;
            }
            case 3: {
                return 16000000;
            }
            case 4: {
                return 32000000;
            }
            case 5: {
                return 64000000;
            }
            case 6: {
                return 128000000;
            }
            case 7: {
                return 256000000;
            }
            case 8: {
                return 512000000;
            }
            case 9: {
                return 1024000000;
            }
            case 10: {
                return 0x7FFFFFF8;
            }
        }
        return 0;
    }

    public GT_MetaTileEntity_DigitalChestBase(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_DigitalChestBase(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Optional.Method(modid="appliedenergistics2")
    public static void registerAEIntegration() {
        AEApi.instance().registries().externalStorage().addExternalStorageInterface((IExternalStorageHandler)new AE2DigitalChestHandler());
    }

    @Optional.Method(modid="appliedenergistics2")
    public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver, Object o) {
        if (this.listeners == null) {
            this.listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
        }
        this.listeners.put(imeMonitorHandlerReceiver, o);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> imeMonitorHandlerReceiver) {
        if (this.listeners == null) {
            this.listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
        }
        this.listeners.remove(imeMonitorHandlerReceiver);
    }

    @Optional.Method(modid="appliedenergistics2")
    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isPrioritized(IAEItemStack iaeItemStack) {
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean canAccept(IAEItemStack iaeItemStack) {
        ItemStack s = this.getItemStack();
        if (s == null || iaeItemStack == null) {
            return true;
        }
        return iaeItemStack.isSameType(s);
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getPriority() {
        return 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int getSlot() {
        return 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean validForPass(int i) {
        return true;
    }

    protected abstract ItemStack getItemStack();

    protected abstract void setItemStack(ItemStack var1);

    @Optional.Method(modid="appliedenergistics2")
    public IItemList<IAEItemStack> getAvailableItems(IItemList out) {
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null) {
            AEItemStack s = AEItemStack.create((ItemStack)storedStack);
            s.setStackSize((long)this.getItemCount());
            out.add((IAEStack)s);
        }
        return out;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IItemList<IAEItemStack> getStorageList() {
        ItemList res = new ItemList();
        ItemStack storedStack = this.getItemStack();
        if (storedStack != null) {
            AEItemStack s = AEItemStack.create((ItemStack)storedStack);
            s.setStackSize((long)this.getItemCount());
            res.add((IAEStack)s);
        }
        return res;
    }

    protected abstract int getItemCount();

    @Override
    public abstract void setItemCount(int var1);

    @Override
    public int getMaxItemCount() {
        return GT_MetaTileEntity_DigitalChestBase.commonSizeCompute(this.mTier);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_QuantumChest(aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_QuantumChest(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack injectItems(IAEItemStack input, Actionable mode, BaseActionSource src) {
        ItemStack storedStack;
        ItemStack inputStack = input.getItemStack();
        if (inputStack == null) {
            return null;
        }
        if (mode != Actionable.SIMULATE) {
            this.getBaseMetaTileEntity().markDirty();
        }
        if ((storedStack = this.getItemStack()) != null) {
            if (GT_Utility.areStacksEqual(storedStack, inputStack)) {
                if (input.getStackSize() + (long)this.getItemCount() > (long)this.getMaxItemCount()) {
                    if (this.mVoidOverflow) {
                        if (mode != Actionable.SIMULATE) {
                            this.setItemCount(this.getMaxItemCount());
                        }
                        return null;
                    }
                    return this.createOverflowStack(input.getStackSize() + (long)this.getItemCount(), mode);
                }
                if (mode != Actionable.SIMULATE) {
                    this.setItemCount(this.getItemCount() + (int)input.getStackSize());
                }
                return null;
            }
            return input;
        }
        if (mode != Actionable.SIMULATE) {
            this.setItemStack(inputStack.copy());
        }
        if (input.getStackSize() > (long)this.getMaxItemCount()) {
            return this.createOverflowStack(input.getStackSize(), mode);
        }
        if (mode != Actionable.SIMULATE) {
            this.setItemCount((int)input.getStackSize());
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    private IAEItemStack createOverflowStack(long size, Actionable mode) {
        AEItemStack overflow = AEItemStack.create((ItemStack)this.getItemStack());
        overflow.setStackSize(size - (long)this.getMaxItemCount());
        if (mode != Actionable.SIMULATE) {
            this.setItemCount(this.getMaxItemCount());
        }
        return overflow;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        if (request.isSameType(this.getItemStack())) {
            if (mode != Actionable.SIMULATE) {
                this.getBaseMetaTileEntity().markDirty();
            }
            if (request.getStackSize() >= (long)this.getItemCount()) {
                AEItemStack result = AEItemStack.create((ItemStack)this.getItemStack());
                result.setStackSize((long)this.getItemCount());
                if (mode != Actionable.SIMULATE) {
                    this.setItemCount(0);
                }
                return result;
            }
            if (mode != Actionable.SIMULATE) {
                this.setItemCount(this.getItemCount() - (int)request.getStackSize());
            }
            return request.copy();
        }
        return null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mVoidOverflow = !this.mVoidOverflow;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.translateToLocal((String)(this.mVoidOverflow ? "GT5U.machines.voidoveflow.enabled" : "GT5U.machines.voidoveflow.disabled")));
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            if (this.getItemCount() <= 0) {
                this.setItemStack(null);
                this.setItemCount(0);
            }
            if (this.getItemStack() == null && this.mInventory[0] != null) {
                this.setItemStack(this.mInventory[0].copy());
            }
            int count = this.getItemCount();
            ItemStack stack = this.getItemStack();
            int savedCount = count;
            if (this.mInventory[0] != null && (count < this.getMaxItemCount() || this.mVoidOverflow) && GT_Utility.areStacksEqual(this.mInventory[0], stack)) {
                if ((count += this.mInventory[0].stackSize) <= this.getMaxItemCount()) {
                    this.mInventory[0] = null;
                } else {
                    if (this.mVoidOverflow) {
                        this.mInventory[0] = null;
                    } else {
                        this.mInventory[0].stackSize = count - this.getMaxItemCount();
                    }
                    count = this.getMaxItemCount();
                }
            }
            if (this.mInventory[1] == null && stack != null) {
                this.mInventory[1] = stack.copy();
                this.mInventory[1].stackSize = Math.min(stack.getMaxStackSize(), count);
                count -= this.mInventory[1].stackSize;
            } else if (count > 0 && GT_Utility.areStacksEqual(this.mInventory[1], stack) && this.mInventory[1].getMaxStackSize() > this.mInventory[1].stackSize) {
                int tmp = Math.min(count, this.mInventory[1].getMaxStackSize() - this.mInventory[1].stackSize);
                this.mInventory[1].stackSize += tmp;
                count -= tmp;
            }
            this.setItemCount(count);
            if (stack != null) {
                this.mInventory[2] = stack.copy();
                this.mInventory[2].stackSize = Math.min(stack.getMaxStackSize(), count);
            } else {
                this.mInventory[2] = null;
            }
            if (GregTech_API.mAE2) {
                this.notifyListeners(count - savedCount, stack);
            }
            if (count != savedCount) {
                this.getBaseMetaTileEntity().markDirty();
            }
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!aBaseMetaTileEntity.isClientSide()) {
            aBaseMetaTileEntity.openGUI(aPlayer);
        }
        return true;
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.getItemCount() + (this.mInventory[0] == null ? 0 : this.mInventory[0].stackSize) + (this.mInventory[1] == null ? 0 : this.mInventory[1].stackSize);
    }

    @Override
    public int maxProgresstime() {
        return this.getMaxItemCount();
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        if (this.getItemStack() == null) {
            return new String[]{EnumChatFormatting.BLUE + this.chestName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GOLD + "No Items" + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + "0" + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + this.getMaxItemCount() + EnumChatFormatting.RESET};
        }
        return new String[]{EnumChatFormatting.BLUE + this.chestName() + EnumChatFormatting.RESET, "Stored Items:", EnumChatFormatting.GOLD + this.getItemStack().getDisplayName() + EnumChatFormatting.RESET, EnumChatFormatting.GREEN + Integer.toString(this.getItemCount()) + EnumChatFormatting.RESET + " " + EnumChatFormatting.YELLOW + this.getMaxItemCount() + EnumChatFormatting.RESET};
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return this.mInventory;
    }

    protected abstract String chestName();

    @Optional.Method(modid="appliedenergistics2")
    private void notifyListeners(int count, ItemStack stack) {
        if (this.listeners == null) {
            this.listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
            return;
        }
        if (count == 0 || stack == null) {
            return;
        }
        ItemList change = new ItemList();
        AEItemStack s = AEItemStack.create((ItemStack)stack);
        s.setStackSize((long)count);
        change.add((IAEItemStack)s);
        this.listeners.forEach((l, o) -> {
            if (l.isValid(o)) {
                l.postChange((IBaseMonitor)this, (Iterable)change, null);
            } else {
                this.removeListener((IMEMonitorHandlerReceiver<IAEItemStack>)l);
            }
        });
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.setInteger("mItemCount", this.getItemCount());
        if (this.getItemStack() != null) {
            aNBT.setTag("mItemStack", (NBTBase)this.getItemStack().writeToNBT(new NBTTagCompound()));
        }
        aNBT.setBoolean("mVoidOverflow", this.mVoidOverflow);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (aNBT.hasKey("mItemCount")) {
            this.setItemCount(aNBT.getInteger("mItemCount"));
        }
        if (aNBT.hasKey("mItemStack")) {
            this.setItemStack(ItemStack.loadItemStackFromNBT((NBTTagCompound)((NBTTagCompound)aNBT.getTag("mItemStack"))));
        }
        this.mVoidOverflow = aNBT.getBoolean("mVoidOverflow");
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 1;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex == 0 && (this.mInventory[0] == null || GT_Utility.areStacksEqual(this.mInventory[0], aStack));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide != aFacing) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1]};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_SCHEST), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_SCHEST_GLOW).glow().build()};
    }
}

