/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.api.GregTech_API;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.common.GT_Pollution;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;

public class GT_MetaTileEntity_Charcoal_Pit
extends GT_MetaTileEntity_MultiBlockBase {
    private boolean running = false;

    public GT_MetaTileEntity_Charcoal_Pit(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_Charcoal_Pit(String aName) {
        super(aName);
    }

    @Override
    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!this.checkRecursiveBlocks()) {
            this.mEfficiency = 0;
            this.mEfficiencyIncrease = 0;
            this.mMaxProgresstime = 0;
            this.running = false;
            return false;
        }
        if (this.mEfficiency == 0) {
            this.mEfficiency = 10000;
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            GT_Pollution.addPollution(this.getBaseMetaTileEntity(), this.mMaxProgresstime * 10);
            return true;
        }
        this.mEfficiency = 0;
        this.mEfficiencyIncrease = 0;
        this.mMaxProgresstime = 0;
        return false;
    }

    private boolean checkRecursiveBlocks() {
        ArrayList tList1 = new ArrayList();
        ArrayList<ChunkPosition> tList2 = new ArrayList<ChunkPosition>();
        Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(0, -1, 0);
        if (this.isWoodLog(tBlock, this.getBaseMetaTileEntity().getMetaIDOffset(0, -1, 0))) {
            tList2.add(new ChunkPosition(0, -1, 0));
        } else {
            return false;
        }
        while (!tList2.isEmpty()) {
            ChunkPosition tPos = (ChunkPosition)tList2.get(0);
            tList2.remove(0);
            if (this.checkAllBlockSides(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ, tList1, tList2)) continue;
            return false;
        }
        if (this.running) {
            for (ChunkPosition tPos : tList1) {
                if (!this.isWoodLog(this.getBaseMetaTileEntity().getBlockOffset(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ), this.getBaseMetaTileEntity().getMetaIDOffset(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ))) continue;
                this.getBaseMetaTileEntity().getWorld().setBlock(this.getBaseMetaTileEntity().getXCoord() + tPos.chunkPosX, this.getBaseMetaTileEntity().getYCoord() + tPos.chunkPosY, this.getBaseMetaTileEntity().getZCoord() + tPos.chunkPosZ, GregTech_API.sBlockReinforced, 4, 3);
            }
            this.running = false;
            return false;
        }
        this.mMaxProgresstime = (int)Math.sqrt(tList1.size() * 240000);
        this.running = true;
        return true;
    }

    private boolean isWoodLog(Block log, int meta) {
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(log, 1, meta))) {
            if (!OreDictionary.getOreName((int)id).equals("logWood")) continue;
            return true;
        }
        String tTool = log.getHarvestTool(meta);
        return OrePrefixes.log.contains(new ItemStack(log, 1, meta)) && "axe".equals(tTool) && log.getMaterial() == Material.wood;
    }

    private boolean checkAllBlockSides(int aX, int aY, int aZ, ArrayList<? super ChunkPosition> aList1, ArrayList<? super ChunkPosition> aList2) {
        boolean expandToChunkXPos = false;
        boolean expandToChunkXNeg = false;
        boolean expandToChunkYPos = false;
        boolean expandToChunkYNeg = false;
        boolean expandToChunkZPos = false;
        boolean expandToChunkZNeg = false;
        Block blockXPos = this.getBaseMetaTileEntity().getBlockOffset(aX + 1, aY, aZ);
        if (aX + 1 < 6 && this.isWoodLog(blockXPos, this.getBaseMetaTileEntity().getMetaIDOffset(aX + 1, aY, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX + 1, aY, aZ)) && !aList2.contains(new ChunkPosition(aX + 1, aY, aZ))) {
                expandToChunkXPos = true;
            }
        } else if (blockXPos != Blocks.dirt && blockXPos != Blocks.grass) {
            return false;
        }
        Block blockXNeg = this.getBaseMetaTileEntity().getBlockOffset(aX - 1, aY, aZ);
        if (aX - 1 > -6 && this.isWoodLog(blockXNeg, this.getBaseMetaTileEntity().getMetaIDOffset(aX - 1, aY, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX - 1, aY, aZ)) && !aList2.contains(new ChunkPosition(aX - 1, aY, aZ))) {
                expandToChunkXNeg = true;
            }
        } else if (blockXNeg != Blocks.dirt && blockXNeg != Blocks.grass) {
            return false;
        }
        Block blockYPos = this.getBaseMetaTileEntity().getBlockOffset(aX, aY + 1, aZ);
        if (aY + 1 < 1 && this.isWoodLog(blockYPos, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY + 1, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX, aY + 1, aZ)) && !aList2.contains(new ChunkPosition(aX, aY + 1, aZ))) {
                expandToChunkYPos = true;
            }
        } else if (blockYPos != Blocks.dirt && blockYPos != Blocks.grass && (aX != 0 || aY != -1 || aZ != 0 || blockYPos != GregTech_API.sBlockMachines)) {
            return false;
        }
        Block blockYNeg = this.getBaseMetaTileEntity().getBlockOffset(aX, aY - 1, aZ);
        if (aY - 1 > -6 && this.isWoodLog(blockYNeg, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY - 1, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX, aY - 1, aZ)) && !aList2.contains(new ChunkPosition(aX, aY - 1, aZ))) {
                expandToChunkYNeg = true;
            }
        } else if (blockYNeg != Blocks.brick_block) {
            return false;
        }
        Block blockZPos = this.getBaseMetaTileEntity().getBlockOffset(aX, aY, aZ + 1);
        if (aZ + 1 < 6 && this.isWoodLog(blockZPos, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY, aZ + 1))) {
            if (!aList1.contains(new ChunkPosition(aX, aY, aZ + 1)) && !aList2.contains(new ChunkPosition(aX, aY, aZ + 1))) {
                expandToChunkZPos = true;
            }
        } else if (blockZPos != Blocks.dirt && blockZPos != Blocks.grass) {
            return false;
        }
        Block blockZNeg = this.getBaseMetaTileEntity().getBlockOffset(aX, aY, aZ - 1);
        if (aZ - 1 > -6 && this.isWoodLog(blockZNeg, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY, aZ - 1))) {
            if (!aList1.contains(new ChunkPosition(aX, aY, aZ - 1)) && !aList2.contains(new ChunkPosition(aX, aY, aZ - 1))) {
                expandToChunkZNeg = true;
            }
        } else if (blockZNeg != Blocks.dirt && blockZNeg != Blocks.grass) {
            return false;
        }
        aList1.add((ChunkPosition)new ChunkPosition(aX, aY, aZ));
        if (expandToChunkXPos) {
            aList2.add((ChunkPosition)new ChunkPosition(aX + 1, aY, aZ));
        }
        if (expandToChunkXNeg) {
            aList2.add((ChunkPosition)new ChunkPosition(aX - 1, aY, aZ));
        }
        if (expandToChunkYPos) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY + 1, aZ));
        }
        if (expandToChunkYNeg) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY - 1, aZ));
        }
        if (expandToChunkZPos) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY, aZ + 1));
        }
        if (expandToChunkZNeg) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY, aZ - 1));
        }
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mWrench = true;
        this.mScrewdriver = true;
        this.mSoftHammer = true;
        this.mHardHammer = true;
        this.mSolderingTool = true;
        this.mCrowbar = true;
        return true;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Charcoal_Pit(this.mName);
    }

    @Override
    public String[] getDescription() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Charcoal Pile Igniter").addInfo("Controller for the Charcoal Pit").addInfo("Converts Logs into Brittle Charcoal blocks").addInfo("Will automatically start when valid").addPollutionAmount(100).addSeparator().beginVariableStructureBlock(3, 11, 3, 6, 3, 11, false).addStructureInfo("Can be up to 11x6x11 in size, shape doesn't matter").addOtherStructurePart("Bricks", "Bottom layer, under all wood logs").addOtherStructurePart("Dirt/Grass", "All logs must be covered by these, the controller, or bricks").addOtherStructurePart("Wood Logs", "Inside the previously mentioned blocks").addStructureInfo("No air between logs allowed").toolTipFinisher("Gregtech");
        if (Keyboard.isKeyDown((int)42)) {
            return tt.getStructureInformation();
        }
        return tt.getInformation();
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == 1) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][10], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][10], TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_ROCK_BREAKER)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][10]};
    }
}

